/*
 * Decompiled with CFR 0.152.
 */
package pro.avodonosov.mvnhashver;

import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.maven.execution.ProjectDependencyGraph;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import pro.avodonosov.mvnhashver.HashVerMojo;
import pro.avodonosov.mvnhashver.Utils;

@Mojo(name="projects-to-build", aggregator=true)
public class ProjectsToBuildMojo
extends HashVerMojo {
    @Parameter(property="dbDir", required=true)
    String dbDirPath;
    private static final byte[] DB_FILE_CONTENT = "1".getBytes(StandardCharsets.UTF_8);

    @Override
    public void execute() throws MojoExecutionException, MojoFailureException {
        File dbDir = new File(this.dbDirPath);
        if (!dbDir.isDirectory()) {
            throw new MojoExecutionException("Directory does not exist: " + dbDir.getAbsolutePath());
        }
        File targetDir = new File("target");
        File dbAdditionsDir = new File(targetDir, "hashver-db-additions");
        ProjectsToBuildMojo.ensureDirExists(dbAdditionsDir);
        try {
            Utils.cleanDir(dbAdditionsDir);
        }
        catch (IOException e) {
            throw new MojoExecutionException("Error cleaning " + dbAdditionsDir, (Exception)e);
        }
        Map<String, String> hashVers = super.executeImpl(this.mavenSession, this.includeGroupId, this.extraHashData);
        HashSet<MavenProject> affectedProjects = new HashSet<MavenProject>();
        for (MavenProject prj2 : this.mavenSession.getProjects()) {
            String hashVer;
            if (ProjectsToBuildMojo.dbContains(dbDir, prj2, hashVer = hashVers.get(this.hashVerKey(prj2, this.includeGroupId)))) continue;
            affectedProjects.add(prj2);
        }
        ProjectDependencyGraph depGraph = this.mavenSession.getProjectDependencyGraph();
        Stream dependencies = affectedProjects.stream().flatMap(prj -> depGraph.getUpstreamProjects(prj, true).stream());
        HashSet unaffectedButBuilt = dependencies.filter(p -> !affectedProjects.contains(p)).collect(Collectors.toCollection(HashSet::new));
        HashSet notBuilt = this.mavenSession.getProjects().stream().filter(p -> !affectedProjects.contains(p) && !unaffectedButBuilt.contains(p)).collect(Collectors.toCollection(HashSet::new));
        for (MavenProject prj3 : affectedProjects) {
            ProjectsToBuildMojo.saveDbAddition(dbAdditionsDir, prj3, hashVers.get(this.hashVerKey(prj3, this.includeGroupId)));
        }
        String toBuild = ProjectsToBuildMojo.artifactIds(affectedProjects);
        this.logInfo("hashver-projects-to-build: " + toBuild);
        File affectedProjectsFile = new File(targetDir, "hashver-projects-to-build");
        this.logInfo("saving to " + affectedProjectsFile.getAbsolutePath());
        this.logInfo("The projects unaffected but to be built with the 'mvn -a': " + ProjectsToBuildMojo.artifactIds(unaffectedButBuilt));
        this.logInfo("The projects skipped completely: " + ProjectsToBuildMojo.artifactIds(notBuilt));
        try {
            Utils.saveToFile(affectedProjectsFile, toBuild);
        }
        catch (IOException e) {
            throw new MojoExecutionException("Error saving 'projects to build' file", (Exception)e);
        }
    }

    private static String artifactIds(Collection<MavenProject> projects) {
        return projects.stream().map(p -> ":" + p.getArtifactId()).sorted().collect(Collectors.joining(","));
    }

    static void saveDbAddition(File dir, MavenProject prj, String hashVer) throws MojoExecutionException {
        File f = ProjectsToBuildMojo.prjDbFile(dir, prj, hashVer);
        File parent = f.getParentFile();
        ProjectsToBuildMojo.ensureDirExists(parent);
        try {
            Utils.saveToFile(f, DB_FILE_CONTENT);
        }
        catch (IOException e) {
            throw new MojoExecutionException("Error saving file: " + f.getAbsolutePath());
        }
    }

    static void ensureDirExists(File dir) throws MojoExecutionException {
        if (!dir.exists() && !dir.mkdirs()) {
            throw new MojoExecutionException("Error creating directory: " + dir.getAbsolutePath());
        }
    }

    static boolean dbContains(File dir, MavenProject prj, String hashVer) {
        return ProjectsToBuildMojo.prjDbFile(dir, prj, hashVer).exists();
    }

    static File prjDbFile(File dbDir, MavenProject prj, String hashVer) {
        String artifact = prj.getArtifactId();
        int dotPos = hashVer.indexOf(46);
        if (dotPos < 0) {
            throw new IllegalArgumentException("hashver is expected to have dot inside: " + hashVer);
        }
        String verGroup = hashVer.substring(0, 1) + hashVer.substring(dotPos, dotPos + 2);
        File groupDir = new File(dbDir, artifact + "-" + verGroup);
        return new File(groupDir, hashVer);
    }
}

