/*
 * Decompiled with CFR 0.152.
 */
package pro.boto.datatype.classifiers;

import java.math.BigDecimal;
import java.math.BigInteger;
import pro.boto.datatype.classifiers.Classifier;
import pro.boto.datatype.parser.BigDecimalParser;
import pro.boto.datatype.parser.BigIntegerParser;

public final class NumberClassifier {
    private static final BigInteger BYTE_MIN = BigInteger.valueOf(-128L);
    private static final BigInteger BYTE_MAX = BigInteger.valueOf(127L);
    private static final BigInteger SHORT_MIN = BigInteger.valueOf(-32768L);
    private static final BigInteger SHORT_MAX = BigInteger.valueOf(32767L);
    private static final BigInteger INTEGER_MIN = BigInteger.valueOf(Integer.MIN_VALUE);
    private static final BigInteger INTEGER_MAX = BigInteger.valueOf(Integer.MAX_VALUE);
    private static final BigInteger LONG_MIN = BigInteger.valueOf(Long.MIN_VALUE);
    private static final BigInteger LONG_MAX = BigInteger.valueOf(Long.MAX_VALUE);
    private static final BigDecimal FLOAT_MAX = BigDecimal.valueOf(3.4028234663852886E38);
    private static final BigDecimal FLOAT_MIN = BigDecimal.valueOf(-3.4028234663852886E38);
    private static final BigDecimal DOUBLE_MAX = BigDecimal.valueOf(Double.MAX_VALUE);
    private static final BigDecimal DOUBLE_MIN = BigDecimal.valueOf(-1.7976931348623157E308);

    private NumberClassifier() {
    }

    public static boolean isComplementInteger(Object number) {
        return Classifier.isByte(number) || Classifier.isShort(number) || Classifier.isInteger(number) || Classifier.isLong(number);
    }

    public static boolean isFloatingPoint(Object number) {
        return Classifier.isFloat(number) || Classifier.isDouble(number);
    }

    public static boolean isInByteRange(Number number) {
        return NumberClassifier.isInRange(number, BYTE_MIN, BYTE_MAX);
    }

    public static boolean isInShortRange(Number number) {
        return NumberClassifier.isInRange(number, SHORT_MIN, SHORT_MAX);
    }

    public static boolean isInIntegerRange(Number number) {
        return NumberClassifier.isInRange(number, INTEGER_MIN, INTEGER_MAX);
    }

    public static boolean isInLongRange(Number number) {
        return NumberClassifier.isInRange(number, LONG_MIN, LONG_MAX);
    }

    public static boolean isInFloatRange(Number number) {
        return NumberClassifier.isInRange(number, FLOAT_MIN, FLOAT_MAX);
    }

    public static boolean isInDoubleRange(Number number) {
        return NumberClassifier.isInRange(number, DOUBLE_MIN, DOUBLE_MAX);
    }

    protected static boolean isInRange(Number number, BigInteger min, BigInteger max) {
        try {
            return NumberClassifier.isInRange(BigIntegerParser.toBigInteger(number), (Comparable)min, (Comparable)max);
        }
        catch (NumberFormatException e) {
            return false;
        }
    }

    protected static boolean isInRange(Number number, BigDecimal min, BigDecimal max) {
        try {
            return NumberClassifier.isInRange(BigDecimalParser.toBigDecimal(number), (Comparable)min, (Comparable)max);
        }
        catch (NumberFormatException e) {
            return false;
        }
    }

    private static boolean isInRange(Comparable number, Comparable min, Comparable max) {
        boolean IN_RANGE = false;
        return max.compareTo(number) >= 0 && min.compareTo(number) <= 0;
    }
}

