/*
 * Decompiled with CFR 0.152.
 */
package pro.boto.datatype.parser;

import java.math.BigDecimal;
import java.math.BigInteger;
import pro.boto.datatype.classifiers.Classifier;
import pro.boto.datatype.classifiers.NumberClassifier;

public final class BigDecimalParser {
    private BigDecimalParser() {
    }

    public static BigDecimal toBigDecimal(Object value) {
        if (Classifier.isNull(value) || Classifier.isBigDecimal(value)) {
            return (BigDecimal)value;
        }
        BigDecimal number = null;
        if (Classifier.isBigInteger(value)) {
            number = new BigDecimal((BigInteger)value);
        } else if (NumberClassifier.isComplementInteger(value)) {
            number = BigDecimal.valueOf(((Number)value).longValue());
        } else if (NumberClassifier.isFloatingPoint(value)) {
            number = BigDecimal.valueOf(((Number)value).doubleValue());
        } else if (Classifier.isNumber(value)) {
            number = BigDecimal.valueOf(((Number)value).doubleValue());
        }
        return number;
    }
}

