/*
 * Decompiled with CFR 0.152.
 */
package pro.boto.datatype.parser;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.RoundingMode;
import pro.boto.datatype.classifiers.Classifier;
import pro.boto.datatype.classifiers.NumberClassifier;

public final class BigIntegerParser {
    private BigIntegerParser() {
    }

    public static BigInteger toBigInteger(Object value) {
        return BigIntegerParser.toBigInteger(value, RoundingMode.HALF_EVEN);
    }

    public static BigInteger toBigInteger(Object value, RoundingMode mode) {
        if (Classifier.isNull(value) || Classifier.isBigInteger(value)) {
            return (BigInteger)value;
        }
        BigInteger converted = null;
        if (NumberClassifier.isComplementInteger(value)) {
            converted = BigInteger.valueOf(((Number)value).longValue());
        } else if (NumberClassifier.isFloatingPoint(value)) {
            converted = BigIntegerParser.round(BigDecimal.valueOf(((Number)value).doubleValue()), mode);
        } else if (Classifier.isBigDecimal(value)) {
            converted = BigIntegerParser.round((BigDecimal)value, mode);
        } else if (Classifier.isNumber(value)) {
            converted = BigIntegerParser.round(BigDecimal.valueOf(((Number)value).doubleValue()), mode);
        }
        return converted;
    }

    private static BigInteger round(BigDecimal value, RoundingMode mode) {
        return value.setScale(0, mode).toBigInteger();
    }
}

