/*
 * Decompiled with CFR 0.152.
 */
package pro.boto.datatype.parser;

import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.ObjectUtils;
import pro.boto.datatype.classifiers.Classifier;
import pro.boto.datatype.parser.IntegerParser;

public final class BooleanParser {
    private static final boolean DEFAULT_VALUE = false;

    private BooleanParser() {
    }

    public static boolean toPrimitive(Object value) {
        return (Boolean)ObjectUtils.defaultIfNull((Object)BooleanParser.toBoolean(value), (Object)false);
    }

    public static Boolean toBoolean(Object value) {
        if (Classifier.isNull(value) || Classifier.isBoolean(value)) {
            return (Boolean)value;
        }
        Boolean converted = null;
        if (Classifier.isNumber(value)) {
            converted = BooleanUtils.toBooleanObject((Integer)IntegerParser.toInteger(value));
        } else if (Classifier.isString(value)) {
            converted = BooleanUtils.toBooleanObject((String)((String)value));
        }
        return converted;
    }
}

