/*
 * Decompiled with CFR 0.152.
 */
package pro.boto.datatype.parser;

import org.apache.commons.lang3.ObjectUtils;
import pro.boto.datatype.classifiers.Classifier;
import pro.boto.datatype.classifiers.NumberClassifier;
import pro.boto.datatype.parser.BigIntegerParser;

public final class ByteParser {
    private static final byte DEFAULT_VALUE = 0;

    private ByteParser() {
    }

    public static byte toPrimitive(Object value) {
        return (Byte)ObjectUtils.defaultIfNull((Object)ByteParser.toByte(value), (Object)0);
    }

    public static Byte toByte(Object value) {
        if (Classifier.isNull(value) || Classifier.isByte(value)) {
            return (Byte)value;
        }
        Byte converted = null;
        if (Classifier.isNumber(value) && NumberClassifier.isInByteRange((Number)value)) {
            return BigIntegerParser.toBigInteger(value).byteValueExact();
        }
        return converted;
    }
}

