/*
 * Decompiled with CFR 0.152.
 */
package pro.boto.datatype.parser;

import org.apache.commons.lang3.ObjectUtils;
import pro.boto.datatype.classifiers.Classifier;
import pro.boto.datatype.classifiers.NumberClassifier;
import pro.boto.datatype.parser.BigDecimalParser;

public final class DoubleParser {
    private static final double DEFAULT_VALUE = 0.0;

    private DoubleParser() {
    }

    public static double toPrimitive(Object value) {
        return (Double)ObjectUtils.defaultIfNull((Object)DoubleParser.toDouble(value), (Object)0.0);
    }

    public static Double toDouble(Object value) {
        if (Classifier.isNull(value) || Classifier.isDouble(value)) {
            return (Double)value;
        }
        Double converted = null;
        if (Classifier.isNumber(value) && NumberClassifier.isInDoubleRange((Number)value)) {
            converted = BigDecimalParser.toBigDecimal(value).doubleValue();
        }
        return converted;
    }
}

