/*
 * Decompiled with CFR 0.152.
 */
package pro.boto.datatype.parser;

import org.apache.commons.lang3.ObjectUtils;
import pro.boto.datatype.classifiers.Classifier;
import pro.boto.datatype.classifiers.NumberClassifier;
import pro.boto.datatype.parser.BigDecimalParser;

public final class FloatParser {
    private static final float DEFAULT_VALUE = 0.0f;

    private FloatParser() {
    }

    public static float toPrimitive(Object value) {
        return ((Float)ObjectUtils.defaultIfNull((Object)FloatParser.toFloat(value), (Object)Float.valueOf(0.0f))).floatValue();
    }

    public static Float toFloat(Object value) {
        if (Classifier.isNull(value) || Classifier.isFloat(value)) {
            return (Float)value;
        }
        Float converted = null;
        if (Classifier.isNumber(value) && NumberClassifier.isInFloatRange((Number)value)) {
            converted = Float.valueOf(BigDecimalParser.toBigDecimal(value).floatValue());
        }
        return converted;
    }
}

