/*
 * Decompiled with CFR 0.152.
 */
package pro.boto.datatype.parser;

import org.apache.commons.lang3.ObjectUtils;
import pro.boto.datatype.classifiers.Classifier;
import pro.boto.datatype.classifiers.NumberClassifier;
import pro.boto.datatype.parser.BigIntegerParser;

public final class LongParser {
    private static final long DEFAULT_VALUE = 0L;

    private LongParser() {
    }

    public static long toPrimitive(Object value) {
        return (Long)ObjectUtils.defaultIfNull((Object)LongParser.toLong(value), (Object)0L);
    }

    public static Long toLong(Object value) {
        if (Classifier.isNull(value) || Classifier.isLong(value)) {
            return (Long)value;
        }
        Long converted = null;
        if (Classifier.isNumber(value) && NumberClassifier.isInLongRange((Number)value)) {
            converted = BigIntegerParser.toBigInteger(value).longValueExact();
        }
        return converted;
    }
}

