/*
 * Decompiled with CFR 0.152.
 */
package pro.boto.datatype.parser;

import java.text.NumberFormat;
import pro.boto.datatype.classifiers.Classifier;
import pro.boto.datatype.classifiers.NumberClassifier;
import pro.boto.datatype.parser.BigDecimalParser;
import pro.boto.datatype.parser.BigIntegerParser;

public final class StringParser {
    private StringParser() {
    }

    public static String toString(Object value) {
        if (Classifier.isNull(value) || Classifier.isString(value)) {
            return (String)value;
        }
        String converted = null;
        if (NumberClassifier.isComplementInteger(value)) {
            converted = NumberFormat.getInstance().format(BigIntegerParser.toBigInteger(value));
        } else if (NumberClassifier.isFloatingPoint(value)) {
            converted = NumberFormat.getInstance().format(BigDecimalParser.toBigDecimal(value));
        } else if (value instanceof byte[]) {
            converted = new String((byte[])value);
        }
        return converted;
    }
}

