/*
 * Decompiled with CFR 0.152.
 */
package pro.boto.protolang.domain;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import pro.boto.protolang.domain.ProtoObject;

public abstract class ProtoList<T extends ProtoObject<T>>
extends ProtoObject<T> {
    private List<T> thisList;

    protected ProtoList() {
        this.thisList = new ArrayList<T>();
    }

    protected ProtoList(Collection<T> col) {
        this.thisList = new ArrayList<T>(col);
    }

    @SafeVarargs
    protected ProtoList(T ... objs) {
        this.thisList = new ArrayList<T>();
        this.thisList.addAll(Arrays.asList(objs));
    }

    protected boolean add(T bean) {
        return this.thisList.add(bean);
    }

    protected boolean addAll(Collection<T> bean) {
        return this.thisList.addAll(bean);
    }

    protected boolean clean() {
        this.thisList.clear();
        return true;
    }

    public int size() {
        return this.thisList.size();
    }

    public boolean isEmpty() {
        return this.thisList.isEmpty();
    }

    public boolean isNotEmpty() {
        return !this.isEmpty();
    }

    @Override
    public boolean hasInfo() {
        if (this.isEmpty()) {
            return false;
        }
        return super.hasInfo();
    }

    public List<T> obtain() {
        return new ArrayList<T>(this.thisList);
    }

    public T obtain(int index) {
        if (index < 0 || index >= this.size()) {
            return null;
        }
        return (T)((ProtoObject)this.thisList.get(index));
    }

    public List<T> subList(int fromIndex, int toIndex) {
        if (fromIndex < 0 || fromIndex > toIndex || toIndex > this.size()) {
            return null;
        }
        return new ArrayList<T>(this.thisList.subList(fromIndex, Math.min(toIndex, this.size())));
    }
}

