/*
 * Decompiled with CFR 0.152.
 */
package pro.boto.protolang.domain;

import java.io.Serializable;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.ClassUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.SerializationException;
import org.apache.commons.lang3.builder.CompareToBuilder;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;

public abstract class ProtoObject<T extends ProtoObject<T>>
implements Serializable,
Cloneable,
Comparable<T> {
    public T clone() throws SerializationException {
        try {
            ProtoObject clone = (ProtoObject)super.clone();
            for (Field cField : this.processFields()) {
                Object value = cField.get(this);
                if (value != null && ClassUtils.isAssignable(value.getClass(), ProtoObject.class)) {
                    cField.set(clone, ((ProtoObject)value).clone());
                    continue;
                }
                if (value == null || !ClassUtils.isAssignable(value.getClass(), Cloneable.class)) continue;
                cField.set(clone, ObjectUtils.clone((Object)value));
            }
            return (T)clone;
        }
        catch (Exception e) {
            throw new SerializationException((Throwable)e);
        }
    }

    private List<Field> processFields() {
        ArrayList<Field> pFields = new ArrayList<Field>();
        for (Class<?> c = this.getClass(); c != null; c = c.getSuperclass()) {
            Field[] fields;
            for (Field cField : fields = c.getDeclaredFields()) {
                if (Modifier.isStatic(cField.getModifiers()) || Modifier.isTransient(cField.getModifiers())) continue;
                cField.setAccessible(true);
                pFields.add(cField);
            }
        }
        return pFields;
    }

    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (this == o) {
            return true;
        }
        if (this.getClass() != o.getClass()) {
            return false;
        }
        EqualsBuilder equals = new EqualsBuilder();
        for (Field cField : this.processFields()) {
            try {
                equals.append(cField.get(this), cField.get(o));
            }
            catch (IllegalAccessException e) {
                return false;
            }
        }
        return equals.isEquals();
    }

    public int hashCode() {
        HashCodeBuilder hash = new HashCodeBuilder(17, 37);
        for (Field cField : this.processFields()) {
            try {
                hash.append(cField.get(this));
            }
            catch (IllegalAccessException e) {
                return -1;
            }
        }
        return hash.toHashCode();
    }

    public String toString() {
        ToStringBuilder tostring = new ToStringBuilder((Object)this, ToStringStyle.JSON_STYLE);
        for (Field cField : this.processFields()) {
            try {
                tostring.append(cField.getName(), cField.get(this));
            }
            catch (IllegalAccessException e) {
                return "";
            }
        }
        return tostring.toString();
    }

    @Override
    public int compareTo(T obj) {
        if (obj == null) {
            return 1;
        }
        if (this.equals(obj)) {
            return 0;
        }
        CompareToBuilder compare = new CompareToBuilder();
        for (Field cField : this.processFields()) {
            try {
                compare.append(cField.get(this), cField.get(obj));
            }
            catch (IllegalAccessException e) {
                return -1;
            }
        }
        return compare.toComparison();
    }

    public boolean hasNotInfo() {
        return !this.hasInfo();
    }

    public boolean hasInfo() {
        try {
            boolean info = false;
            for (Field cField : this.processFields()) {
                Object value = cField.get(this);
                if (value != null && ClassUtils.isAssignable(value.getClass(), ProtoObject.class)) {
                    info = info || ((ProtoObject)value).hasInfo();
                    continue;
                }
                info = info || value != null;
            }
            return info;
        }
        catch (Exception e) {
            return false;
        }
    }
}

