/*
 * Decompiled with CFR 0.152.
 */
package pro.boto.protolang.json;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.module.afterburner.AfterburnerModule;
import java.io.IOException;

public abstract class ProtoClient {
    private static ObjectMapper MAPPER = new ObjectMapper();

    private static final ObjectMapper obtainPrettyMapper() {
        ObjectMapper mapper = MAPPER.copy();
        mapper.enable(SerializationFeature.INDENT_OUTPUT);
        return mapper;
    }

    private static final ObjectMapper obtainMapper() {
        return MAPPER.copy();
    }

    public static String obtainJson(Object object) throws IOException {
        if (object == null) {
            return "";
        }
        return ProtoClient.obtainMapper().writeValueAsString(object);
    }

    public static String obtainJsonPretty(Object object) throws IOException {
        if (object == null) {
            return "";
        }
        return ProtoClient.obtainPrettyMapper().writeValueAsString(object);
    }

    public static <T> T obtainObject(Class<T> clazz, String json) throws IOException {
        return (T)ProtoClient.obtainMapper().readValue(json, clazz);
    }

    static {
        MAPPER.registerModule((Module)new AfterburnerModule());
        MAPPER.disable(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES);
        MAPPER.enable(DeserializationFeature.ACCEPT_EMPTY_STRING_AS_NULL_OBJECT);
        MAPPER.setSerializationInclusion(JsonInclude.Include.NON_NULL);
        MAPPER.disable(SerializationFeature.FAIL_ON_EMPTY_BEANS);
        MAPPER.disable(SerializationFeature.WRITE_DATES_AS_TIMESTAMPS);
    }
}

