/*
 * Decompiled with CFR 0.152.
 */
package pro.boto.protolang.json.serials;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.ObjectCodec;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.type.CollectionType;
import java.io.IOException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pro.boto.protolang.domain.ProtoObject;
import pro.boto.protolang.json.serials.ProtoField;

public abstract class ProtoDeserializer<T>
extends JsonDeserializer<T> {
    private Logger LOG = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    protected ObjectCodec codec;
    protected JsonNode node;
    protected DeserializationContext context;

    public final T deserialize(JsonParser parser, DeserializationContext ctx) throws IOException {
        if (!parser.hasCurrentToken()) {
            return null;
        }
        this.codec = parser.getCodec();
        this.node = (JsonNode)parser.readValueAsTree();
        this.context = ctx;
        return this.deserialize();
    }

    protected abstract T deserialize() throws IOException;

    protected <O extends ProtoObject<?>> O deserializeObject(ProtoField field, Class<O> clazz) throws IOException {
        JsonNode node = this.deserialize(field);
        if (node.isMissingNode()) {
            return null;
        }
        JsonParser parser = this.deserialize(field).traverse(this.codec);
        ProtoObject bean = (ProtoObject)parser.readValueAs(clazz);
        return (O)bean;
    }

    protected <O extends ProtoObject<?>> O deserializeObject(Class<O> clazz) throws IOException {
        ProtoObject bean = (ProtoObject)this.context.getParser().readValueAs(clazz);
        return (O)bean;
    }

    protected <O extends ProtoObject<?>> List<O> deserializeList(Class<O> clazz) throws IOException {
        CollectionType type = this.context.getTypeFactory().constructCollectionType(List.class, clazz);
        JsonParser parser = this.node.traverse(this.codec);
        List bean = (List)((ObjectMapper)this.codec).readValue(parser, (JavaType)type);
        return bean;
    }

    private JsonNode deserialize(ProtoField field) {
        return this.node.path(field.property());
    }

    protected String deserializeString(ProtoField field) {
        return this.deserialize(field).textValue();
    }

    protected String deserializeString(String field) {
        return this.node.path(field).textValue();
    }

    protected Integer deserializeInteger(ProtoField field) {
        Number number = this.deserialize(field).numberValue();
        if (number == null) {
            return null;
        }
        return number.intValue();
    }

    protected Double deserializeDouble(ProtoField field) {
        Number number = this.deserialize(field).numberValue();
        if (number == null) {
            return null;
        }
        return number.doubleValue();
    }

    protected Boolean deserializeBoolean(ProtoField field) {
        String bool = this.deserialize(field).asText();
        if (StringUtils.isBlank((CharSequence)bool)) {
            return null;
        }
        return BooleanUtils.toBooleanObject((String)bool);
    }

    protected Date deserializeDate(ProtoField field, String format) {
        String date = this.deserialize(field).asText();
        if (StringUtils.isBlank((CharSequence)date)) {
            return null;
        }
        SimpleDateFormat dateFormat = new SimpleDateFormat(format);
        try {
            return dateFormat.parse(date);
        }
        catch (ParseException e) {
            this.LOG.error("Error parsing date '" + date + "' to format '" + format + "'");
            return null;
        }
    }

    public <E extends Enum<E>> E deserializeEnum(ProtoField field, Class<E> eClazz) {
        String value = this.deserializeString(field);
        if (StringUtils.isBlank((CharSequence)value)) {
            return null;
        }
        return Enum.valueOf(eClazz, value.toUpperCase());
    }

    public Map deserializeMap(ProtoField field) throws IOException {
        JsonNode node = this.deserialize(field);
        if (node.size() == 0) {
            return null;
        }
        JavaType type = this.context.getTypeFactory().constructType(Map.class);
        JsonParser parser = node.traverse(this.codec);
        Object bean = ((ObjectMapper)this.codec).readValue(parser, type);
        return (Map)bean;
    }

    protected <P> List<P> deserializeList(ProtoField field, Class<P> clazz) throws IOException {
        JsonNode node = this.deserialize(field);
        if (!node.isArray()) {
            return null;
        }
        CollectionType type = this.context.getTypeFactory().constructCollectionType(List.class, clazz);
        JsonParser parser = node.traverse(this.codec);
        Object bean = ((ObjectMapper)this.codec).readValue(parser, (JavaType)type);
        return (List)bean;
    }

    protected <P> LinkedList<P> deserializeLinkedList(ProtoField field, Class<P> clazz) throws IOException {
        JsonNode node = this.deserialize(field);
        if (!node.isArray()) {
            return null;
        }
        CollectionType type = this.context.getTypeFactory().constructCollectionType(LinkedList.class, clazz);
        JsonParser parser = node.traverse(this.codec);
        Object bean = ((ObjectMapper)this.codec).readValue(parser, (JavaType)type);
        return (LinkedList)bean;
    }
}

