/*
 * Decompiled with CFR 0.152.
 */
package pro.boto.protolang.json.serials;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.ClassUtils;
import org.apache.commons.lang3.StringUtils;
import pro.boto.protolang.domain.ProtoList;
import pro.boto.protolang.domain.ProtoObject;
import pro.boto.protolang.json.serials.ProtoField;

public abstract class ProtoSerializer<T>
extends JsonSerializer<T> {
    private JsonGenerator generator;
    private SerializerProvider serializers;

    public final void serialize(T value, JsonGenerator gen, SerializerProvider serializers) throws IOException {
        this.generator = gen;
        this.serializers = serializers;
        if (value instanceof ProtoList) {
            this.serialize(value);
        } else {
            this.generator.writeStartObject();
            this.serialize(value);
            this.generator.writeEndObject();
        }
    }

    protected abstract void serialize(T var1) throws IOException;

    protected ObjectNode obtainNode() {
        return JsonNodeFactory.instance.objectNode();
    }

    protected void serialize(ProtoField field, Object value) throws IOException {
        this.serialize(field.property(), value);
    }

    protected void serialize(String field, Object value) throws IOException {
        if (value == null) {
            return;
        }
        if (ClassUtils.isAssignable(value.getClass(), ProtoObject.class) && ((ProtoObject)value).hasNotInfo()) {
            return;
        }
        this.generator.writeFieldName(field);
        this.serializers.defaultSerializeValue(value, this.generator);
    }

    protected void serialize(ProtoField field, Integer value) throws IOException {
        if (value == null) {
            return;
        }
        this.generator.writeNumberField(field.property(), value.intValue());
    }

    protected void serialize(ProtoField field, Double value) throws IOException {
        if (value == null) {
            return;
        }
        this.generator.writeNumberField(field.property(), value.doubleValue());
    }

    protected void serialize(ProtoField field, String value) throws IOException {
        if (StringUtils.isBlank((CharSequence)value)) {
            return;
        }
        this.generator.writeStringField(field.property(), value);
    }

    protected void serialize(ProtoField field, Boolean value) throws IOException {
        if (value == null) {
            return;
        }
        this.generator.writeBooleanField(field.property(), value.booleanValue());
    }

    protected void serialize(ProtoField field, Date value, String format) throws IOException {
        if (value == null) {
            return;
        }
        SimpleDateFormat dateFormat = new SimpleDateFormat(format);
        String sValue = dateFormat.format(value);
        this.generator.writeStringField(field.property(), sValue);
    }

    protected void serialize(ProtoField field, Enum<?> value) throws IOException {
        if (value == null) {
            return;
        }
        this.serialize(field, value.name());
    }

    protected void serialize(ProtoField field, Map<?, ?> value) throws IOException {
        if (value == null || value.isEmpty()) {
            return;
        }
        this.generator.writeFieldName(field.property());
        this.serializers.defaultSerializeValue(value, this.generator);
    }

    protected <O extends ProtoObject<?>> void serializeList(List<O> value) throws IOException {
        if (value == null) {
            return;
        }
        this.generator.writeObject(value);
    }

    protected void serializeObject(ProtoObject<?> value) throws IOException {
        if (value == null) {
            return;
        }
        this.generator.writeObject(value);
    }

    protected void serialize(ProtoField field, List<?> value) throws IOException {
        if (value == null || value.isEmpty()) {
            return;
        }
        this.generator.writeFieldName(field.property());
        this.serializers.defaultSerializeValue(value, this.generator);
    }
}

