/*
 * Decompiled with CFR 0.152.
 */
package pro.boto.protolang.utils;

import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CodingErrorAction;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;

public class Cleaner {
    private static Pattern INTEGER = Pattern.compile("^((-|\\+)?(\\d+))((,|\\.)(\\d+))?$");
    private static Pattern DOUBLE = Pattern.compile("^((-|\\+)?(\\d+)((,|\\.)(\\d+))?)$");

    public static String trim(String value) {
        String toTrim = StringUtils.trim((String)value);
        if (StringUtils.isEmpty((CharSequence)(toTrim = StringUtils.strip((String)toTrim)))) {
            return null;
        }
        return StringUtils.trim((String)toTrim);
    }

    protected static String toNumber(String value) {
        String toNumber = Cleaner.trim(value);
        return StringUtils.replace((String)toNumber, (String)" ", (String)"");
    }

    public static String cleanDoubleSpaces(String value) {
        while (value.contains("  ")) {
            value = value.replaceAll("  ", " ");
        }
        return value;
    }

    public static String toInteger(String value) {
        if (StringUtils.isBlank((CharSequence)value)) {
            return null;
        }
        Matcher matcher = INTEGER.matcher(Cleaner.toNumber(value));
        if (!matcher.matches()) {
            return null;
        }
        return matcher.replaceAll("$1");
    }

    public static String toDouble(String value) {
        if (StringUtils.isBlank((CharSequence)value)) {
            return null;
        }
        Matcher matcher = DOUBLE.matcher(Cleaner.toNumber(value));
        if (!matcher.matches()) {
            return null;
        }
        return matcher.replaceAll("$1").replace(",", ".");
    }

    public static String unicodeCharacters(String value) {
        if (StringUtils.isBlank((CharSequence)value)) {
            return null;
        }
        return value.replaceAll("\\p{Cntrl}", "");
    }

    public static String toMaxBytes(String str, Charset charset, Integer maxBytes) {
        if (StringUtils.isNotBlank((CharSequence)str) && str.getBytes(charset).length > maxBytes) {
            ByteBuffer bb = ByteBuffer.wrap(str.getBytes(charset), 0, maxBytes);
            CharBuffer cb = CharBuffer.allocate(maxBytes);
            CharsetDecoder cd = charset.newDecoder().onMalformedInput(CodingErrorAction.IGNORE);
            cd.decode(bb, cb, true);
            cd.flush(cb);
            return new String(cb.array(), 0, cb.position());
        }
        return str;
    }

    public static String cleanXmlProblemChars(String str) {
        if (StringUtils.isBlank((CharSequence)str)) {
            return null;
        }
        str = str.replaceAll("\ufeff", "");
        str = str.replaceAll("&#x1f", "");
        str = str.replaceAll("&#x1", "");
        str = str.replaceAll("&#xb", "");
        str = str.replaceAll("&#xB", "");
        str = str.replaceAll("\u0085", "");
        return str;
    }
}

