/*
 * Decompiled with CFR 0.152.
 */
package pro.boto.protolang.utils;

import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pro.boto.protolang.utils.Classifier;
import pro.boto.protolang.utils.Cleaner;

public class Parser {
    private static Logger log = LoggerFactory.getLogger(Parser.class);

    public static Integer toInteger(Object value) {
        if (value == null) {
            return null;
        }
        if (Classifier.isInteger(value)) {
            return (Integer)value;
        }
        if (Classifier.isAtomicInteger(value)) {
            return ((AtomicInteger)value).get();
        }
        if (Classifier.isNumber(value)) {
            Number n = (Number)value;
            return ((Number)Math.round(n.doubleValue())).intValue();
        }
        String sValue = Cleaner.toInteger(String.valueOf(value));
        if (StringUtils.isBlank((CharSequence)sValue)) {
            return null;
        }
        try {
            return Integer.parseInt(sValue);
        }
        catch (Exception e) {
            log.error("parsing to integer: " + value + " - " + e.getMessage());
            return null;
        }
    }

    public static Long toLong(Object value) {
        if (value == null) {
            return null;
        }
        if (Classifier.isLong(value)) {
            return (Long)value;
        }
        if (Classifier.isNumber(value)) {
            Number n = (Number)value;
            return Math.round(n.doubleValue());
        }
        String sValue = Cleaner.toInteger(String.valueOf(value));
        if (StringUtils.isBlank((CharSequence)sValue)) {
            return null;
        }
        try {
            return Long.parseLong(sValue);
        }
        catch (Exception e) {
            log.error("parsing to integer: " + value + " - " + e.getMessage());
            return null;
        }
    }

    public static Double toDouble(Object value) {
        if (value == null) {
            return null;
        }
        if (Classifier.isDouble(value)) {
            return (Double)value;
        }
        if (Classifier.isLong(value)) {
            return Parser.toLong(value).doubleValue();
        }
        if (Classifier.isInteger(value)) {
            return Parser.toInteger(value).doubleValue();
        }
        String sValue = Cleaner.toDouble(String.valueOf(value));
        if (StringUtils.isBlank((CharSequence)sValue)) {
            return null;
        }
        try {
            return Double.parseDouble(sValue);
        }
        catch (Exception e) {
            log.error("parsing to double: " + value + " - " + e.getMessage());
            return null;
        }
    }

    public static Boolean toBoolean(Object value) {
        if (value == null) {
            return null;
        }
        if (Classifier.isBoolean(value)) {
            return (Boolean)value;
        }
        String sValue = Cleaner.trim(String.valueOf(value));
        if (StringUtils.isBlank((CharSequence)sValue)) {
            return null;
        }
        return BooleanUtils.toBooleanObject((String)sValue);
    }

    public static String toString(Object value) {
        if (value == null) {
            return null;
        }
        if (Classifier.isString(value)) {
            return (String)value;
        }
        if (Classifier.isDouble(value)) {
            DecimalFormat decimalFormat = new DecimalFormat("0.0###################");
            return decimalFormat.format(value).replaceAll(",", ".");
        }
        return Cleaner.trim(String.valueOf(value));
    }

    public static Date toDate(Object value) {
        return Parser.toDate(value, "yyyy/MM/dd");
    }

    public static Date toDate(Object value, String dateFormat) {
        if (value == null) {
            return null;
        }
        if (Classifier.isDate(value)) {
            return (Date)value;
        }
        String sValue = Cleaner.trim(String.valueOf(value));
        if (StringUtils.isBlank((CharSequence)sValue)) {
            return null;
        }
        try {
            SimpleDateFormat format = new SimpleDateFormat(dateFormat);
            return format.parse(sValue);
        }
        catch (Exception e) {
            log.error("parsing to date: " + value + " - " + e.getMessage());
            return null;
        }
    }

    public static <T extends Enum<T>> T toEnum(Object value, Class<T> eClazz) {
        if (value == null) {
            return null;
        }
        if (Classifier.isAssignable(value, eClazz)) {
            return (T)((Enum)value);
        }
        return Enum.valueOf(eClazz, value.toString().toUpperCase());
    }

    public static <T> List<T> toList(Object value, Class<T> eClazz) {
        if (value == null) {
            return null;
        }
        if (Classifier.isAssignable(value, List.class)) {
            return (List)value;
        }
        return (List)value;
    }

    public static <T> LinkedList<T> toLinkedList(Object value, Class<T> eClazz) {
        if (value == null) {
            return null;
        }
        if (Classifier.isAssignable(value, LinkedList.class)) {
            return (LinkedList)value;
        }
        return (LinkedList)value;
    }
}

