/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fastjson2;

import com.alibaba.fastjson2.JSONWriter;
import com.alibaba.fastjson2.JSONWriterUTF8;
import com.alibaba.fastjson2.util.JDKUtils;
import com.alibaba.fastjson2.util.UnsafeUtils;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;

final class JSONWriterUTF8JDK9
extends JSONWriterUTF8 {
    JSONWriterUTF8JDK9(JSONWriter.Context ctx) {
        super(ctx);
    }

    @Override
    public void writeString(String str) {
        byte c1;
        byte c0;
        int minCapacity;
        if (str == null) {
            if (this.isEnabled(JSONWriter.Feature.NullAsDefaultValue.mask | JSONWriter.Feature.WriteNullStringAsEmpty.mask)) {
                this.writeString("");
                return;
            }
            this.writeNull();
            return;
        }
        byte[] value = null;
        byte coder = 1;
        if (JDKUtils.UNSAFE_SUPPORT && (coder = UnsafeUtils.getStringCoder(str)) == 0) {
            value = UnsafeUtils.getStringValue(str);
        }
        if (value == null) {
            value = str.getBytes(StandardCharsets.UTF_8);
        }
        if ((minCapacity = this.off + value.length * 3 + 2) - this.bytes.length > 0) {
            int oldCapacity = this.bytes.length;
            int newCapacity = oldCapacity + (oldCapacity >> 1);
            if (newCapacity - minCapacity < 0) {
                newCapacity = minCapacity;
            }
            if (newCapacity - MAX_ARRAY_SIZE > 0) {
                throw new OutOfMemoryError();
            }
            this.bytes = Arrays.copyOf(this.bytes, newCapacity);
        }
        this.bytes[this.off++] = (byte)this.quote;
        boolean special = false;
        int i = 0;
        while (i + 4 <= value.length) {
            c0 = value[i];
            c1 = value[i + 1];
            byte c2 = value[i + 2];
            byte c3 = value[i + 3];
            if (c0 == this.quote || c1 == this.quote || c2 == this.quote || c3 == this.quote || c0 == 92 || c1 == 92 || c2 == 92 || c3 == 92 || c0 < 32 || c1 < 32 || c2 < 32 || c3 < 32) {
                special = true;
                break;
            }
            i += 4;
        }
        if (!special && i + 2 <= value.length) {
            c0 = value[i];
            c1 = value[i + 1];
            if (c0 == this.quote || c1 == this.quote || c0 == 92 || c1 == 92 || c0 < 32 || c1 < 32) {
                special = true;
            } else {
                i += 2;
            }
        }
        if (!special && i + 1 == value.length) {
            c0 = value[i];
            boolean bl = special = c0 == this.quote || c0 == 92 || c0 < 32;
        }
        if (!special) {
            System.arraycopy(value, 0, this.bytes, this.off, value.length);
            this.off += value.length;
        } else {
            block13: for (i = 0; i < value.length; ++i) {
                byte ch = value[i];
                switch (ch) {
                    case 92: {
                        this.bytes[this.off++] = 92;
                        this.bytes[this.off++] = 92;
                        continue block13;
                    }
                    case 10: {
                        this.bytes[this.off++] = 92;
                        this.bytes[this.off++] = 110;
                        continue block13;
                    }
                    case 13: {
                        this.bytes[this.off++] = 92;
                        this.bytes[this.off++] = 114;
                        continue block13;
                    }
                    case 12: {
                        this.bytes[this.off++] = 92;
                        this.bytes[this.off++] = 102;
                        continue block13;
                    }
                    case 8: {
                        this.bytes[this.off++] = 92;
                        this.bytes[this.off++] = 98;
                        continue block13;
                    }
                    case 9: {
                        this.bytes[this.off++] = 92;
                        this.bytes[this.off++] = 116;
                        continue block13;
                    }
                    case 0: 
                    case 1: 
                    case 2: 
                    case 3: 
                    case 4: 
                    case 5: 
                    case 6: 
                    case 7: {
                        this.bytes[this.off++] = 92;
                        this.bytes[this.off++] = 117;
                        this.bytes[this.off++] = 48;
                        this.bytes[this.off++] = 48;
                        this.bytes[this.off++] = 48;
                        this.bytes[this.off++] = (byte)(48 + ch);
                        continue block13;
                    }
                    case 11: 
                    case 14: 
                    case 15: {
                        this.bytes[this.off++] = 92;
                        this.bytes[this.off++] = 117;
                        this.bytes[this.off++] = 48;
                        this.bytes[this.off++] = 48;
                        this.bytes[this.off++] = 48;
                        this.bytes[this.off++] = (byte)(97 + (ch - 10));
                        continue block13;
                    }
                    case 16: 
                    case 17: 
                    case 18: 
                    case 19: 
                    case 20: 
                    case 21: 
                    case 22: 
                    case 23: 
                    case 24: 
                    case 25: {
                        this.bytes[this.off++] = 92;
                        this.bytes[this.off++] = 117;
                        this.bytes[this.off++] = 48;
                        this.bytes[this.off++] = 48;
                        this.bytes[this.off++] = 49;
                        this.bytes[this.off++] = (byte)(48 + (ch - 16));
                        continue block13;
                    }
                    case 26: 
                    case 27: 
                    case 28: 
                    case 29: 
                    case 30: 
                    case 31: {
                        this.bytes[this.off++] = 92;
                        this.bytes[this.off++] = 117;
                        this.bytes[this.off++] = 48;
                        this.bytes[this.off++] = 48;
                        this.bytes[this.off++] = 49;
                        this.bytes[this.off++] = (byte)(97 + (ch - 26));
                        continue block13;
                    }
                    default: {
                        if (ch == this.quote) {
                            this.bytes[this.off++] = 92;
                            this.bytes[this.off++] = (byte)this.quote;
                            continue block13;
                        }
                        if (coder == 0 && ch < 0) {
                            int c = ch & 0xFF;
                            this.bytes[this.off++] = (byte)(0xC0 | c >> 6);
                            this.bytes[this.off++] = (byte)(0x80 | c & 0x3F);
                            continue block13;
                        }
                        this.bytes[this.off++] = ch;
                    }
                }
            }
        }
        this.bytes[this.off++] = (byte)this.quote;
    }
}

