package pro.cutout.api;


import com.alibaba.fastjson.JSON;
import pro.cutout.api.requests.*;
import pro.cutout.api.responses.*;

import javax.imageio.ImageIO;
import javax.imageio.stream.ImageInputStream;
import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Base64;
import java.util.HashMap;
import java.util.Map;

class UnitTests {
    //海外站
//    static String serverUrl = "https://www.cutout.pro/api/v1";
//    static String apikey = "41d98547220a4a96b80b5d4b99a2de2d";
//测试站
//    static String serverUrl = "http://restapidev.picup.shop/api/v1";
//    static String apikey = "eefeb9ecde5e4c81b988a96b0ad126f6";
//国内站
    static String defaultServerUrl = "http://restapi.picup.shop/api/v1";
    //static String serverUrl = "http://47.99.178.15:8081/api/v1";
    static String defaultApiKey = "c66864a7eabc45b18aaf9483aeb82dc9";
    static String manUrl = "https://deeplor.oss-cn-hangzhou.aliyuncs.com/site/picup/cn-home/face1.jpg";
    static String grayScaleUrl = "https://deeplor.oss-cn-hangzhou.aliyuncs.com/site/picup/cn-home/photoColoring3.jpg";
    static CutoutClient client;
    static Map<String, byte[]> cache = new HashMap<>();

    public static ByteArrayInputStream getResources(String name) {
        byte[] bytes = cache.computeIfAbsent(name, key -> {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            try (InputStream inputStream = Thread.currentThread().getContextClassLoader().getResourceAsStream(name)) {
                byte[] buffer = new byte[1024];
                int i;
                while ((i = inputStream.read(buffer)) != -1) {
                    byteArrayOutputStream.write(buffer, 0, i);
                }
                return byteArrayOutputStream.toByteArray();
            } catch (Exception e) {
                return null;
            }
        });
        return new ByteArrayInputStream(bytes);
    }

    private static void cutoutClientInstance(String[] args) {
        long length = args.length;
        String serverUrl = length > 0 ? args[0] : defaultServerUrl;
        String apiKey = length > 1 ? args[1] : defaultApiKey;
        System.out.println("api url:" + serverUrl + "; api key:" + apiKey);
        //使用APIKEY身份验证
        client = new CutoutClient(serverUrl, apiKey);
        //使用验签身份验证
        //client = new CutoutClient(serverUrl, apiKey, 1309512L, 30L);
    }

    public static void main(String[] args) throws Exception {
        cutoutClientInstance(args);
        long t1 = System.currentTimeMillis();
        boolean success;

        success = imageRetouch();
        System.out.println("图片修复[执行状态:" + success + "]");
        success = passportPhoto();
        System.out.println("证件照[执行状态:" + success + "]");

        success = removeBackgroundToByteByFile();
        System.out.println("通用抠图[file->byte;执行状态:" + success + "]");
        success = removeBackgroundToBase64ByFile();
        System.out.println("通用抠图[file->base64;执行状态:" + success + "]");
        success = removeBackgroundToBase64ByUrl();
        System.out.println("通用抠图[url->base64;执行状态:" + success + "]");

        success = photoEnhancerToByteByFile();
        System.out.println("图片高清[file->byte;执行状态:" + success + "]");
        success = photoEnhancerToBase64ByFile();
        System.out.println("图片高清[file->base64;执行状态:" + success + "]");
        success = photoEnhancerToBase64ByUrl();
        System.out.println("图片高清[url->base64;执行状态:" + success + "]");

        success = faceCutoutToByteByFile();
        System.out.println("头像抠图[file->byte;执行状态:" + success + "]");
        success = faceCutoutToBase64ByFile();
        System.out.println("头像抠图[file->base64;执行状态:" + success + "]");
        success = faceCutoutToBase64ByUrl();
        System.out.println("头像抠图[url->base64;执行状态:" + success + "]");

        success = photoColorizerToByteByFile();
        System.out.println("图片上色[file->byte;执行状态:" + success + "]");
        success = photoColorizerToBase64ByFile();
        System.out.println("图片上色[file->base64;执行状态:" + success + "]");
        success = photoColorizerToBase64ByUrl();
        System.out.println("图片上色[url->base64;执行状态:" + success + "]");

        success = cartoonSelfieToBase64ByFile();
        System.out.println("卡通头像[file->base64;执行状态:" + success + "]");
        success = cartoonSelfieToBase64ByUrl();
        System.out.println("卡通头像[url->base64;执行状态:" + success + "]");
        for (int i = 0; i <= 8; i++) {
            success = cartoonSelfieToByteByFile(i);
            System.out.println("卡通头像[file->byte; cartoonType:" + i + "; 执行状态:" + success + "]");
        }
        for (int i = 0; i <= 13; i++) {
            success = photoAnimerTaskGet(i);
            System.out.println("照片变活[templateId:" + i + ";执行状态:" + success + "]");
        }
        long t2 = System.currentTimeMillis();
        System.out.println("测试完毕，耗时：" + (t2 - t1));
    }

    /**
     * 照片变活
     *
     * @param templateId
     * @throws Exception
     */
    public static boolean photoAnimerTaskGet(Integer templateId) throws Exception {
        Long taskId = photoAnimerTaskCreate(templateId);
        if (taskId == null) {
            return Boolean.FALSE;
        }
        for (int i = 0; i <= 100; i++) {
            PhotoAnimerTaskGetRequest request = new PhotoAnimerTaskGetRequest();
            request.setTaskId(taskId);
            PhotoAnimerTaskGetResponse response = client.execute(request);
            PhotoAnimerTaskGetResponse.Data date = response.getData();
            if (date.getStatus().equals(1)) {
                return Boolean.TRUE;
            } else if (date.getStatus().equals(2)) {
                System.out.println(JSON.toJSONString(response));
                return Boolean.FALSE;
            } else {
                Thread.sleep(1000L);
            }
        }
        return Boolean.FALSE;
    }

    /**
     * 提交照片变活任务
     *
     * @param templateId
     * @return
     * @throws Exception
     */
    public static Long photoAnimerTaskCreate(Integer templateId) throws Exception {
        PhotoAnimerTaskCreateRequest request = new PhotoAnimerTaskCreateRequest();
        request.setImageUrl("https://deeplor.oss-cn-hangzhou.aliyuncs.com/site/picup/cn-home/face1.jpg");
        request.setTemplateId(templateId);
        //request.setVoiceUrl("https://deeplor.oss-cn-hangzhou.aliyuncs.com/picup/test4.wav");
        PhotoAnimerTaskCreateResponse response = client.execute(request);
        return response.getData();

    }

    /**
     * 证件照、护照
     *
     * @return
     * @throws Exception
     */
    public static boolean passportPhoto() throws Exception {

        String base64 = toBASE64(getResources("img/boy.jpg"));
        PassportPhotoRequest request = new PassportPhotoRequest();
        request.setBase64(base64);
        request.setBgColor("3557FF");
        //request.setBgColor2();
        request.setDpi(300);
        request.setMmHeight(49);
        request.setMmWidth(35);
        request.setPrintBgColor("FFFCF9");
        request.setPrintMmHeight(297);
        request.setPrintMmWidth(210);
        request.setDress("woman3");
        PassportPhotoResponse response = client.execute(request);
        if (response.getCode().equals(0)) {
            return Boolean.TRUE;
        } else {
            return Boolean.FALSE;
        }
    }

    /**
     * 卡通头像，返回base64
     *
     * @throws Exception
     */
    public static boolean cartoonSelfieToBase64ByUrl() throws Exception {
        CartoonSelfieToBase64ByUrlRequest request = new CartoonSelfieToBase64ByUrlRequest();
        request.setUrl(manUrl);
        request.setCartoonType(3);
        CartoonSelfieToBase64ByFileResponse response = client.execute(request);
        if (response.getCode().equals(0)) {
            return Boolean.TRUE;
        } else {
            return Boolean.FALSE;
        }
    }

    public static boolean cartoonSelfieToBase64ByFile() throws Exception {
        CartoonSelfieToBase64ByFileRequest request = new CartoonSelfieToBase64ByFileRequest();
        request.setFile(getResources("img/boy.jpg"));
        request.setCartoonType(3);
        CartoonSelfieToBase64ByFileResponse response = client.execute(request);
        if (response.getCode().equals(0)) {
            return Boolean.TRUE;
        } else {
            return Boolean.FALSE;
        }
    }

    /**
     * 卡通头像
     *
     * @param cartoonType
     * @throws Exception
     */
    public static boolean cartoonSelfieToByteByFile(int cartoonType) throws Exception {
        CartoonSelfieToByteByFileRequest request = new CartoonSelfieToByteByFileRequest();
        request.setFile(getResources("img/boy.jpg"));
        request.setCartoonType(cartoonType);
        CartoonSelfieToByteByFileResponse response = client.execute(request);
        if (response.getCode().equals(0)) {
            return Boolean.TRUE;
        } else {
            return Boolean.FALSE;
        }
    }

    /**
     * 图片修复
     *
     * @return
     * @throws Exception
     */
    public static boolean imageRetouch() throws Exception {
        String base64 = toBASE64(getResources("img/boy.jpg"));
        ImageRetouchRequest.Rectangle rectangle = new ImageRetouchRequest.Rectangle();
        rectangle.setWidth(100);
        rectangle.setHeight(100);
        rectangle.setX(100);
        rectangle.setY(100);
        ImageRetouchRequest request = new ImageRetouchRequest();
        request.setBase64(base64);
        request.setRectangles(Arrays.asList(rectangle));
        ImageRetouchResponse response = client.execute(request);
        if (response.getCode().equals(0)) {
            if ("success".equals(response.getData().getStatus())) {
                return Boolean.TRUE;
            } else {
                return Boolean.FALSE;
            }
        } else {
            return Boolean.FALSE;
        }
    }

    public static boolean photoColorizerToBase64ByUrl() throws Exception {
        PhotoColorizerToBase64ByUrlRequest request = new PhotoColorizerToBase64ByUrlRequest();
        request.setUrl(grayScaleUrl);
        PhotoColorizerToBase64ByUrlResponse response = client.execute(request);
        if (response.getCode().equals(0)) {
            return Boolean.TRUE;
        } else {
            return Boolean.FALSE;
        }
    }

    public static boolean photoColorizerToBase64ByFile() throws Exception {
        PhotoColorizerToBase64ByFileRequest request = new PhotoColorizerToBase64ByFileRequest();
        request.setFile(getResources("img/grayScale.jpg"));
        PhotoColorizerToBase64ByFileResponse response = client.execute(request);
        if (response.getCode().equals(0)) {
            return Boolean.TRUE;
        } else {
            return Boolean.FALSE;
        }
    }

    public static boolean photoColorizerToByteByFile() throws Exception {
        PhotoColorizerToByteByFileRequest request = new PhotoColorizerToByteByFileRequest();
        request.setFile(getResources("img/grayScale.jpg"));
        PhotoColorizerToByteByFileResponse response = client.execute(request);
        if (response.getCode().equals(0)) {
            return Boolean.TRUE;
        } else {
            return Boolean.FALSE;
        }
    }

    public static boolean faceCutoutToBase64ByUrl() throws Exception {
        FaceCutoutToBase64ByUrlRequest request = new FaceCutoutToBase64ByUrlRequest();
        request.setBgcolor("ffccff");
        request.setUrl(manUrl);
        FaceCutoutToBase64ByUrlResponse response = client.execute(request);
        if (response.getCode().equals(0)) {
            return Boolean.TRUE;
        } else {
            return Boolean.FALSE;
        }
    }

    public static boolean faceCutoutToBase64ByFile() throws Exception {
        FaceCutoutToBase64ByFileRequest request = new FaceCutoutToBase64ByFileRequest();
        request.setBgcolor("ffccff");
        request.setFile(getResources("img/boy.jpg"));
        FaceCutoutToBase64ByFileResponse response = client.execute(request);
        if (response.getCode().equals(0)) {
            return Boolean.TRUE;
        } else {
            return Boolean.FALSE;
        }
    }

    /**
     * 头像抠图 file->byte
     *
     * @return
     * @throws Exception
     */
    public static boolean faceCutoutToByteByFile() throws Exception {
        FaceCutoutToByteByFileRequest request = new FaceCutoutToByteByFileRequest();
        request.setBgcolor("ffccff");
        request.setFile(getResources("img/boy.jpg"));
        FaceCutoutToByteByFileResponse response = client.execute(request);
        if (response.getCode().equals(0)) {
            return Boolean.TRUE;
        } else {
            return Boolean.FALSE;
        }
    }

    public static boolean photoEnhancerToBase64ByUrl() throws Exception {
        PhotoEnhancerToBase64ByUrlRequest request = new PhotoEnhancerToBase64ByUrlRequest();
        request.setUrl(manUrl);
        PhotoEnhancerToBase64ByUrlResponse response = client.execute(request);
        if (response.getCode().equals(0)) {
            return Boolean.TRUE;
        } else {
            return Boolean.FALSE;
        }
    }

    public static boolean photoEnhancerToBase64ByFile() throws Exception {
        PhotoEnhancerToBase64ByFileRequest request = new PhotoEnhancerToBase64ByFileRequest();
        request.setFile(getResources("img/boy.jpg"));
        PhotoEnhancerToBase64ByFileResponse response = client.execute(request);
        if (response.getCode().equals(0)) {
            return Boolean.TRUE;
        } else {
            return Boolean.FALSE;
        }
    }

    public static boolean photoEnhancerToByteByFile() throws Exception {
        PhotoEnhancerToByteByFileRequest request = new PhotoEnhancerToByteByFileRequest();
        request.setFile(getResources("img/boy.jpg"));
        PhotoEnhancerToByteByFileResponse response = client.execute(request);
        if (response.getCode().equals(0)) {
            return Boolean.TRUE;
        } else {
            return Boolean.FALSE;
        }
    }

    /**
     * 通用抠图[url->base64]
     *
     * @return
     * @throws Exception
     */
    public static boolean removeBackgroundToBase64ByUrl() throws Exception {
        RemoveBackgroundToBase64ByUrlRequest request = new RemoveBackgroundToBase64ByUrlRequest();
        request.setUrl(manUrl);
        RemoveBackgroundToBase64ByUrlResponse response = client.execute(request);
        if (response.getCode().equals(0)) {
            return Boolean.TRUE;
        } else {
            return Boolean.FALSE;
        }
    }

    /**
     * 通用抠图[file->base64]
     *
     * @return
     * @throws Exception
     */
    public static boolean removeBackgroundToBase64ByFile() throws Exception {
        RemoveBackgroundToBase64ByFileRequest request = new RemoveBackgroundToBase64ByFileRequest();
        request.setFile(getResources("img/boy.jpg"));
        RemoveBackgroundToBase64ByFileResponse response = client.execute(request);
        if (response.getCode().equals(0)) {
            return Boolean.TRUE;
        } else {
            return Boolean.FALSE;
        }
    }

    public static boolean removeBackgroundToByteByFile() throws Exception {
        RemoveBackgroundToByteByFileRequest request = new RemoveBackgroundToByteByFileRequest();
        request.setBgcolor("ffccff");
        request.setFile(getResources("img/boy.jpg"));
        RemoveBackgroundToByteByFileResponse response = client.execute(request);
        if (response.getCode().equals(0)) {
            return Boolean.TRUE;
        } else {
            return Boolean.FALSE;
        }
    }

    public static String toBASE64(InputStream inputStream) throws IOException {
        byte[] data = inputTobyte(inputStream);
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(data);
        ImageInputStream imageInputStream = ImageIO.createImageInputStream(byteArrayInputStream);
        BufferedImage bufferedImage = ImageIO.read(imageInputStream);
        ByteArrayOutputStream out = new ByteArrayOutputStream();

        String formatName = getImageType(data);
        ImageIO.write(bufferedImage, formatName, out);
        byte[] bytes = Base64.getEncoder().encode(out.toByteArray());
        return new String(bytes);
    }

    public static byte[] inputTobyte(InputStream inStream) throws IOException {
        ByteArrayOutputStream swapStream = new ByteArrayOutputStream();
        byte[] buff = new byte[1024];
        int rc;
        while ((rc = inStream.read(buff, 0, 100)) > 0) {
            swapStream.write(buff, 0, rc);
        }
        return swapStream.toByteArray();
    }

    public static String getImageType(byte[] data) {
        String type = null;
        if (data[1] == 'P' && data[2] == 'N' && data[3] == 'G') {
            type = "PNG";
            return type;
        }
        if (data[0] == 'G' && data[1] == 'I' && data[2] == 'F') {
            type = "GIF";
            return type;
        }
        if (data[6] == 'J' && data[7] == 'F' && data[8] == 'I'
                && data[9] == 'F') {
            type = "JPG";
            return type;
        }

        if (data[6] == 'E' && data[7] == 'x' && data[8] == 'i'
                && data[9] == 'f') {
            type = "JPG";
            return type;
        }
        if (data[8] == 'W' && data[9] == 'E' && data[10] == 'B'
                && data[11] == 'P') {
            type = "WEBP";
            return type;
        }

        if (data[0] == 'B' && data[1] == 'M' && data[2] == 'v'
                && data[3] == 'A') {
            type = "BMP";
            return type;
        }
        return type;
    }


}
