/*
 * Decompiled with CFR 0.152.
 */
package pro.cyberyon.mojet;

import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.Map;
import pro.cyberyon.mojet.Fragment;
import pro.cyberyon.mojet.MojetRuntimeException;
import pro.cyberyon.mojet.Occurences;
import pro.cyberyon.mojet.Record;
import pro.cyberyon.mojet.Transform;
import pro.cyberyon.mojet.Zap;
import pro.cyberyon.mojet.nodes.AbstractNode;
import pro.cyberyon.mojet.nodes.FragmentNode;
import pro.cyberyon.mojet.nodes.OccurencesNode;
import pro.cyberyon.mojet.nodes.RecordNode;
import pro.cyberyon.mojet.nodes.ZapNode;
import pro.cyberyon.mojet.types.TypeHandler;
import pro.cyberyon.mojet.types.TypeHandlerFactory;

public class NodesBuilder {
    private final Map<Class<?>, RecordNode> cache = new HashMap();

    public RecordNode build(Class<?> type) {
        return this.build("", type);
    }

    private RecordNode build(String accessor, Class<?> type) {
        if (!this.cache.containsKey(type)) {
            if (!type.isAnnotationPresent(Record.class)) {
                throw new MojetRuntimeException("Record not annoted");
            }
            RecordNode result = new RecordNode(accessor, type);
            for (Field field : type.getDeclaredFields()) {
                this.build(field, result);
            }
            NodesBuilder.addFillers((Zap[])type.getDeclaredAnnotationsByType(Zap.class), result);
            this.cache.put(type, result);
        }
        return this.cache.get(type);
    }

    private void build(Field field, RecordNode node) {
        NodesBuilder.addFillers((Zap[])field.getDeclaredAnnotationsByType(Zap.class), node);
        String accessor = field.getName();
        boolean isArray = field.getType().isArray();
        AbstractNode item = null;
        if (field.isAnnotationPresent(Record.class)) {
            item = this.build(accessor, (Class<?>)(!isArray ? field.getType() : field.getType().componentType()));
        } else if (field.isAnnotationPresent(Fragment.class)) {
            item = this.processFragment(accessor, field);
        }
        if (item != null) {
            if (isArray) {
                if (field.isAnnotationPresent(Occurences.class)) {
                    item = new OccurencesNode(accessor, field.getAnnotation(Occurences.class), item);
                } else {
                    throw new MojetRuntimeException("Occurences annotation required");
                }
            }
            node.add(item);
        }
    }

    private AbstractNode<?> processFragment(String accessor, Field field) {
        TypeHandler handler;
        if (field.isAnnotationPresent(Transform.class)) {
            Transform converter = field.getAnnotation(Transform.class);
            try {
                handler = converter.value().getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (ReflectiveOperationException ex) {
                throw new MojetRuntimeException("Can't instanciate handler " + converter.value().getSimpleName(), ex);
            }
        } else {
            handler = TypeHandlerFactory.getInstance().get(field.getType());
        }
        if (handler.accept(field.getType())) {
            return new FragmentNode(accessor, field.getAnnotation(Fragment.class), handler);
        }
        throw new MojetRuntimeException("Handler can't manage this class type");
    }

    private static void addFillers(Zap[] fillers, RecordNode node) {
        for (Zap filler : fillers) {
            node.add(new ZapNode(filler));
        }
    }
}

