/*
 * Decompiled with CFR 0.152.
 */
package pro.cyberyon.mojet.types;

import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import org.apache.commons.lang3.StringUtils;
import pro.cyberyon.mojet.types.AbstractTypeHandler;

final class LocalDateTypeHandler
extends AbstractTypeHandler<LocalDate> {
    LocalDateTypeHandler() {
    }

    @Override
    protected boolean isAccept(Class<?> type) {
        return LocalDate.class == type;
    }

    @Override
    public LocalDate read(String data, String format) {
        return LocalDate.parse(data, LocalDateTypeHandler.getFormatter(format));
    }

    @Override
    public String write(LocalDate data, String format) {
        return LocalDateTypeHandler.getFormatter(format).format(data);
    }

    private static DateTimeFormatter getFormatter(String format) {
        return StringUtils.isEmpty((CharSequence)format) ? DateTimeFormatter.ISO_DATE : DateTimeFormatter.ofPattern(format);
    }
}

