/*
 * Decompiled with CFR 0.152.
 */
package pro.cyberyon.mojet.types;

import lombok.NonNull;
import org.apache.commons.lang3.ClassUtils;
import org.apache.commons.lang3.StringUtils;
import pro.cyberyon.mojet.types.TypeHandler;

public abstract class AbstractTypeHandler<T>
implements TypeHandler<T> {
    @Override
    public final boolean accept(Class<?> type) {
        boolean result = false;
        if (type != null) {
            if (type.isArray()) {
                type = type.getComponentType();
            }
            if (type.isPrimitive()) {
                type = ClassUtils.primitivesToWrappers((Class[])new Class[]{type})[0];
            }
            result = this.isAccept(type);
        }
        return result;
    }

    @Override
    public final T read(String data, String format) {
        T result = null;
        if (StringUtils.isNotEmpty((CharSequence)data)) {
            result = this.doRead(data, format);
        }
        return result;
    }

    @Override
    public String write(T data, String format) {
        return data != null ? this.doWrite(data, format) : "";
    }

    protected abstract boolean isAccept(Class<?> var1);

    protected abstract T doRead(@NonNull String var1, String var2);

    protected abstract String doWrite(@NonNull T var1, String var2);
}

