/*
 * Decompiled with CFR 0.152.
 */
package pro.cyberyon.mojet.types;

import java.util.Collections;
import java.util.HashSet;
import java.util.NoSuchElementException;
import java.util.Set;
import pro.cyberyon.mojet.MojetRuntimeException;
import pro.cyberyon.mojet.types.AbstractTypeHandler;
import pro.cyberyon.mojet.types.BigIntegerTypeHandler;
import pro.cyberyon.mojet.types.ByteTypeHandler;
import pro.cyberyon.mojet.types.CharacterTypeHandler;
import pro.cyberyon.mojet.types.IntegerTypeHandler;
import pro.cyberyon.mojet.types.LocalDateTypeHandler;
import pro.cyberyon.mojet.types.LongTypeHandler;
import pro.cyberyon.mojet.types.ShortTypeHandler;
import pro.cyberyon.mojet.types.StringTypeHandler;
import pro.cyberyon.mojet.types.TypeHandler;

public final class TypeHandlerFactory {
    private final Set<TypeHandler<?>> handlers;
    private static TypeHandlerFactory instance = null;

    private TypeHandlerFactory() {
        HashSet<AbstractTypeHandler> types = new HashSet<AbstractTypeHandler>();
        types.add(new StringTypeHandler());
        types.add(new LongTypeHandler());
        types.add(new IntegerTypeHandler());
        types.add(new ShortTypeHandler());
        types.add(new BigIntegerTypeHandler());
        types.add(new ByteTypeHandler());
        types.add(new CharacterTypeHandler());
        types.add(new LocalDateTypeHandler());
        this.handlers = Collections.unmodifiableSet(types);
    }

    public <T> TypeHandler<T> get(Class<T> type) {
        try {
            return this.handlers.stream().filter(t -> t.accept(type)).findFirst().orElseThrow();
        }
        catch (NoSuchElementException ex) {
            throw new MojetRuntimeException(ex);
        }
    }

    public static TypeHandlerFactory getInstance() {
        if (instance == null) {
            instance = new TypeHandlerFactory();
        }
        return instance;
    }
}

