/*
 * Decompiled with CFR 0.152.
 */
package pro.cyberyon.mojet;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.springframework.batch.item.file.transform.LineAggregator;
import pro.cyberyon.mojet.MojetLineAggregator;
import pro.cyberyon.mojet.MojetRuntimeException;
import pro.cyberyon.mojet.NodesBuilder;
import pro.cyberyon.mojet.RecordVisitable;

public class MojetPolyLineAggregator<T extends RecordVisitable>
implements LineAggregator<T> {
    private final Map<Class<? extends T>, MojetLineAggregator<? extends T>> aggregators;

    public MojetPolyLineAggregator(Set<Class<? extends T>> pojos) {
        HashMap<Class<T>, MojetLineAggregator<T>> instances = new HashMap<Class<T>, MojetLineAggregator<T>>();
        NodesBuilder builder = new NodesBuilder();
        for (Class<T> clazz : pojos) {
            instances.put(clazz, new MojetLineAggregator<T>(builder, clazz));
        }
        this.aggregators = Collections.unmodifiableMap(instances);
    }

    public String aggregate(T item) {
        if (!this.aggregators.containsKey(item.getClass())) {
            throw new MojetRuntimeException("Unknow record class : " + String.valueOf(item.getClass()));
        }
        return this.aggregators.get(item.getClass()).aggregate(item);
    }
}

