/*
 * Decompiled with CFR 0.152.
 */
package pro.cyberyon.mojet;

import java.util.ArrayDeque;
import java.util.Collections;
import java.util.Deque;
import java.util.stream.Collectors;
import lombok.NonNull;
import pro.cyberyon.mojet.NodesBuilder;
import pro.cyberyon.mojet.nodes.AbstractNode;
import pro.cyberyon.mojet.nodes.NodeVisitor;
import pro.cyberyon.mojet.nodes.OccurencesNode;
import pro.cyberyon.mojet.nodes.RecordNode;

abstract class AbstractMojetLine<T> {
    protected final RecordNode root;

    protected AbstractMojetLine(@NonNull Class<T> targetType) {
        this(targetType, new NodesBuilder());
        if (targetType == null) {
            throw new NullPointerException("targetType is marked non-null but is null");
        }
    }

    protected AbstractMojetLine(@NonNull Class<T> targetType, @NonNull NodesBuilder builder) {
        if (targetType == null) {
            throw new NullPointerException("targetType is marked non-null but is null");
        }
        if (builder == null) {
            throw new NullPointerException("builder is marked non-null but is null");
        }
        this.root = builder.build(targetType);
    }

    protected static abstract class AbstractNodeVisitor
    implements NodeVisitor {
        private final Deque<String> path = new ArrayDeque<String>();

        protected AbstractNodeVisitor() {
        }

        @Override
        public final void visit(RecordNode node) {
            for (AbstractNode<?> visitable : node.getNodes()) {
                this.path.push(visitable.getAccessor());
                visitable.accept(this);
                this.path.pop();
            }
        }

        @Override
        public final void visit(OccurencesNode node) {
            String old = this.path.pop();
            for (int i = 0; i < node.getCount(); ++i) {
                this.path.push(node.getAccessor() + "[" + i + "]");
                node.getItem().accept(this);
                this.path.pop();
            }
            this.path.push(old);
        }

        protected final String getPath() {
            return this.path.stream().filter(t -> !t.isEmpty()).collect(Collectors.collectingAndThen(Collectors.toList(), lst -> {
                Collections.reverse(lst);
                return lst.stream().filter(t -> !t.isEmpty()).collect(Collectors.joining("."));
            }));
        }
    }
}

