/*
 * Decompiled with CFR 0.152.
 */
package pro.cyberyon.mojet;

import org.apache.commons.text.TextStringBuilder;
import org.springframework.batch.item.file.transform.LineAggregator;
import org.springframework.beans.BeanWrapperImpl;
import pro.cyberyon.mojet.AbstractMojetLine;
import pro.cyberyon.mojet.MojetRuntimeException;
import pro.cyberyon.mojet.NodesBuilder;
import pro.cyberyon.mojet.nodes.FragmentNode;
import pro.cyberyon.mojet.nodes.ZapNode;

public class MojetLineAggregator<T>
extends AbstractMojetLine<T>
implements LineAggregator<T> {
    public MojetLineAggregator(Class<T> type) {
        super(type);
    }

    public MojetLineAggregator(NodesBuilder builder, Class<T> type) {
        super(type, builder);
    }

    public String aggregate(final T item) {
        final TextStringBuilder output = new TextStringBuilder();
        this.root.accept(new AbstractMojetLine.AbstractNodeVisitor(this){
            private final BeanWrapperImpl bean;
            final /* synthetic */ MojetLineAggregator this$0;
            {
                this.this$0 = this$0;
                this.bean = new BeanWrapperImpl(item);
                this.bean.setAutoGrowNestedPaths(true);
            }

            @Override
            public void visit(ZapNode node) {
                output.appendPadding(node.getLength(), node.getPadding());
            }

            @Override
            public void visit(FragmentNode node) {
                Object value = this.bean.getPropertyValue(this.getPath());
                String data = node.getHandler().write(value, node.getFormat());
                if (data.length() > node.getLenght()) {
                    if (node.isTruncable()) {
                        data = data.substring(0, node.getLenght());
                    } else {
                        throw new MojetRuntimeException("Data overflow");
                    }
                }
                switch (node.getAlignement()) {
                    case NONE: {
                        if (data.length() != node.getLenght()) {
                            throw new MojetRuntimeException("Expected length not matched");
                        }
                        output.append(data);
                        break;
                    }
                    case LEFT: {
                        output.appendFixedWidthPadRight((Object)data, node.getLenght(), node.getPadder());
                        break;
                    }
                    case RIGHT: {
                        output.appendFixedWidthPadLeft((Object)data, node.getLenght(), node.getPadder());
                        break;
                    }
                    default: {
                        throw new MojetRuntimeException("Undefined case");
                    }
                }
            }
        });
        return output.toString();
    }
}

