/*
 * Decompiled with CFR 0.152.
 */
package pro.eng.yui.yuiframe.utils.impl;

import pro.eng.yui.yuiframe.YuiFrame;
import pro.eng.yui.yuiframe.utils.IEnvPropUtil;

public class EnvPropUtils
implements IEnvPropUtil {
    private static final EnvPropUtils instance = new EnvPropUtils();

    public static EnvPropUtils getInstance() {
        return instance;
    }

    private EnvPropUtils() {
    }

    @Override
    public String getEnv(String key) {
        return this.getEnv(key, "");
    }

    @Override
    public String getEnv(String key, String defaultValue) {
        String val = System.getenv(key);
        return val == null ? defaultValue : val;
    }

    @Override
    public String getProp(String key) {
        return this.getProp(key, "");
    }

    @Override
    public String getProp(String key, String defaultValue) {
        return System.getProperty(key, defaultValue);
    }

    @Override
    public void setProp(String key, String value) {
        String val = this.getProp(key, null);
        if (YuiFrame.ObjectUtil.isNotNull(val)) {
            throw new IllegalStateException("the prop already set as " + val);
        }
        this.setPropForce(key, value);
    }

    @Override
    public boolean setPropForce(String key, String value) {
        boolean overwrite = YuiFrame.ObjectUtil.isNotNull(this.getProp(key, null));
        System.setProperty(key, value);
        return overwrite;
    }
}

