/*
 * Decompiled with CFR 0.152.
 */
package pro.eng.yui.yuiframe.utils.impl;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import pro.eng.yui.yuiframe.YuiFrame;
import pro.eng.yui.yuiframe.utils.ICollectionUtil;

public class CollectionUtils
implements ICollectionUtil {
    private static final CollectionUtils instance = new CollectionUtils();

    public static CollectionUtils getInstance() {
        return instance;
    }

    private CollectionUtils() {
    }

    @Override
    public <T> List<T> toList(T ... aryObj) {
        if (YuiFrame.ObjectUtil.isNull(aryObj)) {
            return null;
        }
        return Arrays.asList(aryObj);
    }

    @Override
    public <T> ArrayList<T> toArrayList(T ... aryObj) {
        if (YuiFrame.ObjectUtil.isNull(aryObj)) {
            return null;
        }
        return new ArrayList<T>(Arrays.asList(aryObj));
    }

    @Override
    public boolean isEmpty(Object[] array) {
        if (YuiFrame.ObjectUtil.isNull(array)) {
            return true;
        }
        return array.length == 0;
    }

    @Override
    public boolean isEmpty(Collection<?> list) {
        if (YuiFrame.ObjectUtil.isNull(list)) {
            return true;
        }
        return list.isEmpty();
    }

    @Override
    public String toString(Collection<?> collection) {
        return this.collection2Str(collection, false, false);
    }

    @Override
    public String toString(Object[] array) {
        return this.array2Str(array, false, false);
    }

    @Override
    public String toStrMeta(Collection<?> collection) {
        return this.collection2Str(collection, true, false);
    }

    @Override
    public String toStrMeta(Object[] array) {
        return this.array2Str(array, true, false);
    }

    @Override
    public String toStringBr(Collection<?> collection) {
        return this.collection2Str(collection, false, true);
    }

    @Override
    public String toStringBr(Object[] array) {
        return this.array2Str(array, false, true);
    }

    @Override
    public String toStrMetaBr(Collection<?> collection) {
        return this.collection2Str(collection, true, true);
    }

    @Override
    public String toStrMetaBr(Object[] array) {
        return this.array2Str(array, true, true);
    }

    private String array2Str(Object[] array, boolean meta, boolean br) {
        return this.collection2Str(YuiFrame.CollectionUtil.toArrayList(array), meta, br);
    }

    private <E> String collection2Str(Collection<E> collection, boolean meta, boolean br) {
        boolean isObjCollection;
        if (YuiFrame.ObjectUtil.isNull(collection)) {
            return "null";
        }
        StringBuilder sb = new StringBuilder();
        if (meta) {
            sb.append("{");
            if (br) {
                sb.append(System.lineSeparator());
            }
            sb.append("size:").append(collection.size()).append(",");
            if (br) {
                sb.append(System.lineSeparator());
            }
            sb.append("data:");
        }
        try {
            E obj = collection.stream().toList().get(collection.size() - 1);
            isObjCollection = YuiFrame.ObjectUtil.isTypeOf(obj, Collection.class) || obj.getClass().isArray();
        }
        catch (IndexOutOfBoundsException | NullPointerException e) {
            isObjCollection = false;
        }
        sb.append("[");
        if (br) {
            sb.append(System.lineSeparator());
        }
        List<E> colStream = collection.stream().toList();
        for (int idx = 0; idx < collection.size(); ++idx) {
            try {
                if (isObjCollection) {
                    if (colStream.get(idx).getClass().isArray()) {
                        sb.append(this.array2Str((Object[])colStream.get(idx), meta, br));
                    } else {
                        sb.append(this.collection2Str((Collection)colStream.get(idx), meta, br));
                    }
                } else {
                    sb.append(colStream.get(idx).toString());
                }
            }
            catch (NullPointerException npe) {
                sb.append((String)null);
            }
            if (idx < collection.size() - 1) {
                sb.append(",");
            }
            if (!br) continue;
            sb.append(System.lineSeparator());
        }
        sb.append("]");
        if (meta) {
            if (br) {
                sb.append(System.lineSeparator());
            }
            sb.append("}");
        }
        return sb.toString();
    }
}

