/*
 * Decompiled with CFR 0.152.
 */
package pro.felixo.csv;

import java.io.Writer;
import java.util.Iterator;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import pro.felixo.csv.CsvFormat;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010\u001c\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\r\u001a\u00020\u000eH\u0016J\u0010\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\u0010\u001a\u00020\nH\u0002J\u0014\u0010\u0011\u001a\u00020\u000e2\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\n0\u0013J\u0010\u0010\u0014\u001a\u00020\u000e2\u0006\u0010\u0010\u001a\u00020\nH\u0002J\u0010\u0010\u0015\u001a\u00020\u000e2\u0006\u0010\u0010\u001a\u00020\nH\u0002R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lpro/felixo/csv/CsvWriter;", "Ljava/lang/AutoCloseable;", "target", "Ljava/io/Writer;", "format", "Lpro/felixo/csv/CsvFormat;", "(Ljava/io/Writer;Lpro/felixo/csv/CsvFormat;)V", "delimiterInt", "", "escapedQuoteString", "", "quoteInt", "quoteString", "close", "", "writeQuotedValue", "value", "writeRow", "values", "", "writeUnquotedValue", "writeValue", "csv-kotlin"})
public final class CsvWriter
implements AutoCloseable {
    private final String quoteString;
    private final String escapedQuoteString;
    private final int quoteInt;
    private final int delimiterInt;
    private final Writer target;
    private final CsvFormat format;

    public final void writeRow(@NotNull Iterable<String> values) {
        Intrinsics.checkNotNullParameter(values, (String)"values");
        Iterator<String> iterator = values.iterator();
        if (iterator.hasNext()) {
            this.writeValue(iterator.next());
        }
        while (iterator.hasNext()) {
            this.target.write(this.delimiterInt);
            this.writeValue(iterator.next());
        }
        this.target.write(this.format.getTerminator());
    }

    private final void writeValue(String value) {
        boolean bl;
        block3: {
            CharSequence $this$any$iv = value;
            boolean $i$f$any = false;
            CharSequence charSequence = $this$any$iv;
            for (int i = 0; i < charSequence.length(); ++i) {
                char element$iv;
                char it = element$iv = charSequence.charAt(i);
                boolean bl2 = false;
                if (!this.format.getSpecialChars().contains(Character.valueOf(it))) continue;
                bl = true;
                break block3;
            }
            bl = false;
        }
        if (bl) {
            this.writeQuotedValue(value);
        } else {
            this.writeUnquotedValue(value);
        }
    }

    private final void writeQuotedValue(String value) {
        this.target.write(this.quoteInt);
        this.target.write(StringsKt.replace$default((String)value, (String)this.quoteString, (String)this.escapedQuoteString, (boolean)false, (int)4, null));
        this.target.write(this.quoteInt);
    }

    private final void writeUnquotedValue(String value) {
        this.target.write(value);
    }

    @Override
    public void close() {
        this.target.close();
    }

    public CsvWriter(@NotNull Writer target, @NotNull CsvFormat format) {
        Intrinsics.checkNotNullParameter((Object)target, (String)"target");
        Intrinsics.checkNotNullParameter((Object)format, (String)"format");
        this.target = target;
        this.format = format;
        this.quoteString = String.valueOf(this.format.getQuote());
        this.escapedQuoteString = "" + this.format.getEscape() + this.format.getQuote();
        this.quoteInt = this.format.getQuote();
        this.delimiterInt = this.format.getDelimiter();
    }

    public /* synthetic */ CsvWriter(Writer writer, CsvFormat csvFormat, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            csvFormat = new CsvFormat('\u0000', '\u0000', '\u0000', null, 15, null);
        }
        this(writer, csvFormat);
    }
}

