/*
 * Decompiled with CFR 0.152.
 */
package pro.felixo.protobuf.schemadocument;

import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.IntRange;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import pro.felixo.protobuf.EnumValue;
import pro.felixo.protobuf.FieldNumber;
import pro.felixo.protobuf.FieldRule;
import pro.felixo.protobuf.Identifier;
import pro.felixo.protobuf.schemadocument.Enum;
import pro.felixo.protobuf.schemadocument.Field;
import pro.felixo.protobuf.schemadocument.Member;
import pro.felixo.protobuf.schemadocument.Message;
import pro.felixo.protobuf.schemadocument.OneOf;
import pro.felixo.protobuf.schemadocument.SchemaDocument;
import pro.felixo.protobuf.schemadocument.SchemaDocumentWriter;
import pro.felixo.protobuf.schemadocument.SchemaElement;
import pro.felixo.protobuf.schemadocument.Type;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u008c\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u001b\u0012\n\u0010\u0002\u001a\u00060\u0003j\u0002`\u0004\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u0010\u0010\r\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u0016\u0010\u000e\u001a\u00020\u000f2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u000f0\u0011H\u0002J\u0012\u0010\u0012\u001a\u00020\u000f2\b\b\u0002\u0010\u0013\u001a\u00020\nH\u0002J\u0010\u0010\u0014\u001a\u00020\n2\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J\u000e\u0010\u0017\u001a\u00020\u000f2\u0006\u0010\u0018\u001a\u00020\u0019J\u000e\u0010\u0017\u001a\u00020\u000f2\u0006\u0010\u001a\u001a\u00020\u001bJ\u0010\u0010\u001c\u001a\u00020\u000f2\u0006\u0010\u001d\u001a\u00020\u001eH\u0002J\u0016\u0010\u001f\u001a\u00020\u000f2\f\u0010 \u001a\b\u0012\u0004\u0012\u00020\f0!H\u0002J\u0010\u0010\"\u001a\u00020\u000f2\u0006\u0010#\u001a\u00020$H\u0002J\u0010\u0010%\u001a\u00020\u000f2\u0006\u0010&\u001a\u00020'H\u0002J\u0010\u0010(\u001a\u00020\u000f2\u0006\u0010)\u001a\u00020*H\u0002J\u0010\u0010+\u001a\u00020\u000f2\u0006\u0010,\u001a\u00020-H\u0002J\u0016\u0010.\u001a\u00020\u000f2\f\u0010 \u001a\b\u0012\u0004\u0012\u00020\f0!H\u0002J\u0010\u0010/\u001a\u00020\u000f2\u0006\u00100\u001a\u000201H\u0002J\u0019\u00102\u001a\u00020\u000f2\f\u00103\u001a\b\u0012\u0004\u0012\u0002040!H\u0002\u00f8\u0001\u0000R\u000e\u0010\b\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0002\u001a\u00060\u0003j\u0002`\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u00065"}, d2={"Lpro/felixo/protobuf/schemadocument/SchemaDocumentWriter;", "", "out", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "indentSpaces", "", "(Ljava/lang/StringBuilder;I)V", "currentIndent", "enumRangeToString", "", "intRange", "Lkotlin/ranges/IntRange;", "fieldRangeToString", "indent", "", "block", "Lkotlin/Function0;", "line", "s", "rulePrefix", "rule", "Lpro/felixo/protobuf/FieldRule;", "write", "schema", "Lpro/felixo/protobuf/schemadocument/SchemaDocument;", "type", "Lpro/felixo/protobuf/schemadocument/Type;", "writeEnum", "enum", "Lpro/felixo/protobuf/schemadocument/Enum;", "writeEnumReservedNumbers", "numbers", "", "writeEnumValue", "value", "Lpro/felixo/protobuf/EnumValue;", "writeField", "field", "Lpro/felixo/protobuf/schemadocument/Field;", "writeMember", "member", "Lpro/felixo/protobuf/schemadocument/Member;", "writeMessage", "message", "Lpro/felixo/protobuf/schemadocument/Message;", "writeMessageReservedNumbers", "writeOneOf", "oneOf", "Lpro/felixo/protobuf/schemadocument/OneOf;", "writeReservedNames", "names", "Lpro/felixo/protobuf/Identifier;", "protobuf-kotlin-schemadocument"})
@SourceDebugExtension(value={"SMAP\nSchemaDocumentWriter.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SchemaDocumentWriter.kt\npro/felixo/protobuf/schemadocument/SchemaDocumentWriter\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,127:1\n1855#2,2:128\n*S KotlinDebug\n*F\n+ 1 SchemaDocumentWriter.kt\npro/felixo/protobuf/schemadocument/SchemaDocumentWriter\n*L\n19#1:128,2\n*E\n"})
public final class SchemaDocumentWriter {
    @NotNull
    private final StringBuilder out;
    private final int indentSpaces;
    private int currentIndent;

    public SchemaDocumentWriter(@NotNull StringBuilder out, int indentSpaces) {
        Intrinsics.checkNotNullParameter((Object)out, (String)"out");
        this.out = out;
        this.indentSpaces = indentSpaces;
    }

    public /* synthetic */ SchemaDocumentWriter(StringBuilder stringBuilder, int n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 2) != 0) {
            n = 2;
        }
        this(stringBuilder, n);
    }

    public final void write(@NotNull SchemaDocument schema) {
        Intrinsics.checkNotNullParameter((Object)schema, (String)"schema");
        this.line("syntax = \"proto3\";");
        SchemaDocumentWriter.line$default(this, null, 1, null);
        Iterable $this$forEach$iv = schema.getTypes();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Type it = (Type)element$iv;
            boolean bl = false;
            this.write(it);
            SchemaDocumentWriter.line$default(this, null, 1, null);
        }
    }

    public final void write(@NotNull Type type) {
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        Type type2 = type;
        if (type2 instanceof Message) {
            this.writeMessage((Message)type);
        } else if (type2 instanceof Enum) {
            this.writeEnum((Enum)type);
        }
    }

    private final void writeMessage(Message message) {
        this.line("message " + Identifier.toString-impl((String)message.getName-BAfpDiQ()) + " {");
        this.indent((Function0<Unit>)((Function0)new Function0<Unit>(message, this){
            final /* synthetic */ Message $message;
            final /* synthetic */ SchemaDocumentWriter this$0;
            {
                this.$message = $message;
                this.this$0 = $receiver;
                super(0);
            }

            public final void invoke() {
                SchemaElement it;
                Iterable $this$forEach$iv;
                Iterable iterable = this.$message.getNestedTypes();
                SchemaDocumentWriter schemaDocumentWriter = this.this$0;
                boolean $i$f$forEach = false;
                for (T element$iv : $this$forEach$iv) {
                    it = (Type)element$iv;
                    boolean bl = false;
                    schemaDocumentWriter.write((Type)it);
                }
                SchemaDocumentWriter.access$writeMessageReservedNumbers(this.this$0, this.$message.getReservedNumbers());
                SchemaDocumentWriter.access$writeReservedNames(this.this$0, this.$message.getReservedNames());
                $this$forEach$iv = this.$message.getMembers();
                schemaDocumentWriter = this.this$0;
                $i$f$forEach = false;
                for (T element$iv : $this$forEach$iv) {
                    it = (Member)element$iv;
                    boolean bl = false;
                    SchemaDocumentWriter.access$writeMember(schemaDocumentWriter, (Member)it);
                }
            }
        }));
        this.line("}");
    }

    private final void writeMessageReservedNumbers(List<IntRange> numbers) {
        if (!((Collection)numbers).isEmpty()) {
            this.line("reserved " + CollectionsKt.joinToString$default((Iterable)numbers, (CharSequence)", ", null, null, (int)0, null, (Function1)((Function1)new Function1<IntRange, String>((Object)this){

                @NotNull
                public final String invoke(@NotNull IntRange p0) {
                    Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                    return SchemaDocumentWriter.access$fieldRangeToString((SchemaDocumentWriter)this.receiver, p0);
                }
            }), (int)30, null) + ';');
        }
    }

    private final void writeMember(Member member) {
        Member member2 = member;
        if (member2 instanceof Field) {
            this.writeField((Field)member);
        } else if (member2 instanceof OneOf) {
            this.writeOneOf((OneOf)member);
        }
    }

    private final void writeOneOf(OneOf oneOf) {
        this.line("oneof " + Identifier.toString-impl((String)oneOf.getName-BAfpDiQ()) + " {");
        this.indent((Function0<Unit>)((Function0)new Function0<Unit>(oneOf, this){
            final /* synthetic */ OneOf $oneOf;
            final /* synthetic */ SchemaDocumentWriter this$0;
            {
                this.$oneOf = $oneOf;
                this.this$0 = $receiver;
                super(0);
            }

            /*
             * WARNING - void declaration
             */
            public final void invoke() {
                void $this$forEach$iv;
                Iterable iterable = this.$oneOf.getFields();
                SchemaDocumentWriter schemaDocumentWriter = this.this$0;
                boolean $i$f$forEach = false;
                for (T element$iv : $this$forEach$iv) {
                    Field it = (Field)element$iv;
                    boolean bl = false;
                    SchemaDocumentWriter.access$writeField(schemaDocumentWriter, it);
                }
            }
        }));
        this.line("}");
    }

    private final void writeField(Field field) {
        this.line(this.rulePrefix(field.getRule()) + field.getType() + ' ' + Identifier.toString-impl((String)field.getName-BAfpDiQ()) + " = " + FieldNumber.toString-impl((int)field.getNumber-KMrIqhA()) + ';');
    }

    private final void writeEnum(Enum enum_) {
        this.line("enum " + Identifier.toString-impl((String)enum_.getName-BAfpDiQ()) + " {");
        this.indent((Function0<Unit>)((Function0)new Function0<Unit>(enum_, this){
            final /* synthetic */ Enum $enum;
            final /* synthetic */ SchemaDocumentWriter this$0;
            {
                this.$enum = $enum;
                this.this$0 = $receiver;
                super(0);
            }

            /*
             * WARNING - void declaration
             */
            public final void invoke() {
                void $this$forEach$iv;
                if (this.$enum.getAllowAlias()) {
                    SchemaDocumentWriter.access$line(this.this$0, "option allow_alias = true;");
                }
                SchemaDocumentWriter.access$writeEnumReservedNumbers(this.this$0, this.$enum.getReservedNumbers());
                SchemaDocumentWriter.access$writeReservedNames(this.this$0, this.$enum.getReservedNames());
                Iterable iterable = this.$enum.getValues();
                SchemaDocumentWriter schemaDocumentWriter = this.this$0;
                boolean $i$f$forEach = false;
                for (T element$iv : $this$forEach$iv) {
                    EnumValue it = (EnumValue)element$iv;
                    boolean bl = false;
                    SchemaDocumentWriter.access$writeEnumValue(schemaDocumentWriter, it);
                }
            }
        }));
        this.line("}");
    }

    private final void writeEnumReservedNumbers(List<IntRange> numbers) {
        if (!((Collection)numbers).isEmpty()) {
            this.line("reserved " + CollectionsKt.joinToString$default((Iterable)numbers, (CharSequence)", ", null, null, (int)0, null, (Function1)((Function1)new Function1<IntRange, String>((Object)this){

                @NotNull
                public final String invoke(@NotNull IntRange p0) {
                    Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                    return SchemaDocumentWriter.access$enumRangeToString((SchemaDocumentWriter)this.receiver, p0);
                }
            }), (int)30, null) + ';');
        }
    }

    private final void writeReservedNames(List<Identifier> names) {
        if (!((Collection)names).isEmpty()) {
            this.line("reserved " + CollectionsKt.joinToString$default((Iterable)names, (CharSequence)", ", null, null, (int)0, null, (Function1)writeReservedNames.1.INSTANCE, (int)30, null) + ';');
        }
    }

    private final void writeEnumValue(EnumValue value) {
        this.line(Identifier.toString-impl((String)value.getName-BAfpDiQ()) + " = " + value.getNumber() + ';');
    }

    private final String enumRangeToString(IntRange intRange) {
        return intRange.getFirst() == intRange.getLast() ? String.valueOf(intRange.getFirst()) : intRange.getFirst() + " to " + (intRange.getLast() == Integer.MAX_VALUE ? "max" : Integer.valueOf(intRange.getLast()));
    }

    private final String fieldRangeToString(IntRange intRange) {
        return intRange.getFirst() == intRange.getLast() ? String.valueOf(intRange.getFirst()) : intRange.getFirst() + " to " + intRange.getLast();
    }

    private final String rulePrefix(FieldRule rule) {
        String string;
        switch (WhenMappings.$EnumSwitchMapping$0[rule.ordinal()]) {
            case 1: {
                string = "";
                break;
            }
            case 2: {
                string = "optional ";
                break;
            }
            case 3: {
                string = "repeated ";
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return string;
    }

    private final void line(String s) {
        if (((CharSequence)s).length() == 0) {
            Intrinsics.checkNotNullExpressionValue((Object)this.out.append('\n'), (String)"append('\\n')");
        } else {
            StringBuilder stringBuilder = this.out.append(StringsKt.repeat((CharSequence)" ", (int)(this.currentIndent * this.indentSpaces)) + s);
            Intrinsics.checkNotNullExpressionValue((Object)stringBuilder, (String)"append(value)");
            Intrinsics.checkNotNullExpressionValue((Object)stringBuilder.append('\n'), (String)"append('\\n')");
        }
    }

    static /* synthetic */ void line$default(SchemaDocumentWriter schemaDocumentWriter, String string, int n, Object object) {
        if ((n & 1) != 0) {
            string = "";
        }
        schemaDocumentWriter.line(string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void indent(Function0<Unit> block) {
        int n = this.currentIndent;
        this.currentIndent = n + 1;
        try {
            block.invoke();
        }
        finally {
            n = this.currentIndent;
            this.currentIndent = n + -1;
        }
    }

    public static final /* synthetic */ void access$writeMessageReservedNumbers(SchemaDocumentWriter $this, List numbers) {
        $this.writeMessageReservedNumbers(numbers);
    }

    public static final /* synthetic */ void access$writeReservedNames(SchemaDocumentWriter $this, List names) {
        $this.writeReservedNames(names);
    }

    public static final /* synthetic */ void access$writeMember(SchemaDocumentWriter $this, Member member) {
        $this.writeMember(member);
    }

    public static final /* synthetic */ String access$fieldRangeToString(SchemaDocumentWriter $this, IntRange intRange) {
        return $this.fieldRangeToString(intRange);
    }

    public static final /* synthetic */ void access$writeField(SchemaDocumentWriter $this, Field field) {
        $this.writeField(field);
    }

    public static final /* synthetic */ void access$line(SchemaDocumentWriter $this, String s) {
        $this.line(s);
    }

    public static final /* synthetic */ void access$writeEnumReservedNumbers(SchemaDocumentWriter $this, List numbers) {
        $this.writeEnumReservedNumbers(numbers);
    }

    public static final /* synthetic */ void access$writeEnumValue(SchemaDocumentWriter $this, EnumValue value) {
        $this.writeEnumValue(value);
    }

    public static final /* synthetic */ String access$enumRangeToString(SchemaDocumentWriter $this, IntRange intRange) {
        return $this.enumRangeToString(intRange);
    }

    @Metadata(mv={1, 9, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[FieldRule.values().length];
            try {
                nArray[FieldRule.Singular.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[FieldRule.Optional.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[FieldRule.Repeated.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

