/*
 * Decompiled with CFR 0.152.
 */
package pro.felixo.protobuf.schemadocument;

import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.IntRange;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import pro.felixo.protobuf.EnumValue;
import pro.felixo.protobuf.FieldNumber;
import pro.felixo.protobuf.FieldRule;
import pro.felixo.protobuf.Identifier;
import pro.felixo.protobuf.schemadocument.Enum;
import pro.felixo.protobuf.schemadocument.Field;
import pro.felixo.protobuf.schemadocument.Member;
import pro.felixo.protobuf.schemadocument.Message;
import pro.felixo.protobuf.schemadocument.OneOf;
import pro.felixo.protobuf.schemadocument.SchemaDocument;
import pro.felixo.protobuf.schemadocument.SchemaDocumentWriter;
import pro.felixo.protobuf.schemadocument.SchemaElement;
import pro.felixo.protobuf.schemadocument.Type;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0088\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u001d\u0012\n\u0010\u0002\u001a\u00060\u0003j\u0002`\u0004\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\u000e\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rJ\u000e\u0010\n\u001a\u00020\u000b2\u0006\u0010\u000e\u001a\u00020\u000fJ\u0010\u0010\u0010\u001a\u00020\u000b2\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J\u0016\u0010\u0013\u001a\u00020\u000b2\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00160\u0015H\u0002J\u0010\u0010\u0017\u001a\u00020\u000b2\u0006\u0010\u0018\u001a\u00020\u0019H\u0002J\u0010\u0010\u001a\u001a\u00020\u000b2\u0006\u0010\u001b\u001a\u00020\u001cH\u0002J\u0010\u0010\u001d\u001a\u00020\u000b2\u0006\u0010\u001e\u001a\u00020\u001fH\u0002J\u0010\u0010 \u001a\u00020\u000b2\u0006\u0010!\u001a\u00020\"H\u0002J\u0016\u0010#\u001a\u00020\u000b2\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00160\u0015H\u0002J\u0016\u0010$\u001a\u00020\u000b2\f\u0010%\u001a\b\u0012\u0004\u0012\u00020&0\u0015H\u0002J\u0010\u0010'\u001a\u00020\u000b2\u0006\u0010(\u001a\u00020)H\u0002J\u0010\u0010*\u001a\u00020+2\u0006\u0010,\u001a\u00020\u0016H\u0002J\u0010\u0010-\u001a\u00020+2\u0006\u0010,\u001a\u00020\u0016H\u0002J\u0010\u0010.\u001a\u00020+2\u0006\u0010/\u001a\u000200H\u0002J\u0012\u00101\u001a\u00020\u000b2\b\b\u0002\u00102\u001a\u00020+H\u0002J\u0016\u00103\u001a\u00020\u000b2\f\u00104\u001a\b\u0012\u0004\u0012\u00020\u000b05H\u0002R\u0012\u0010\u0002\u001a\u00060\u0003j\u0002`\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u00066"}, d2={"Lpro/felixo/protobuf/schemadocument/SchemaDocumentWriter;", "", "out", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "indentSpaces", "", "<init>", "(Ljava/lang/StringBuilder;I)V", "currentIndent", "write", "", "schema", "Lpro/felixo/protobuf/schemadocument/SchemaDocument;", "type", "Lpro/felixo/protobuf/schemadocument/Type;", "writeMessage", "message", "Lpro/felixo/protobuf/schemadocument/Message;", "writeMessageReservedNumbers", "numbers", "", "Lkotlin/ranges/IntRange;", "writeMember", "member", "Lpro/felixo/protobuf/schemadocument/Member;", "writeOneOf", "oneOf", "Lpro/felixo/protobuf/schemadocument/OneOf;", "writeField", "field", "Lpro/felixo/protobuf/schemadocument/Field;", "writeEnum", "enum", "Lpro/felixo/protobuf/schemadocument/Enum;", "writeEnumReservedNumbers", "writeReservedNames", "names", "Lpro/felixo/protobuf/Identifier;", "writeEnumValue", "value", "Lpro/felixo/protobuf/EnumValue;", "enumRangeToString", "", "intRange", "fieldRangeToString", "rulePrefix", "rule", "Lpro/felixo/protobuf/FieldRule;", "line", "s", "indent", "block", "Lkotlin/Function0;", "protobuf-kotlin-schemadocument"})
@SourceDebugExtension(value={"SMAP\nSchemaDocumentWriter.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SchemaDocumentWriter.kt\npro/felixo/protobuf/schemadocument/SchemaDocumentWriter\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,127:1\n1863#2,2:128\n1863#2,2:130\n1863#2,2:132\n1863#2,2:134\n1863#2,2:136\n*S KotlinDebug\n*F\n+ 1 SchemaDocumentWriter.kt\npro/felixo/protobuf/schemadocument/SchemaDocumentWriter\n*L\n19#1:128,2\n35#1:130,2\n38#1:132,2\n58#1:134,2\n74#1:136,2\n*E\n"})
public final class SchemaDocumentWriter {
    @NotNull
    private final StringBuilder out;
    private final int indentSpaces;
    private int currentIndent;

    public SchemaDocumentWriter(@NotNull StringBuilder out, int indentSpaces) {
        Intrinsics.checkNotNullParameter((Object)out, (String)"out");
        this.out = out;
        this.indentSpaces = indentSpaces;
    }

    public /* synthetic */ SchemaDocumentWriter(StringBuilder stringBuilder, int n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 2) != 0) {
            n = 2;
        }
        this(stringBuilder, n);
    }

    public final void write(@NotNull SchemaDocument schema) {
        Intrinsics.checkNotNullParameter((Object)schema, (String)"schema");
        this.line("syntax = \"proto3\";");
        SchemaDocumentWriter.line$default(this, null, 1, null);
        Iterable $this$forEach$iv = schema.getTypes();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Type it = (Type)element$iv;
            boolean bl = false;
            this.write(it);
            SchemaDocumentWriter.line$default(this, null, 1, null);
        }
    }

    public final void write(@NotNull Type type) {
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        Type type2 = type;
        if (type2 instanceof Message) {
            this.writeMessage((Message)type);
        } else if (type2 instanceof Enum) {
            this.writeEnum((Enum)type);
        } else {
            throw new NoWhenBranchMatchedException();
        }
    }

    private final void writeMessage(Message message) {
        this.line("message " + Identifier.toString-impl((String)message.getName-BAfpDiQ()) + " {");
        this.indent((Function0<Unit>)((Function0)() -> SchemaDocumentWriter.writeMessage$lambda$3(message, this)));
        this.line("}");
    }

    private final void writeMessageReservedNumbers(List<IntRange> numbers) {
        if (!((Collection)numbers).isEmpty()) {
            this.line("reserved " + CollectionsKt.joinToString$default((Iterable)numbers, (CharSequence)", ", null, null, (int)0, null, (Function1)((Function1)new Function1<IntRange, String>((Object)this){

                public final String invoke(IntRange p0) {
                    Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                    return SchemaDocumentWriter.access$fieldRangeToString((SchemaDocumentWriter)this.receiver, p0);
                }
            }), (int)30, null) + ';');
        }
    }

    private final void writeMember(Member member) {
        Member member2 = member;
        if (member2 instanceof Field) {
            this.writeField((Field)member);
        } else if (member2 instanceof OneOf) {
            this.writeOneOf((OneOf)member);
        } else {
            throw new NoWhenBranchMatchedException();
        }
    }

    private final void writeOneOf(OneOf oneOf) {
        this.line("oneof " + Identifier.toString-impl((String)oneOf.getName-BAfpDiQ()) + " {");
        this.indent((Function0<Unit>)((Function0)() -> SchemaDocumentWriter.writeOneOf$lambda$5(oneOf, this)));
        this.line("}");
    }

    private final void writeField(Field field) {
        this.line(this.rulePrefix(field.getRule()) + field.getType() + ' ' + Identifier.toString-impl((String)field.getName-BAfpDiQ()) + " = " + FieldNumber.toString-impl((int)field.getNumber-KMrIqhA()) + ';');
    }

    private final void writeEnum(Enum enum_) {
        this.line("enum " + Identifier.toString-impl((String)enum_.getName-BAfpDiQ()) + " {");
        this.indent((Function0<Unit>)((Function0)() -> SchemaDocumentWriter.writeEnum$lambda$7(enum_, this)));
        this.line("}");
    }

    private final void writeEnumReservedNumbers(List<IntRange> numbers) {
        if (!((Collection)numbers).isEmpty()) {
            this.line("reserved " + CollectionsKt.joinToString$default((Iterable)numbers, (CharSequence)", ", null, null, (int)0, null, (Function1)((Function1)new Function1<IntRange, String>((Object)this){

                public final String invoke(IntRange p0) {
                    Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                    return SchemaDocumentWriter.access$enumRangeToString((SchemaDocumentWriter)this.receiver, p0);
                }
            }), (int)30, null) + ';');
        }
    }

    private final void writeReservedNames(List<Identifier> names) {
        if (!((Collection)names).isEmpty()) {
            this.line("reserved " + CollectionsKt.joinToString$default((Iterable)names, (CharSequence)", ", null, null, (int)0, null, (Function1)writeReservedNames.1.INSTANCE, (int)30, null) + ';');
        }
    }

    private final void writeEnumValue(EnumValue value) {
        this.line(Identifier.toString-impl((String)value.getName-BAfpDiQ()) + " = " + value.getNumber() + ';');
    }

    private final String enumRangeToString(IntRange intRange) {
        return intRange.getFirst() == intRange.getLast() ? String.valueOf(intRange.getFirst()) : intRange.getFirst() + " to " + (intRange.getLast() == Integer.MAX_VALUE ? "max" : Integer.valueOf(intRange.getLast()));
    }

    private final String fieldRangeToString(IntRange intRange) {
        return intRange.getFirst() == intRange.getLast() ? String.valueOf(intRange.getFirst()) : intRange.getFirst() + " to " + intRange.getLast();
    }

    private final String rulePrefix(FieldRule rule) {
        String string;
        switch (WhenMappings.$EnumSwitchMapping$0[rule.ordinal()]) {
            case 1: {
                string = "";
                break;
            }
            case 2: {
                string = "optional ";
                break;
            }
            case 3: {
                string = "repeated ";
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return string;
    }

    private final void line(String s) {
        StringBuilder stringBuilder;
        if (((CharSequence)s).length() == 0) {
            StringBuilder stringBuilder2 = this.out.append('\n');
            stringBuilder = stringBuilder2;
            Intrinsics.checkNotNullExpressionValue((Object)stringBuilder2, (String)"append(...)");
        } else {
            StringBuilder stringBuilder3 = this.out.append(StringsKt.repeat((CharSequence)" ", (int)(this.currentIndent * this.indentSpaces)) + s);
            Intrinsics.checkNotNullExpressionValue((Object)stringBuilder3, (String)"append(...)");
            StringBuilder stringBuilder4 = stringBuilder3.append('\n');
            stringBuilder = stringBuilder4;
            Intrinsics.checkNotNullExpressionValue((Object)stringBuilder4, (String)"append(...)");
        }
    }

    static /* synthetic */ void line$default(SchemaDocumentWriter schemaDocumentWriter, String string, int n, Object object) {
        if ((n & 1) != 0) {
            string = "";
        }
        schemaDocumentWriter.line(string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void indent(Function0<Unit> block) {
        int n = this.currentIndent;
        this.currentIndent = n + 1;
        try {
            block.invoke();
        }
        finally {
            n = this.currentIndent;
            this.currentIndent = n + -1;
        }
    }

    private static final Unit writeMessage$lambda$3(Message $message, SchemaDocumentWriter this$0) {
        SchemaElement it;
        Iterable $this$forEach$iv = $message.getNestedTypes();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            it = (Type)element$iv;
            boolean bl = false;
            this$0.write((Type)it);
        }
        this$0.writeMessageReservedNumbers($message.getReservedNumbers());
        this$0.writeReservedNames($message.getReservedNames());
        $this$forEach$iv = $message.getMembers();
        $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            it = (Member)element$iv;
            boolean bl = false;
            this$0.writeMember((Member)it);
        }
        return Unit.INSTANCE;
    }

    private static final Unit writeOneOf$lambda$5(OneOf $oneOf, SchemaDocumentWriter this$0) {
        Iterable $this$forEach$iv = $oneOf.getFields();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Field it = (Field)element$iv;
            boolean bl = false;
            this$0.writeField(it);
        }
        return Unit.INSTANCE;
    }

    private static final Unit writeEnum$lambda$7(Enum $enum, SchemaDocumentWriter this$0) {
        if ($enum.getAllowAlias()) {
            this$0.line("option allow_alias = true;");
        }
        this$0.writeEnumReservedNumbers($enum.getReservedNumbers());
        this$0.writeReservedNames($enum.getReservedNames());
        Iterable $this$forEach$iv = $enum.getValues();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            EnumValue it = (EnumValue)element$iv;
            boolean bl = false;
            this$0.writeEnumValue(it);
        }
        return Unit.INSTANCE;
    }

    public static final /* synthetic */ String access$fieldRangeToString(SchemaDocumentWriter $this, IntRange intRange) {
        return $this.fieldRangeToString(intRange);
    }

    public static final /* synthetic */ String access$enumRangeToString(SchemaDocumentWriter $this, IntRange intRange) {
        return $this.enumRangeToString(intRange);
    }

    @Metadata(mv={2, 0, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[FieldRule.values().length];
            try {
                nArray[FieldRule.Singular.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[FieldRule.Optional.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[FieldRule.Repeated.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

