/*
 * Decompiled with CFR 0.152.
 */
package pro.felixo.protobuf.serialization.encoding;

import java.util.List;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.UInt;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import kotlinx.serialization.encoding.Decoder;
import kotlinx.serialization.encoding.Encoder;
import kotlinx.serialization.modules.SerializersModule;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import pro.felixo.protobuf.FieldNumber;
import pro.felixo.protobuf.Identifier;
import pro.felixo.protobuf.serialization.Enum;
import pro.felixo.protobuf.serialization.Message;
import pro.felixo.protobuf.serialization.Type;
import pro.felixo.protobuf.serialization.encoding.ByteArrayDecoder;
import pro.felixo.protobuf.serialization.encoding.ByteArrayEncoder;
import pro.felixo.protobuf.serialization.encoding.EncodeUtilKt;
import pro.felixo.protobuf.serialization.encoding.PrimitiveDecoder;
import pro.felixo.protobuf.serialization.encoding.PrimitiveEncoder;
import pro.felixo.protobuf.wire.UtilKt;
import pro.felixo.protobuf.wire.WireBuffer;
import pro.felixo.protobuf.wire.WireType;
import pro.felixo.protobuf.wire.WireValue;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0017\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b6\u0018\u00002\u00020\u0001:\u0015\u0019\u001a\u001b\u001c\u001d\u001e\u001f !\"#$%&'()*+,-B\u0007\b\u0004\u00a2\u0006\u0002\u0010\u0002J\u001e\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000fH\u0016J5\u0010\u0011\u001a\u00020\u00122\u0006\u0010\f\u001a\u00020\r2\b\u0010\u0013\u001a\u0004\u0018\u00010\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0004H\u0016\u00f8\u0001\u0000\u00f8\u0001\u0001\u00a2\u0006\u0002\b\u0018R\u0012\u0010\u0003\u001a\u00020\u0004X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0003\u0010\u0005R\u0012\u0010\u0006\u001a\u00020\u0007X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\t\u0082\u0001\u0002./\u0082\u0002\u000b\n\u0005\b\u00a1\u001e0\u0001\n\u0002\b\u0019\u00a8\u00060"}, d2={"Lpro/felixo/protobuf/serialization/encoding/FieldEncoding;", "", "()V", "isPackable", "", "()Z", "wireType", "Lpro/felixo/protobuf/wire/WireType;", "getWireType", "()Lpro/felixo/protobuf/wire/WireType;", "decoder", "Lkotlinx/serialization/encoding/Decoder;", "serializersModule", "Lkotlinx/serialization/modules/SerializersModule;", "input", "", "Lpro/felixo/protobuf/wire/WireValue;", "encoder", "Lkotlinx/serialization/encoding/Encoder;", "fieldNumber", "Lpro/felixo/protobuf/FieldNumber;", "output", "Lpro/felixo/protobuf/wire/WireBuffer;", "encodeZeroValue", "encoder-TFX4cgo", "Bool", "Bytes", "Double", "EnumReference", "Fixed32", "Fixed64", "Float", "Int32", "Int64", "Integer32", "Integer64", "MessageReference", "Reference", "SFixed32", "SFixed64", "SInt32", "SInt64", "Scalar", "String", "UInt32", "UInt64", "Lpro/felixo/protobuf/serialization/encoding/FieldEncoding$Reference;", "Lpro/felixo/protobuf/serialization/encoding/FieldEncoding$Scalar;", "protobuf-kotlin-serialization"})
public abstract class FieldEncoding {
    private FieldEncoding() {
    }

    public abstract boolean isPackable();

    @NotNull
    public abstract WireType getWireType();

    @NotNull
    public Encoder encoder-TFX4cgo(@NotNull SerializersModule serializersModule, @Nullable FieldNumber fieldNumber, @NotNull WireBuffer output, boolean encodeZeroValue) {
        Intrinsics.checkNotNullParameter((Object)serializersModule, (java.lang.String)"serializersModule");
        Intrinsics.checkNotNullParameter((Object)output, (java.lang.String)"output");
        return new PrimitiveEncoder(serializersModule, output, this, encodeZeroValue, fieldNumber, null);
    }

    @NotNull
    public Decoder decoder(@NotNull SerializersModule serializersModule, @NotNull List<? extends WireValue> input) {
        Intrinsics.checkNotNullParameter((Object)serializersModule, (java.lang.String)"serializersModule");
        Intrinsics.checkNotNullParameter(input, (java.lang.String)"input");
        return new PrimitiveDecoder(serializersModule, input, this);
    }

    public /* synthetic */ FieldEncoding(DefaultConstructorMarker $constructor_marker) {
        this();
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0003J$\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0012\u0010\u000e\u001a\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u000b0\u000fH\u0016J\u001a\u0010\u0010\u001a\u0004\u0018\u00010\r2\u0006\u0010\u0011\u001a\u00020\u00022\u0006\u0010\u0012\u001a\u00020\u0002H\u0016R\u0014\u0010\u0004\u001a\u00020\u0002X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0004\u0010\u0005R\u0014\u0010\u0006\u001a\u00020\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u0006\u0013"}, d2={"Lpro/felixo/protobuf/serialization/encoding/FieldEncoding$Bool;", "Lpro/felixo/protobuf/serialization/encoding/FieldEncoding$Scalar;", "", "()V", "isPackable", "()Z", "wireType", "Lpro/felixo/protobuf/wire/WireType;", "getWireType", "()Lpro/felixo/protobuf/wire/WireType;", "decode", "", "wire", "Lpro/felixo/protobuf/wire/WireValue;", "onValue", "Lkotlin/Function1;", "encode", "value", "encodeZeroValue", "protobuf-kotlin-serialization"})
    public static final class Bool
    extends Scalar<Boolean> {
        @NotNull
        public static final Bool INSTANCE = new Bool();
        @NotNull
        private static final WireType wireType = WireType.VarInt;
        private static final boolean isPackable = true;

        private Bool() {
            super("bool", null);
        }

        @Override
        @NotNull
        public WireType getWireType() {
            return wireType;
        }

        @Override
        public boolean isPackable() {
            return isPackable;
        }

        @Override
        public void decode(@NotNull WireValue wire, @NotNull Function1<? super Boolean, Unit> onValue) {
            Intrinsics.checkNotNullParameter((Object)wire, (java.lang.String)"wire");
            Intrinsics.checkNotNullParameter(onValue, (java.lang.String)"onValue");
            WireValue wireValue = wire;
            if (wireValue instanceof WireValue.VarInt) {
                onValue.invoke((Object)(((WireValue.VarInt)wire).unbox-impl() != 0L ? 1 : 0));
            } else if (wireValue instanceof WireValue.Len) {
                while (((WireValue.Len)wire).unbox-impl().getRemaining() > 0) {
                    onValue.invoke((Object)(((WireValue.Len)wire).unbox-impl().readVarIntAsInt() != 0 ? 1 : 0));
                }
            } else {
                if (wireValue instanceof WireValue.Fixed32) {
                    throw new IllegalStateException("Cannot decode bool from fixed32".toString());
                }
                if (wireValue instanceof WireValue.Fixed64) {
                    throw new IllegalStateException("Cannot decode bool from fixed64".toString());
                }
                throw new NoWhenBranchMatchedException();
            }
        }

        @Override
        @Nullable
        public WireValue encode(boolean value, boolean encodeZeroValue) {
            return (WireValue)EncodeUtilKt.varInt(value ? 1 : 0, encodeZeroValue);
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0012\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0003J$\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0012\u0010\u000f\u001a\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\f0\u0010H\u0016J\u001e\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u000e0\u0016H\u0016J\u001a\u0010\u0017\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u0018\u001a\u00020\u00022\u0006\u0010\u0019\u001a\u00020\u0005H\u0016J5\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u0013\u001a\u00020\u00142\b\u0010\u001c\u001a\u0004\u0018\u00010\u001d2\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010\u0019\u001a\u00020\u0005H\u0016\u00f8\u0001\u0000\u00f8\u0001\u0001\u00a2\u0006\u0002\b R\u0014\u0010\u0004\u001a\u00020\u0005X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0004\u0010\u0006R\u0014\u0010\u0007\u001a\u00020\bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u0082\u0002\u000b\n\u0005\b\u00a1\u001e0\u0001\n\u0002\b\u0019\u00a8\u0006!"}, d2={"Lpro/felixo/protobuf/serialization/encoding/FieldEncoding$Bytes;", "Lpro/felixo/protobuf/serialization/encoding/FieldEncoding$Scalar;", "", "()V", "isPackable", "", "()Z", "wireType", "Lpro/felixo/protobuf/wire/WireType;", "getWireType", "()Lpro/felixo/protobuf/wire/WireType;", "decode", "", "wire", "Lpro/felixo/protobuf/wire/WireValue;", "onValue", "Lkotlin/Function1;", "decoder", "Lpro/felixo/protobuf/serialization/encoding/ByteArrayDecoder;", "serializersModule", "Lkotlinx/serialization/modules/SerializersModule;", "input", "", "encode", "value", "encodeZeroValue", "encoder", "Lpro/felixo/protobuf/serialization/encoding/ByteArrayEncoder;", "fieldNumber", "Lpro/felixo/protobuf/FieldNumber;", "output", "Lpro/felixo/protobuf/wire/WireBuffer;", "encoder-TFX4cgo", "protobuf-kotlin-serialization"})
    public static final class Bytes
    extends Scalar<byte[]> {
        @NotNull
        public static final Bytes INSTANCE = new Bytes();
        @NotNull
        private static final WireType wireType = WireType.Len;
        private static final boolean isPackable;

        private Bytes() {
            super("bytes", null);
        }

        @Override
        @NotNull
        public WireType getWireType() {
            return wireType;
        }

        @Override
        public boolean isPackable() {
            return isPackable;
        }

        @Override
        public void decode(@NotNull WireValue wire, @NotNull Function1<? super byte[], Unit> onValue) {
            Intrinsics.checkNotNullParameter((Object)wire, (java.lang.String)"wire");
            Intrinsics.checkNotNullParameter(onValue, (java.lang.String)"onValue");
            WireValue wireValue = wire;
            if (!(wireValue instanceof WireValue.Len)) {
                if (wireValue instanceof WireValue.VarInt) {
                    throw new IllegalStateException("Cannot decode string from varint".toString());
                }
                if (wireValue instanceof WireValue.Fixed32) {
                    throw new IllegalStateException("Cannot decode string from fixed32".toString());
                }
                if (wireValue instanceof WireValue.Fixed64) {
                    throw new IllegalStateException("Cannot decode string from fixed64".toString());
                }
                throw new NoWhenBranchMatchedException();
            }
            onValue.invoke((Object)((WireValue.Len)wire).unbox-impl().readBytes());
        }

        @Override
        @Nullable
        public WireValue encode(@NotNull byte[] value, boolean encodeZeroValue) {
            Intrinsics.checkNotNullParameter((Object)value, (java.lang.String)"value");
            WireBuffer wireBuffer = EncodeUtilKt.len(value, encodeZeroValue);
            return wireBuffer != null ? WireValue.Len.box-impl((WireBuffer)wireBuffer) : null;
        }

        @Override
        @NotNull
        public ByteArrayEncoder encoder-TFX4cgo(@NotNull SerializersModule serializersModule, @Nullable FieldNumber fieldNumber, @NotNull WireBuffer output, boolean encodeZeroValue) {
            Intrinsics.checkNotNullParameter((Object)serializersModule, (java.lang.String)"serializersModule");
            Intrinsics.checkNotNullParameter((Object)output, (java.lang.String)"output");
            FieldNumber fieldNumber2 = fieldNumber;
            if (fieldNumber2 == null) {
                java.lang.String string = "Required value was null.";
                throw new IllegalArgumentException(string.toString());
            }
            return new ByteArrayEncoder(serializersModule, output, fieldNumber2.unbox-impl(), encodeZeroValue, null);
        }

        @Override
        @NotNull
        public ByteArrayDecoder decoder(@NotNull SerializersModule serializersModule, @NotNull List<? extends WireValue> input) {
            Intrinsics.checkNotNullParameter((Object)serializersModule, (java.lang.String)"serializersModule");
            Intrinsics.checkNotNullParameter(input, (java.lang.String)"input");
            return new ByteArrayDecoder(serializersModule, input);
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0003J$\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0012\u0010\u000f\u001a\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\f0\u0010H\u0016J(\u0010\u0011\u001a\u0004\u0018\u00010\u00122\u0006\u0010\u0013\u001a\u00020\u00022\u0006\u0010\u0014\u001a\u00020\u0005H\u0016\u00f8\u0001\u0000\u00f8\u0001\u0001\u00f8\u0001\u0002\u00a2\u0006\u0002\b\u0015R\u0014\u0010\u0004\u001a\u00020\u0005X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0004\u0010\u0006R\u0014\u0010\u0007\u001a\u00020\bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u0082\u0002\u000f\n\u0002\b!\n\u0005\b\u00a1\u001e0\u0001\n\u0002\b\u0019\u00a8\u0006\u0016"}, d2={"Lpro/felixo/protobuf/serialization/encoding/FieldEncoding$Double;", "Lpro/felixo/protobuf/serialization/encoding/FieldEncoding$Scalar;", "", "()V", "isPackable", "", "()Z", "wireType", "Lpro/felixo/protobuf/wire/WireType;", "getWireType", "()Lpro/felixo/protobuf/wire/WireType;", "decode", "", "wire", "Lpro/felixo/protobuf/wire/WireValue;", "onValue", "Lkotlin/Function1;", "encode", "Lpro/felixo/protobuf/wire/WireValue$Fixed64;", "value", "encodeZeroValue", "encode-SoR35ng", "protobuf-kotlin-serialization"})
    public static final class Double
    extends Scalar<java.lang.Double> {
        @NotNull
        public static final Double INSTANCE = new Double();
        @NotNull
        private static final WireType wireType = WireType.Fixed64;
        private static final boolean isPackable = true;

        private Double() {
            super("double", null);
        }

        @Override
        @NotNull
        public WireType getWireType() {
            return wireType;
        }

        @Override
        public boolean isPackable() {
            return isPackable;
        }

        @Override
        public void decode(@NotNull WireValue wire, @NotNull Function1<? super java.lang.Double, Unit> onValue) {
            Intrinsics.checkNotNullParameter((Object)wire, (java.lang.String)"wire");
            Intrinsics.checkNotNullParameter(onValue, (java.lang.String)"onValue");
            WireValue wireValue = wire;
            if (wireValue instanceof WireValue.Fixed64) {
                onValue.invoke((Object)java.lang.Double.longBitsToDouble(((WireValue.Fixed64)wire).unbox-impl()));
            } else if (wireValue instanceof WireValue.Len) {
                while (((WireValue.Len)wire).unbox-impl().getRemaining() > 0) {
                    onValue.invoke((Object)java.lang.Double.longBitsToDouble(((WireValue.Len)wire).unbox-impl().readFixed64()));
                }
            } else {
                if (wireValue instanceof WireValue.Fixed32) {
                    throw new IllegalStateException("Cannot decode double from fixed32".toString());
                }
                if (wireValue instanceof WireValue.VarInt) {
                    throw new IllegalStateException("Cannot decode double from varint".toString());
                }
                throw new NoWhenBranchMatchedException();
            }
        }

        @Nullable
        public WireValue.Fixed64 encode-SoR35ng(double value, boolean encodeZeroValue) {
            return EncodeUtilKt.fixed64(java.lang.Double.doubleToRawLongBits(value), encodeZeroValue);
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0002\u0010\u0004J\u001e\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u0010H\u0016J5\u0010\u0012\u001a\u00020\u00132\u0006\u0010\r\u001a\u00020\u000e2\b\u0010\u0014\u001a\u0004\u0018\u00010\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019H\u0016\u00f8\u0001\u0000\u00f8\u0001\u0001\u00a2\u0006\u0002\b\u001aR\u0014\u0010\u0003\u001a\u00020\u0002X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0014\u0010\u0007\u001a\u00020\bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u0082\u0002\u000b\n\u0005\b\u00a1\u001e0\u0001\n\u0002\b\u0019\u00a8\u0006\u001b"}, d2={"Lpro/felixo/protobuf/serialization/encoding/FieldEncoding$EnumReference;", "Lpro/felixo/protobuf/serialization/encoding/FieldEncoding$Reference;", "Lpro/felixo/protobuf/serialization/Enum;", "type", "(Lpro/felixo/protobuf/serialization/Enum;)V", "getType", "()Lpro/felixo/protobuf/serialization/Enum;", "wireType", "Lpro/felixo/protobuf/wire/WireType;", "getWireType", "()Lpro/felixo/protobuf/wire/WireType;", "decoder", "Lkotlinx/serialization/encoding/Decoder;", "serializersModule", "Lkotlinx/serialization/modules/SerializersModule;", "input", "", "Lpro/felixo/protobuf/wire/WireValue;", "encoder", "Lkotlinx/serialization/encoding/Encoder;", "fieldNumber", "Lpro/felixo/protobuf/FieldNumber;", "output", "Lpro/felixo/protobuf/wire/WireBuffer;", "encodeZeroValue", "", "encoder-TFX4cgo", "protobuf-kotlin-serialization"})
    public static final class EnumReference
    extends Reference<Enum> {
        @NotNull
        private final Enum type;
        @NotNull
        private final WireType wireType;

        public EnumReference(@NotNull Enum type) {
            Intrinsics.checkNotNullParameter((Object)type, (java.lang.String)"type");
            super(null);
            this.type = type;
            this.wireType = WireType.VarInt;
        }

        @Override
        @NotNull
        public Enum getType() {
            return this.type;
        }

        @Override
        @NotNull
        public WireType getWireType() {
            return this.wireType;
        }

        @Override
        @NotNull
        public Encoder encoder-TFX4cgo(@NotNull SerializersModule serializersModule, @Nullable FieldNumber fieldNumber, @NotNull WireBuffer output, boolean encodeZeroValue) {
            Intrinsics.checkNotNullParameter((Object)serializersModule, (java.lang.String)"serializersModule");
            Intrinsics.checkNotNullParameter((Object)output, (java.lang.String)"output");
            return new PrimitiveEncoder(serializersModule, output, this, encodeZeroValue, fieldNumber, null);
        }

        @Override
        @NotNull
        public Decoder decoder(@NotNull SerializersModule serializersModule, @NotNull List<? extends WireValue> input) {
            Intrinsics.checkNotNullParameter((Object)serializersModule, (java.lang.String)"serializersModule");
            Intrinsics.checkNotNullParameter(input, (java.lang.String)"input");
            return new PrimitiveDecoder(serializersModule, input, this);
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J$\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0012\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\b0\fH\u0016J\u001a\u0010\u000e\u001a\u0004\u0018\u00010\n2\u0006\u0010\u000f\u001a\u00020\r2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\"\u0010\u000e\u001a\u0004\u0018\u00010\n2\u0006\u0010\u000f\u001a\u00020\r2\u0006\u0010\u0012\u001a\u00020\r2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016R\u0014\u0010\u0003\u001a\u00020\u0004X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0013"}, d2={"Lpro/felixo/protobuf/serialization/encoding/FieldEncoding$Fixed32;", "Lpro/felixo/protobuf/serialization/encoding/FieldEncoding$Integer32;", "()V", "wireType", "Lpro/felixo/protobuf/wire/WireType;", "getWireType", "()Lpro/felixo/protobuf/wire/WireType;", "decode", "", "wire", "Lpro/felixo/protobuf/wire/WireValue;", "onValue", "Lkotlin/Function1;", "", "encode", "value", "encodeZeroValue", "", "mask", "protobuf-kotlin-serialization"})
    public static final class Fixed32
    extends Integer32 {
        @NotNull
        public static final Fixed32 INSTANCE = new Fixed32();
        @NotNull
        private static final WireType wireType = WireType.Fixed32;

        private Fixed32() {
            super("fixed32", null);
        }

        @Override
        @NotNull
        public WireType getWireType() {
            return wireType;
        }

        @Override
        public void decode(@NotNull WireValue wire, @NotNull Function1<? super Integer, Unit> onValue) {
            Intrinsics.checkNotNullParameter((Object)wire, (java.lang.String)"wire");
            Intrinsics.checkNotNullParameter(onValue, (java.lang.String)"onValue");
            WireValue wireValue = wire;
            if (wireValue instanceof WireValue.Fixed32) {
                onValue.invoke((Object)((WireValue.Fixed32)wire).unbox-impl());
            } else if (wireValue instanceof WireValue.Len) {
                while (((WireValue.Len)wire).unbox-impl().getRemaining() > 0) {
                    onValue.invoke((Object)((WireValue.Len)wire).unbox-impl().readFixed32());
                }
            } else {
                if (wireValue instanceof WireValue.Fixed64) {
                    throw new IllegalStateException("Cannot decode fixed32 from fixed64".toString());
                }
                if (wireValue instanceof WireValue.VarInt) {
                    throw new IllegalStateException("Cannot decode fixed32 from varint".toString());
                }
                throw new NoWhenBranchMatchedException();
            }
        }

        @Override
        @Nullable
        public WireValue encode(int value, int mask, boolean encodeZeroValue) {
            return (WireValue)EncodeUtilKt.fixed32(value & mask, encodeZeroValue);
        }

        @Override
        @Nullable
        public WireValue encode(int value, boolean encodeZeroValue) {
            return (WireValue)EncodeUtilKt.fixed32(value, encodeZeroValue);
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J$\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0012\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\b0\fH\u0016J\u001a\u0010\u000e\u001a\u0004\u0018\u00010\n2\u0006\u0010\u000f\u001a\u00020\r2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016R\u0014\u0010\u0003\u001a\u00020\u0004X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0012"}, d2={"Lpro/felixo/protobuf/serialization/encoding/FieldEncoding$Fixed64;", "Lpro/felixo/protobuf/serialization/encoding/FieldEncoding$Integer64;", "()V", "wireType", "Lpro/felixo/protobuf/wire/WireType;", "getWireType", "()Lpro/felixo/protobuf/wire/WireType;", "decode", "", "wire", "Lpro/felixo/protobuf/wire/WireValue;", "onValue", "Lkotlin/Function1;", "", "encode", "value", "encodeZeroValue", "", "protobuf-kotlin-serialization"})
    public static final class Fixed64
    extends Integer64 {
        @NotNull
        public static final Fixed64 INSTANCE = new Fixed64();
        @NotNull
        private static final WireType wireType = WireType.Fixed64;

        private Fixed64() {
            super("fixed64", null);
        }

        @Override
        @NotNull
        public WireType getWireType() {
            return wireType;
        }

        @Override
        public void decode(@NotNull WireValue wire, @NotNull Function1<? super Long, Unit> onValue) {
            Intrinsics.checkNotNullParameter((Object)wire, (java.lang.String)"wire");
            Intrinsics.checkNotNullParameter(onValue, (java.lang.String)"onValue");
            WireValue wireValue = wire;
            if (wireValue instanceof WireValue.Fixed64) {
                onValue.invoke((Object)((WireValue.Fixed64)wire).unbox-impl());
            } else if (wireValue instanceof WireValue.Len) {
                while (((WireValue.Len)wire).unbox-impl().getRemaining() > 0) {
                    onValue.invoke((Object)((WireValue.Len)wire).unbox-impl().readFixed64());
                }
            } else {
                if (wireValue instanceof WireValue.Fixed32) {
                    throw new IllegalStateException("Cannot decode fixed64 from fixed32".toString());
                }
                if (wireValue instanceof WireValue.VarInt) {
                    throw new IllegalStateException("Cannot decode fixed32 from varint".toString());
                }
                throw new NoWhenBranchMatchedException();
            }
        }

        @Override
        @Nullable
        public WireValue encode(long value, boolean encodeZeroValue) {
            return (WireValue)EncodeUtilKt.fixed64(value, encodeZeroValue);
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0003J$\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0012\u0010\u000f\u001a\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\f0\u0010H\u0016J(\u0010\u0011\u001a\u0004\u0018\u00010\u00122\u0006\u0010\u0013\u001a\u00020\u00022\u0006\u0010\u0014\u001a\u00020\u0005H\u0016\u00f8\u0001\u0000\u00f8\u0001\u0001\u00f8\u0001\u0002\u00a2\u0006\u0002\b\u0015R\u0014\u0010\u0004\u001a\u00020\u0005X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0004\u0010\u0006R\u0014\u0010\u0007\u001a\u00020\bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u0082\u0002\u000f\n\u0002\b!\n\u0005\b\u00a1\u001e0\u0001\n\u0002\b\u0019\u00a8\u0006\u0016"}, d2={"Lpro/felixo/protobuf/serialization/encoding/FieldEncoding$Float;", "Lpro/felixo/protobuf/serialization/encoding/FieldEncoding$Scalar;", "", "()V", "isPackable", "", "()Z", "wireType", "Lpro/felixo/protobuf/wire/WireType;", "getWireType", "()Lpro/felixo/protobuf/wire/WireType;", "decode", "", "wire", "Lpro/felixo/protobuf/wire/WireValue;", "onValue", "Lkotlin/Function1;", "encode", "Lpro/felixo/protobuf/wire/WireValue$Fixed32;", "value", "encodeZeroValue", "encode-XRUkYVI", "protobuf-kotlin-serialization"})
    public static final class Float
    extends Scalar<java.lang.Float> {
        @NotNull
        public static final Float INSTANCE = new Float();
        @NotNull
        private static final WireType wireType = WireType.Fixed32;
        private static final boolean isPackable = true;

        private Float() {
            super("float", null);
        }

        @Override
        @NotNull
        public WireType getWireType() {
            return wireType;
        }

        @Override
        public boolean isPackable() {
            return isPackable;
        }

        @Override
        public void decode(@NotNull WireValue wire, @NotNull Function1<? super java.lang.Float, Unit> onValue) {
            Intrinsics.checkNotNullParameter((Object)wire, (java.lang.String)"wire");
            Intrinsics.checkNotNullParameter(onValue, (java.lang.String)"onValue");
            WireValue wireValue = wire;
            if (wireValue instanceof WireValue.Fixed32) {
                onValue.invoke((Object)java.lang.Float.valueOf(java.lang.Float.intBitsToFloat(((WireValue.Fixed32)wire).unbox-impl())));
            } else if (wireValue instanceof WireValue.Len) {
                while (((WireValue.Len)wire).unbox-impl().getRemaining() > 0) {
                    onValue.invoke((Object)java.lang.Float.valueOf(java.lang.Float.intBitsToFloat(((WireValue.Len)wire).unbox-impl().readFixed32())));
                }
            } else {
                if (wireValue instanceof WireValue.Fixed64) {
                    throw new IllegalStateException("Cannot decode float from fixed64".toString());
                }
                if (wireValue instanceof WireValue.VarInt) {
                    throw new IllegalStateException("Cannot decode double from varint".toString());
                }
                throw new NoWhenBranchMatchedException();
            }
        }

        @Nullable
        public WireValue.Fixed32 encode-XRUkYVI(float value, boolean encodeZeroValue) {
            return EncodeUtilKt.fixed32(java.lang.Float.floatToIntBits(value), encodeZeroValue);
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J$\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0012\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\b0\fH\u0016J\u001a\u0010\u000e\u001a\u0004\u0018\u00010\n2\u0006\u0010\u000f\u001a\u00020\r2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\"\u0010\u000e\u001a\u0004\u0018\u00010\n2\u0006\u0010\u000f\u001a\u00020\r2\u0006\u0010\u0012\u001a\u00020\r2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016R\u0014\u0010\u0003\u001a\u00020\u0004X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0013"}, d2={"Lpro/felixo/protobuf/serialization/encoding/FieldEncoding$Int32;", "Lpro/felixo/protobuf/serialization/encoding/FieldEncoding$Integer32;", "()V", "wireType", "Lpro/felixo/protobuf/wire/WireType;", "getWireType", "()Lpro/felixo/protobuf/wire/WireType;", "decode", "", "wire", "Lpro/felixo/protobuf/wire/WireValue;", "onValue", "Lkotlin/Function1;", "", "encode", "value", "encodeZeroValue", "", "mask", "protobuf-kotlin-serialization"})
    public static final class Int32
    extends Integer32 {
        @NotNull
        public static final Int32 INSTANCE = new Int32();
        @NotNull
        private static final WireType wireType = WireType.VarInt;

        private Int32() {
            super("int32", null);
        }

        @Override
        @NotNull
        public WireType getWireType() {
            return wireType;
        }

        @Override
        public void decode(@NotNull WireValue wire, @NotNull Function1<? super Integer, Unit> onValue) {
            Intrinsics.checkNotNullParameter((Object)wire, (java.lang.String)"wire");
            Intrinsics.checkNotNullParameter(onValue, (java.lang.String)"onValue");
            WireValue wireValue = wire;
            if (wireValue instanceof WireValue.VarInt) {
                onValue.invoke((Object)((int)((WireValue.VarInt)wire).unbox-impl()));
            } else if (wireValue instanceof WireValue.Len) {
                while (((WireValue.Len)wire).unbox-impl().getRemaining() > 0) {
                    onValue.invoke((Object)((WireValue.Len)wire).unbox-impl().readVarIntAsInt());
                }
            } else {
                if (wireValue instanceof WireValue.Fixed32) {
                    throw new IllegalStateException("Cannot decode int32 from fixed32".toString());
                }
                if (wireValue instanceof WireValue.Fixed64) {
                    throw new IllegalStateException("Cannot decode int32 from fixed64".toString());
                }
                throw new NoWhenBranchMatchedException();
            }
        }

        @Override
        @Nullable
        public WireValue encode(int value, int mask, boolean encodeZeroValue) {
            return (WireValue)EncodeUtilKt.varInt((long)value & ((long)UInt.constructor-impl((int)mask) & 0xFFFFFFFFL), encodeZeroValue);
        }

        @Override
        @Nullable
        public WireValue encode(int value, boolean encodeZeroValue) {
            return (WireValue)EncodeUtilKt.varInt((long)value, encodeZeroValue);
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J$\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0012\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\b0\fH\u0016J\u001a\u0010\u000e\u001a\u0004\u0018\u00010\n2\u0006\u0010\u000f\u001a\u00020\r2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016R\u0014\u0010\u0003\u001a\u00020\u0004X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0012"}, d2={"Lpro/felixo/protobuf/serialization/encoding/FieldEncoding$Int64;", "Lpro/felixo/protobuf/serialization/encoding/FieldEncoding$Integer64;", "()V", "wireType", "Lpro/felixo/protobuf/wire/WireType;", "getWireType", "()Lpro/felixo/protobuf/wire/WireType;", "decode", "", "wire", "Lpro/felixo/protobuf/wire/WireValue;", "onValue", "Lkotlin/Function1;", "", "encode", "value", "encodeZeroValue", "", "protobuf-kotlin-serialization"})
    public static final class Int64
    extends Integer64 {
        @NotNull
        public static final Int64 INSTANCE = new Int64();
        @NotNull
        private static final WireType wireType = WireType.VarInt;

        private Int64() {
            super("int64", null);
        }

        @Override
        @NotNull
        public WireType getWireType() {
            return wireType;
        }

        @Override
        public void decode(@NotNull WireValue wire, @NotNull Function1<? super Long, Unit> onValue) {
            Intrinsics.checkNotNullParameter((Object)wire, (java.lang.String)"wire");
            Intrinsics.checkNotNullParameter(onValue, (java.lang.String)"onValue");
            WireValue wireValue = wire;
            if (wireValue instanceof WireValue.VarInt) {
                onValue.invoke((Object)((WireValue.VarInt)wire).unbox-impl());
            } else if (wireValue instanceof WireValue.Len) {
                while (((WireValue.Len)wire).unbox-impl().getRemaining() > 0) {
                    onValue.invoke((Object)((WireValue.Len)wire).unbox-impl().readVarIntAsLong());
                }
            } else {
                if (wireValue instanceof WireValue.Fixed32) {
                    throw new IllegalStateException("Cannot decode int64 from fixed32".toString());
                }
                if (wireValue instanceof WireValue.Fixed64) {
                    throw new IllegalStateException("Cannot decode int64 from fixed64".toString());
                }
                throw new NoWhenBranchMatchedException();
            }
        }

        @Override
        @Nullable
        public WireValue encode(long value, boolean encodeZeroValue) {
            return (WireValue)EncodeUtilKt.varInt(value, encodeZeroValue);
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b6\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u000f\b\u0004\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\"\u0010\t\u001a\u0004\u0018\u00010\n2\u0006\u0010\u000b\u001a\u00020\u00022\u0006\u0010\f\u001a\u00020\u00022\u0006\u0010\r\u001a\u00020\u0007H&R\u0014\u0010\u0006\u001a\u00020\u0007X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\b\u0082\u0001\u0005\u000e\u000f\u0010\u0011\u0012\u00a8\u0006\u0013"}, d2={"Lpro/felixo/protobuf/serialization/encoding/FieldEncoding$Integer32;", "Lpro/felixo/protobuf/serialization/encoding/FieldEncoding$Scalar;", "", "name", "", "(Ljava/lang/String;)V", "isPackable", "", "()Z", "encode", "Lpro/felixo/protobuf/wire/WireValue;", "value", "mask", "encodeZeroValue", "Lpro/felixo/protobuf/serialization/encoding/FieldEncoding$Fixed32;", "Lpro/felixo/protobuf/serialization/encoding/FieldEncoding$Int32;", "Lpro/felixo/protobuf/serialization/encoding/FieldEncoding$SFixed32;", "Lpro/felixo/protobuf/serialization/encoding/FieldEncoding$SInt32;", "Lpro/felixo/protobuf/serialization/encoding/FieldEncoding$UInt32;", "protobuf-kotlin-serialization"})
    public static abstract class Integer32
    extends Scalar<Integer> {
        private final boolean isPackable;

        private Integer32(java.lang.String name2) {
            super(name2, null);
            this.isPackable = true;
        }

        @Nullable
        public abstract WireValue encode(int var1, int var2, boolean var3);

        @Override
        public boolean isPackable() {
            return this.isPackable;
        }

        public /* synthetic */ Integer32(java.lang.String name2, DefaultConstructorMarker $constructor_marker) {
            this(name2);
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b6\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u000f\b\u0004\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005R\u0014\u0010\u0006\u001a\u00020\u0007X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\b\u0082\u0001\u0005\t\n\u000b\f\r\u00a8\u0006\u000e"}, d2={"Lpro/felixo/protobuf/serialization/encoding/FieldEncoding$Integer64;", "Lpro/felixo/protobuf/serialization/encoding/FieldEncoding$Scalar;", "", "name", "", "(Ljava/lang/String;)V", "isPackable", "", "()Z", "Lpro/felixo/protobuf/serialization/encoding/FieldEncoding$Fixed64;", "Lpro/felixo/protobuf/serialization/encoding/FieldEncoding$Int64;", "Lpro/felixo/protobuf/serialization/encoding/FieldEncoding$SFixed64;", "Lpro/felixo/protobuf/serialization/encoding/FieldEncoding$SInt64;", "Lpro/felixo/protobuf/serialization/encoding/FieldEncoding$UInt64;", "protobuf-kotlin-serialization"})
    public static abstract class Integer64
    extends Scalar<Long> {
        private final boolean isPackable;

        private Integer64(java.lang.String name2) {
            super(name2, null);
            this.isPackable = true;
        }

        @Override
        public boolean isPackable() {
            return this.isPackable;
        }

        public /* synthetic */ Integer64(java.lang.String name2, DefaultConstructorMarker $constructor_marker) {
            this(name2);
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\u0018\u0000 \u001c2\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\u001cB\u0005\u00a2\u0006\u0002\u0010\u0003J\u001e\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u0011H\u0016J5\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0015\u001a\u0004\u0018\u00010\u00162\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001aH\u0016\u00f8\u0001\u0000\u00f8\u0001\u0001\u00a2\u0006\u0002\b\u001bR\u001e\u0010\u0005\u001a\u00020\u00022\u0006\u0010\u0004\u001a\u00020\u0002@RX\u0096.\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0014\u0010\b\u001a\u00020\tX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u0082\u0002\u000b\n\u0005\b\u00a1\u001e0\u0001\n\u0002\b\u0019\u00a8\u0006\u001d"}, d2={"Lpro/felixo/protobuf/serialization/encoding/FieldEncoding$MessageReference;", "Lpro/felixo/protobuf/serialization/encoding/FieldEncoding$Reference;", "Lpro/felixo/protobuf/serialization/Message;", "()V", "<set-?>", "type", "getType", "()Lpro/felixo/protobuf/serialization/Message;", "wireType", "Lpro/felixo/protobuf/wire/WireType;", "getWireType", "()Lpro/felixo/protobuf/wire/WireType;", "decoder", "Lkotlinx/serialization/encoding/Decoder;", "serializersModule", "Lkotlinx/serialization/modules/SerializersModule;", "input", "", "Lpro/felixo/protobuf/wire/WireValue;", "encoder", "Lkotlinx/serialization/encoding/Encoder;", "fieldNumber", "Lpro/felixo/protobuf/FieldNumber;", "output", "Lpro/felixo/protobuf/wire/WireBuffer;", "encodeZeroValue", "", "encoder-TFX4cgo", "Companion", "protobuf-kotlin-serialization"})
    public static final class MessageReference
    extends Reference<Message> {
        @NotNull
        public static final Companion Companion = new Companion(null);
        @NotNull
        private final WireType wireType = WireType.Len;
        private Message type;

        public MessageReference() {
            super(null);
        }

        @Override
        @NotNull
        public WireType getWireType() {
            return this.wireType;
        }

        @Override
        @NotNull
        public Message getType() {
            Message message = this.type;
            if (message != null) {
                return message;
            }
            Intrinsics.throwUninitializedPropertyAccessException((java.lang.String)"type");
            return null;
        }

        @Override
        @NotNull
        public Encoder encoder-TFX4cgo(@NotNull SerializersModule serializersModule, @Nullable FieldNumber fieldNumber, @NotNull WireBuffer output, boolean encodeZeroValue) {
            Intrinsics.checkNotNullParameter((Object)serializersModule, (java.lang.String)"serializersModule");
            Intrinsics.checkNotNullParameter((Object)output, (java.lang.String)"output");
            return (Encoder)this.getType().getEncoder().invoke((Object)output, (Object)fieldNumber, (Object)encodeZeroValue);
        }

        @Override
        @NotNull
        public Decoder decoder(@NotNull SerializersModule serializersModule, @NotNull List<? extends WireValue> input) {
            Intrinsics.checkNotNullParameter((Object)serializersModule, (java.lang.String)"serializersModule");
            Intrinsics.checkNotNullParameter(input, (java.lang.String)"input");
            return (Decoder)this.getType().getDecoder().invoke(input);
        }

        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001e\u0010\u0003\u001a\u001a\u0012\u0004\u0012\u00020\u0005\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u00060\u0004J\u000e\u0010\t\u001a\u00020\u00052\u0006\u0010\n\u001a\u00020\u0007\u00a8\u0006\u000b"}, d2={"Lpro/felixo/protobuf/serialization/encoding/FieldEncoding$MessageReference$Companion;", "", "()V", "lazy", "Lkotlin/Pair;", "Lpro/felixo/protobuf/serialization/encoding/FieldEncoding$MessageReference;", "Lkotlin/Function1;", "Lpro/felixo/protobuf/serialization/Message;", "", "to", "type", "protobuf-kotlin-serialization"})
        public static final class Companion {
            private Companion() {
            }

            @NotNull
            public final MessageReference to(@NotNull Message type) {
                Intrinsics.checkNotNullParameter((Object)type, (java.lang.String)"type");
                MessageReference ref = new MessageReference();
                ref.type = type;
                return ref;
            }

            @NotNull
            public final Pair<MessageReference, Function1<Message, Unit>> lazy() {
                MessageReference ref = new MessageReference();
                return TuplesKt.to((Object)ref, (Object)new Function1<Message, Unit>(ref){
                    final /* synthetic */ MessageReference $ref;
                    {
                        this.$ref = $ref;
                        super(1);
                    }

                    public final void invoke(@NotNull Message it) {
                        Intrinsics.checkNotNullParameter((Object)it, (java.lang.String)"it");
                        MessageReference.access$setType$p(this.$ref, it);
                    }
                });
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b6\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u00022\u00020\u0003B\u0007\b\u0004\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0011\u001a\u00020\u0012H\u0016R\u0014\u0010\u0005\u001a\u00020\u0006X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0007R$\u0010\b\u001a\u00020\t8FX\u0086\u0084\u0002\u00f8\u0001\u0000\u00f8\u0001\u0001\u00f8\u0001\u0002\u00a2\u0006\f\n\u0004\b\f\u0010\r\u001a\u0004\b\n\u0010\u000bR\u0012\u0010\u000e\u001a\u00028\u0000X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010\u0082\u0001\u0002\u0013\u0014\u0082\u0002\u000f\n\u0002\b\u0019\n\u0005\b\u00a1\u001e0\u0001\n\u0002\b!\u00a8\u0006\u0015"}, d2={"Lpro/felixo/protobuf/serialization/encoding/FieldEncoding$Reference;", "T", "Lpro/felixo/protobuf/serialization/Type;", "Lpro/felixo/protobuf/serialization/encoding/FieldEncoding;", "()V", "isPackable", "", "()Z", "name", "Lpro/felixo/protobuf/Identifier;", "getName-BAfpDiQ", "()Ljava/lang/String;", "name$delegate", "Lkotlin/Lazy;", "type", "getType", "()Lpro/felixo/protobuf/serialization/Type;", "toString", "", "Lpro/felixo/protobuf/serialization/encoding/FieldEncoding$EnumReference;", "Lpro/felixo/protobuf/serialization/encoding/FieldEncoding$MessageReference;", "protobuf-kotlin-serialization"})
    public static abstract class Reference<T extends Type>
    extends FieldEncoding {
        private final boolean isPackable;
        @NotNull
        private final Lazy name$delegate = LazyKt.lazy((Function0)((Function0)new Function0<Identifier>(this){
            final /* synthetic */ Reference<T> this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final java.lang.String invoke-BAfpDiQ() {
                return ((Type)this.this$0.getType()).getName-BAfpDiQ();
            }
        }));

        private Reference() {
            super(null);
        }

        @Override
        public boolean isPackable() {
            return this.isPackable;
        }

        @NotNull
        public abstract T getType();

        @NotNull
        public final java.lang.String getName-BAfpDiQ() {
            Lazy lazy2 = this.name$delegate;
            return ((Identifier)lazy2.getValue()).unbox-impl();
        }

        @NotNull
        public java.lang.String toString() {
            return Identifier.toString-impl((java.lang.String)((Type)this.getType()).getName-BAfpDiQ());
        }

        public /* synthetic */ Reference(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J$\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0012\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\b0\fH\u0016J\u001a\u0010\u000e\u001a\u0004\u0018\u00010\n2\u0006\u0010\u000f\u001a\u00020\r2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\"\u0010\u000e\u001a\u0004\u0018\u00010\n2\u0006\u0010\u000f\u001a\u00020\r2\u0006\u0010\u0012\u001a\u00020\r2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016R\u0014\u0010\u0003\u001a\u00020\u0004X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0013"}, d2={"Lpro/felixo/protobuf/serialization/encoding/FieldEncoding$SFixed32;", "Lpro/felixo/protobuf/serialization/encoding/FieldEncoding$Integer32;", "()V", "wireType", "Lpro/felixo/protobuf/wire/WireType;", "getWireType", "()Lpro/felixo/protobuf/wire/WireType;", "decode", "", "wire", "Lpro/felixo/protobuf/wire/WireValue;", "onValue", "Lkotlin/Function1;", "", "encode", "value", "encodeZeroValue", "", "mask", "protobuf-kotlin-serialization"})
    public static final class SFixed32
    extends Integer32 {
        @NotNull
        public static final SFixed32 INSTANCE = new SFixed32();
        @NotNull
        private static final WireType wireType = WireType.Fixed32;

        private SFixed32() {
            super("sfixed32", null);
        }

        @Override
        @NotNull
        public WireType getWireType() {
            return wireType;
        }

        @Override
        public void decode(@NotNull WireValue wire, @NotNull Function1<? super Integer, Unit> onValue) {
            Intrinsics.checkNotNullParameter((Object)wire, (java.lang.String)"wire");
            Intrinsics.checkNotNullParameter(onValue, (java.lang.String)"onValue");
            WireValue wireValue = wire;
            if (wireValue instanceof WireValue.Fixed32) {
                onValue.invoke((Object)((WireValue.Fixed32)wire).unbox-impl());
            } else if (wireValue instanceof WireValue.Len) {
                while (((WireValue.Len)wire).unbox-impl().getRemaining() > 0) {
                    onValue.invoke((Object)((WireValue.Len)wire).unbox-impl().readFixed32());
                }
            } else {
                if (wireValue instanceof WireValue.Fixed64) {
                    throw new IllegalStateException("Cannot decode fixed32 from fixed64".toString());
                }
                if (wireValue instanceof WireValue.VarInt) {
                    throw new IllegalStateException("Cannot decode fixed32 from varint".toString());
                }
                throw new NoWhenBranchMatchedException();
            }
        }

        @Override
        @Nullable
        public WireValue encode(int value, int mask, boolean encodeZeroValue) {
            return (WireValue)EncodeUtilKt.fixed32(value & mask, encodeZeroValue);
        }

        @Override
        @Nullable
        public WireValue encode(int value, boolean encodeZeroValue) {
            return (WireValue)EncodeUtilKt.fixed32(value, encodeZeroValue);
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J$\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0012\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\b0\fH\u0016J\u001a\u0010\u000e\u001a\u0004\u0018\u00010\n2\u0006\u0010\u000f\u001a\u00020\r2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016R\u0014\u0010\u0003\u001a\u00020\u0004X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0012"}, d2={"Lpro/felixo/protobuf/serialization/encoding/FieldEncoding$SFixed64;", "Lpro/felixo/protobuf/serialization/encoding/FieldEncoding$Integer64;", "()V", "wireType", "Lpro/felixo/protobuf/wire/WireType;", "getWireType", "()Lpro/felixo/protobuf/wire/WireType;", "decode", "", "wire", "Lpro/felixo/protobuf/wire/WireValue;", "onValue", "Lkotlin/Function1;", "", "encode", "value", "encodeZeroValue", "", "protobuf-kotlin-serialization"})
    public static final class SFixed64
    extends Integer64 {
        @NotNull
        public static final SFixed64 INSTANCE = new SFixed64();
        @NotNull
        private static final WireType wireType = WireType.Fixed64;

        private SFixed64() {
            super("sfixed64", null);
        }

        @Override
        @NotNull
        public WireType getWireType() {
            return wireType;
        }

        @Override
        public void decode(@NotNull WireValue wire, @NotNull Function1<? super Long, Unit> onValue) {
            Intrinsics.checkNotNullParameter((Object)wire, (java.lang.String)"wire");
            Intrinsics.checkNotNullParameter(onValue, (java.lang.String)"onValue");
            WireValue wireValue = wire;
            if (wireValue instanceof WireValue.Fixed64) {
                onValue.invoke((Object)((WireValue.Fixed64)wire).unbox-impl());
            } else if (wireValue instanceof WireValue.Len) {
                while (((WireValue.Len)wire).unbox-impl().getRemaining() > 0) {
                    onValue.invoke((Object)((WireValue.Len)wire).unbox-impl().readFixed64());
                }
            } else {
                if (wireValue instanceof WireValue.Fixed32) {
                    throw new IllegalStateException("Cannot decode fixed64 from fixed32".toString());
                }
                if (wireValue instanceof WireValue.VarInt) {
                    throw new IllegalStateException("Cannot decode fixed32 from varint".toString());
                }
                throw new NoWhenBranchMatchedException();
            }
        }

        @Override
        @Nullable
        public WireValue encode(long value, boolean encodeZeroValue) {
            return (WireValue)EncodeUtilKt.fixed64(value, encodeZeroValue);
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J$\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0012\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\b0\fH\u0016J\u001a\u0010\u000e\u001a\u0004\u0018\u00010\n2\u0006\u0010\u000f\u001a\u00020\r2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\"\u0010\u000e\u001a\u0004\u0018\u00010\n2\u0006\u0010\u000f\u001a\u00020\r2\u0006\u0010\u0012\u001a\u00020\r2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016R\u0014\u0010\u0003\u001a\u00020\u0004X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0013"}, d2={"Lpro/felixo/protobuf/serialization/encoding/FieldEncoding$SInt32;", "Lpro/felixo/protobuf/serialization/encoding/FieldEncoding$Integer32;", "()V", "wireType", "Lpro/felixo/protobuf/wire/WireType;", "getWireType", "()Lpro/felixo/protobuf/wire/WireType;", "decode", "", "wire", "Lpro/felixo/protobuf/wire/WireValue;", "onValue", "Lkotlin/Function1;", "", "encode", "value", "encodeZeroValue", "", "mask", "protobuf-kotlin-serialization"})
    public static final class SInt32
    extends Integer32 {
        @NotNull
        public static final SInt32 INSTANCE = new SInt32();
        @NotNull
        private static final WireType wireType = WireType.VarInt;

        private SInt32() {
            super("sint32", null);
        }

        @Override
        @NotNull
        public WireType getWireType() {
            return wireType;
        }

        @Override
        public void decode(@NotNull WireValue wire, @NotNull Function1<? super Integer, Unit> onValue) {
            Intrinsics.checkNotNullParameter((Object)wire, (java.lang.String)"wire");
            Intrinsics.checkNotNullParameter(onValue, (java.lang.String)"onValue");
            WireValue wireValue = wire;
            if (wireValue instanceof WireValue.VarInt) {
                onValue.invoke((Object)UtilKt.decodeSInt32((int)((int)((WireValue.VarInt)wire).unbox-impl())));
            } else if (wireValue instanceof WireValue.Len) {
                while (((WireValue.Len)wire).unbox-impl().getRemaining() > 0) {
                    onValue.invoke((Object)UtilKt.decodeSInt32((int)((WireValue.Len)wire).unbox-impl().readVarIntAsInt()));
                }
            } else {
                if (wireValue instanceof WireValue.Fixed32) {
                    throw new IllegalStateException("Cannot decode sint32 from fixed32".toString());
                }
                if (wireValue instanceof WireValue.Fixed64) {
                    throw new IllegalStateException("Cannot decode sint32 from fixed64".toString());
                }
                throw new NoWhenBranchMatchedException();
            }
        }

        @Override
        @Nullable
        public WireValue encode(int value, int mask, boolean encodeZeroValue) {
            return (WireValue)EncodeUtilKt.varInt((long)UtilKt.encodeSInt32((int)value) & ((long)UInt.constructor-impl((int)mask) & 0xFFFFFFFFL), encodeZeroValue);
        }

        @Override
        @Nullable
        public WireValue encode(int value, boolean encodeZeroValue) {
            return (WireValue)EncodeUtilKt.varInt((long)UtilKt.encodeSInt32((int)value) & 0xFFFFFFFFL, encodeZeroValue);
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J$\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0012\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\b0\fH\u0016J\u001a\u0010\u000e\u001a\u0004\u0018\u00010\n2\u0006\u0010\u000f\u001a\u00020\r2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016R\u0014\u0010\u0003\u001a\u00020\u0004X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0012"}, d2={"Lpro/felixo/protobuf/serialization/encoding/FieldEncoding$SInt64;", "Lpro/felixo/protobuf/serialization/encoding/FieldEncoding$Integer64;", "()V", "wireType", "Lpro/felixo/protobuf/wire/WireType;", "getWireType", "()Lpro/felixo/protobuf/wire/WireType;", "decode", "", "wire", "Lpro/felixo/protobuf/wire/WireValue;", "onValue", "Lkotlin/Function1;", "", "encode", "value", "encodeZeroValue", "", "protobuf-kotlin-serialization"})
    public static final class SInt64
    extends Integer64 {
        @NotNull
        public static final SInt64 INSTANCE = new SInt64();
        @NotNull
        private static final WireType wireType = WireType.VarInt;

        private SInt64() {
            super("sint64", null);
        }

        @Override
        @NotNull
        public WireType getWireType() {
            return wireType;
        }

        @Override
        public void decode(@NotNull WireValue wire, @NotNull Function1<? super Long, Unit> onValue) {
            Intrinsics.checkNotNullParameter((Object)wire, (java.lang.String)"wire");
            Intrinsics.checkNotNullParameter(onValue, (java.lang.String)"onValue");
            WireValue wireValue = wire;
            if (wireValue instanceof WireValue.VarInt) {
                onValue.invoke((Object)UtilKt.decodeSInt64((long)((WireValue.VarInt)wire).unbox-impl()));
            } else if (wireValue instanceof WireValue.Len) {
                while (((WireValue.Len)wire).unbox-impl().getRemaining() > 0) {
                    onValue.invoke((Object)UtilKt.decodeSInt64((long)((WireValue.Len)wire).unbox-impl().readVarIntAsLong()));
                }
            } else {
                if (wireValue instanceof WireValue.Fixed32) {
                    throw new IllegalStateException("Cannot decode sint64 from fixed32".toString());
                }
                if (wireValue instanceof WireValue.Fixed64) {
                    throw new IllegalStateException("Cannot decode sint64 from fixed64".toString());
                }
                throw new NoWhenBranchMatchedException();
            }
        }

        @Override
        @Nullable
        public WireValue encode(long value, boolean encodeZeroValue) {
            return (WireValue)EncodeUtilKt.varInt(UtilKt.encodeSInt64((long)value), encodeZeroValue);
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b6\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u00022\u00020\u0003B\u000f\b\u0004\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J$\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0012\u0010\r\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00020\n0\u000eH&J\u001f\u0010\u000f\u001a\u0004\u0018\u00010\f2\u0006\u0010\u0010\u001a\u00028\u00002\u0006\u0010\u0011\u001a\u00020\u0012H&\u00a2\u0006\u0002\u0010\u0013J\b\u0010\u0014\u001a\u00020\u0005H\u0016R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u0082\u0001\u0007\u0015\u0016\u0017\u0018\u0019\u001a\u001b\u00a8\u0006\u001c"}, d2={"Lpro/felixo/protobuf/serialization/encoding/FieldEncoding$Scalar;", "DecodedType", "", "Lpro/felixo/protobuf/serialization/encoding/FieldEncoding;", "name", "", "(Ljava/lang/String;)V", "getName", "()Ljava/lang/String;", "decode", "", "wire", "Lpro/felixo/protobuf/wire/WireValue;", "onValue", "Lkotlin/Function1;", "encode", "value", "encodeZeroValue", "", "(Ljava/lang/Object;Z)Lpro/felixo/protobuf/wire/WireValue;", "toString", "Lpro/felixo/protobuf/serialization/encoding/FieldEncoding$Bool;", "Lpro/felixo/protobuf/serialization/encoding/FieldEncoding$Bytes;", "Lpro/felixo/protobuf/serialization/encoding/FieldEncoding$Double;", "Lpro/felixo/protobuf/serialization/encoding/FieldEncoding$Float;", "Lpro/felixo/protobuf/serialization/encoding/FieldEncoding$Integer32;", "Lpro/felixo/protobuf/serialization/encoding/FieldEncoding$Integer64;", "Lpro/felixo/protobuf/serialization/encoding/FieldEncoding$String;", "protobuf-kotlin-serialization"})
    public static abstract class Scalar<DecodedType>
    extends FieldEncoding {
        @NotNull
        private final java.lang.String name;

        private Scalar(java.lang.String name2) {
            super(null);
            this.name = name2;
        }

        @NotNull
        public final java.lang.String getName() {
            return this.name;
        }

        @Nullable
        public abstract WireValue encode(@NotNull DecodedType var1, boolean var2);

        public abstract void decode(@NotNull WireValue var1, @NotNull Function1<? super DecodedType, Unit> var2);

        @NotNull
        public java.lang.String toString() {
            return this.name;
        }

        public /* synthetic */ Scalar(java.lang.String name2, DefaultConstructorMarker $constructor_marker) {
            this(name2);
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0003J$\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0012\u0010\u000f\u001a\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\f0\u0010H\u0016J\u001a\u0010\u0011\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u0012\u001a\u00020\u00022\u0006\u0010\u0013\u001a\u00020\u0005H\u0016R\u0014\u0010\u0004\u001a\u00020\u0005X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0004\u0010\u0006R\u0014\u0010\u0007\u001a\u00020\bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0014"}, d2={"Lpro/felixo/protobuf/serialization/encoding/FieldEncoding$String;", "Lpro/felixo/protobuf/serialization/encoding/FieldEncoding$Scalar;", "", "()V", "isPackable", "", "()Z", "wireType", "Lpro/felixo/protobuf/wire/WireType;", "getWireType", "()Lpro/felixo/protobuf/wire/WireType;", "decode", "", "wire", "Lpro/felixo/protobuf/wire/WireValue;", "onValue", "Lkotlin/Function1;", "encode", "value", "encodeZeroValue", "protobuf-kotlin-serialization"})
    public static final class String
    extends Scalar<java.lang.String> {
        @NotNull
        public static final String INSTANCE = new String();
        @NotNull
        private static final WireType wireType = WireType.Len;
        private static final boolean isPackable;

        private String() {
            super("string", null);
        }

        @Override
        @NotNull
        public WireType getWireType() {
            return wireType;
        }

        @Override
        public boolean isPackable() {
            return isPackable;
        }

        @Override
        public void decode(@NotNull WireValue wire, @NotNull Function1<? super java.lang.String, Unit> onValue) {
            Intrinsics.checkNotNullParameter((Object)wire, (java.lang.String)"wire");
            Intrinsics.checkNotNullParameter(onValue, (java.lang.String)"onValue");
            WireValue wireValue = wire;
            if (!(wireValue instanceof WireValue.Len)) {
                if (wireValue instanceof WireValue.VarInt) {
                    throw new IllegalStateException("Cannot decode string from varint".toString());
                }
                if (wireValue instanceof WireValue.Fixed32) {
                    throw new IllegalStateException("Cannot decode string from fixed32".toString());
                }
                if (wireValue instanceof WireValue.Fixed64) {
                    throw new IllegalStateException("Cannot decode string from fixed64".toString());
                }
                throw new NoWhenBranchMatchedException();
            }
            onValue.invoke((Object)StringsKt.decodeToString((byte[])((WireValue.Len)wire).unbox-impl().readBytes()));
        }

        @Override
        @Nullable
        public WireValue encode(@NotNull java.lang.String value, boolean encodeZeroValue) {
            Intrinsics.checkNotNullParameter((Object)value, (java.lang.String)"value");
            WireBuffer wireBuffer = EncodeUtilKt.len(value, encodeZeroValue);
            return wireBuffer != null ? WireValue.Len.box-impl((WireBuffer)wireBuffer) : null;
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J$\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0012\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\b0\fH\u0016J\u001a\u0010\u000e\u001a\u0004\u0018\u00010\n2\u0006\u0010\u000f\u001a\u00020\r2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\"\u0010\u000e\u001a\u0004\u0018\u00010\n2\u0006\u0010\u000f\u001a\u00020\r2\u0006\u0010\u0012\u001a\u00020\r2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016R\u0014\u0010\u0003\u001a\u00020\u0004X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0013"}, d2={"Lpro/felixo/protobuf/serialization/encoding/FieldEncoding$UInt32;", "Lpro/felixo/protobuf/serialization/encoding/FieldEncoding$Integer32;", "()V", "wireType", "Lpro/felixo/protobuf/wire/WireType;", "getWireType", "()Lpro/felixo/protobuf/wire/WireType;", "decode", "", "wire", "Lpro/felixo/protobuf/wire/WireValue;", "onValue", "Lkotlin/Function1;", "", "encode", "value", "encodeZeroValue", "", "mask", "protobuf-kotlin-serialization"})
    public static final class UInt32
    extends Integer32 {
        @NotNull
        public static final UInt32 INSTANCE = new UInt32();
        @NotNull
        private static final WireType wireType = WireType.VarInt;

        private UInt32() {
            super("uint32", null);
        }

        @Override
        @NotNull
        public WireType getWireType() {
            return wireType;
        }

        @Override
        public void decode(@NotNull WireValue wire, @NotNull Function1<? super Integer, Unit> onValue) {
            Intrinsics.checkNotNullParameter((Object)wire, (java.lang.String)"wire");
            Intrinsics.checkNotNullParameter(onValue, (java.lang.String)"onValue");
            WireValue wireValue = wire;
            if (wireValue instanceof WireValue.VarInt) {
                onValue.invoke((Object)((int)((WireValue.VarInt)wire).unbox-impl()));
            } else if (wireValue instanceof WireValue.Len) {
                while (((WireValue.Len)wire).unbox-impl().getRemaining() > 0) {
                    onValue.invoke((Object)((WireValue.Len)wire).unbox-impl().readVarIntAsInt());
                }
            } else {
                if (wireValue instanceof WireValue.Fixed32) {
                    throw new IllegalStateException("Cannot decode int32 from fixed32".toString());
                }
                if (wireValue instanceof WireValue.Fixed64) {
                    throw new IllegalStateException("Cannot decode int32 from fixed64".toString());
                }
                throw new NoWhenBranchMatchedException();
            }
        }

        @Override
        @Nullable
        public WireValue encode(int value, int mask, boolean encodeZeroValue) {
            return (WireValue)EncodeUtilKt.varInt((long)UInt.constructor-impl((int)value) & 0xFFFFFFFFL & ((long)UInt.constructor-impl((int)mask) & 0xFFFFFFFFL), encodeZeroValue);
        }

        @Override
        @Nullable
        public WireValue encode(int value, boolean encodeZeroValue) {
            return (WireValue)EncodeUtilKt.varInt((long)UInt.constructor-impl((int)value) & 0xFFFFFFFFL, encodeZeroValue);
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J$\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0012\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\b0\fH\u0016J\u001a\u0010\u000e\u001a\u0004\u0018\u00010\n2\u0006\u0010\u000f\u001a\u00020\r2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016R\u0014\u0010\u0003\u001a\u00020\u0004X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0012"}, d2={"Lpro/felixo/protobuf/serialization/encoding/FieldEncoding$UInt64;", "Lpro/felixo/protobuf/serialization/encoding/FieldEncoding$Integer64;", "()V", "wireType", "Lpro/felixo/protobuf/wire/WireType;", "getWireType", "()Lpro/felixo/protobuf/wire/WireType;", "decode", "", "wire", "Lpro/felixo/protobuf/wire/WireValue;", "onValue", "Lkotlin/Function1;", "", "encode", "value", "encodeZeroValue", "", "protobuf-kotlin-serialization"})
    public static final class UInt64
    extends Integer64 {
        @NotNull
        public static final UInt64 INSTANCE = new UInt64();
        @NotNull
        private static final WireType wireType = WireType.VarInt;

        private UInt64() {
            super("uint64", null);
        }

        @Override
        @NotNull
        public WireType getWireType() {
            return wireType;
        }

        @Override
        public void decode(@NotNull WireValue wire, @NotNull Function1<? super Long, Unit> onValue) {
            Intrinsics.checkNotNullParameter((Object)wire, (java.lang.String)"wire");
            Intrinsics.checkNotNullParameter(onValue, (java.lang.String)"onValue");
            WireValue wireValue = wire;
            if (wireValue instanceof WireValue.VarInt) {
                onValue.invoke((Object)((WireValue.VarInt)wire).unbox-impl());
            } else if (wireValue instanceof WireValue.Len) {
                while (((WireValue.Len)wire).unbox-impl().getRemaining() > 0) {
                    onValue.invoke((Object)((WireValue.Len)wire).unbox-impl().readVarIntAsLong());
                }
            } else {
                if (wireValue instanceof WireValue.Fixed32) {
                    throw new IllegalStateException("Cannot decode int64 from fixed32".toString());
                }
                if (wireValue instanceof WireValue.Fixed64) {
                    throw new IllegalStateException("Cannot decode int64 from fixed64".toString());
                }
                throw new NoWhenBranchMatchedException();
            }
        }

        @Override
        @Nullable
        public WireValue encode(long value, boolean encodeZeroValue) {
            return (WireValue)EncodeUtilKt.varInt(value, encodeZeroValue);
        }
    }
}

