/*
 * Decompiled with CFR 0.152.
 */
package pro.felixo.protobuf.wire;

import kotlin.Metadata;
import kotlin.UByte;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.IntRange;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\b\n\u0002\b\r\n\u0002\u0010\t\n\u0002\b\u0005\n\u0002\u0010\u0005\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u000b\u0018\u0000 '2\u00020\u0001:\u0001'B'\u0012\n\b\u0002\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0006\u0010\u0011\u001a\u00020\u0005J\u0006\u0010\u0012\u001a\u00020\u0013J\u0006\u0010\u0014\u001a\u00020\u0005J\u0006\u0010\u0015\u001a\u00020\u0013J\u0006\u0010\u0016\u001a\u00020\u0000J\u0006\u0010\u0017\u001a\u00020\u0003J\b\u0010\u0018\u001a\u00020\u0019H\u0002J\b\u0010\u001a\u001a\u00020\u0005H\u0002J\b\u0010\u001b\u001a\u00020\u0013H\u0002J\u0010\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u0005H\u0002J\u0006\u0010\u001f\u001a\u00020\u0003J\u000e\u0010 \u001a\u00020\u001d2\u0006\u0010\u000e\u001a\u00020\u0005J\u000e\u0010!\u001a\u00020\u001d2\u0006\u0010\u000e\u001a\u00020\u0013J\u0018\u0010\"\u001a\u00020\u001d2\u0006\u0010\u000e\u001a\u00020\u00052\b\b\u0002\u0010#\u001a\u00020\u0005J\u0018\u0010\"\u001a\u00020\u001d2\u0006\u0010\u000e\u001a\u00020\u00132\b\b\u0002\u0010#\u001a\u00020\u0005J\u000e\u0010$\u001a\u00020\u001d2\u0006\u0010\u000e\u001a\u00020\u0019J\u000e\u0010%\u001a\u00020\u001d2\u0006\u0010\u000e\u001a\u00020\u0003J\u000e\u0010&\u001a\u00020\u001d2\u0006\u0010\u000e\u001a\u00020\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\n\u001a\u00020\u00058F\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\fR\u000e\u0010\r\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u000f\u001a\u00020\u00052\u0006\u0010\u000e\u001a\u00020\u0005@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\f\u00a8\u0006("}, d2={"Lpro/felixo/protobuf/wire/WireBuffer;", "", "initialBytes", "", "offset", "", "initialLength", "<init>", "([BII)V", "position", "remaining", "getRemaining", "()I", "bytes", "value", "length", "getLength", "readVarIntAsInt", "readVarIntAsLong", "", "readFixed32", "readFixed64", "readLengthDelimited", "readBytes", "readByte", "", "readByteAsInt", "readByteAsLong", "ensureCapacity", "", "numBytes", "getBytes", "writeFixed32", "writeFixed64", "writeVarInt", "extraBytes", "writeByte", "write", "writeAndConsume", "Companion", "protobuf-kotlin-wire"})
@SourceDebugExtension(value={"SMAP\nWireBuffer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 WireBuffer.kt\npro/felixo/protobuf/wire/WireBuffer\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,153:1\n1#2:154\n*E\n"})
public final class WireBuffer {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final int offset;
    private int position;
    @NotNull
    private byte[] bytes;
    private int length;
    private static final int DEFAULT_INITIAL_BUFFER_SIZE = 32;

    public WireBuffer(@Nullable byte[] initialBytes, int offset, int initialLength) {
        this.position = this.offset = offset;
        byte[] byArray = initialBytes;
        if (initialBytes == null) {
            byArray = new byte[32];
        }
        this.bytes = byArray;
        this.length = initialLength;
    }

    public /* synthetic */ WireBuffer(byte[] byArray, int n, int n2, int n3, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n3 & 1) != 0) {
            byArray = null;
        }
        if ((n3 & 2) != 0) {
            n = 0;
        }
        if ((n3 & 4) != 0) {
            int n4;
            if (byArray != null) {
                byte[] it = byArray;
                boolean bl = false;
                n4 = it.length - n;
            } else {
                n4 = 0;
            }
            n2 = n4;
        }
        this(byArray, n, n2);
    }

    public final int getRemaining() {
        return this.length - (this.position - this.offset);
    }

    public final int getLength() {
        return this.length;
    }

    public final int readVarIntAsInt() {
        int result = 0;
        int shift = 0;
        while (true) {
            byte by = this.readByte();
            result |= (by & 0x7F) << shift;
            if (by >= 0) {
                return result;
            }
            shift += 7;
        }
    }

    public final long readVarIntAsLong() {
        long result = 0L;
        int shift = 0;
        while (true) {
            byte by = this.readByte();
            result |= ((long)by & 0x7FL) << shift;
            if (by >= 0) {
                return result;
            }
            shift += 7;
        }
    }

    public final int readFixed32() {
        return this.readByteAsInt() | this.readByteAsInt() << 8 | this.readByteAsInt() << 16 | this.readByteAsInt() << 24;
    }

    public final long readFixed64() {
        return this.readByteAsLong() | this.readByteAsLong() << 8 | this.readByteAsLong() << 16 | this.readByteAsLong() << 24 | this.readByteAsLong() << 32 | this.readByteAsLong() << 40 | this.readByteAsLong() << 48 | this.readByteAsLong() << 56;
    }

    @NotNull
    public final WireBuffer readLengthDelimited() {
        int length = this.readVarIntAsInt();
        if (!(length >= 0)) {
            boolean bl = false;
            String string = "Length must be non-negative, but was " + length;
            throw new IllegalArgumentException(string.toString());
        }
        WireBuffer ret = new WireBuffer(this.bytes, this.position, length);
        this.position += length;
        return ret;
    }

    @NotNull
    public final byte[] readBytes() {
        byte[] ret = ArraysKt.sliceArray((byte[])this.bytes, (IntRange)RangesKt.until((int)this.position, (int)(this.position + this.getRemaining())));
        this.position += this.getRemaining();
        return ret;
    }

    private final byte readByte() {
        int n = this.position;
        this.position = n + 1;
        return this.bytes[n];
    }

    private final int readByteAsInt() {
        return UByte.constructor-impl((byte)this.readByte()) & 0xFF;
    }

    private final long readByteAsLong() {
        return (long)UByte.constructor-impl((byte)this.readByte()) & 0xFFL;
    }

    private final void ensureCapacity(int numBytes) {
        if (this.length + numBytes <= this.bytes.length) {
            return;
        }
        byte[] newBuffer = new byte[Integer.highestOneBit(this.length + numBytes) << 1];
        ArraysKt.copyInto$default((byte[])this.bytes, (byte[])newBuffer, (int)0, (int)0, (int)0, (int)14, null);
        this.bytes = newBuffer;
    }

    @NotNull
    public final byte[] getBytes() {
        byte[] ret = new byte[this.length];
        ArraysKt.copyInto((byte[])this.bytes, (byte[])ret, (int)0, (int)0, (int)this.length);
        return ret;
    }

    public final void writeFixed32(int value) {
        this.ensureCapacity(4);
        for (int i = 0; i < 4; ++i) {
            int n = this.length;
            this.length = n + 1;
            this.bytes[n] = (byte)(value >> i * 8);
        }
    }

    public final void writeFixed64(long value) {
        this.ensureCapacity(8);
        for (int i = 0; i < 8; ++i) {
            int n = this.length;
            this.length = n + 1;
            this.bytes[n] = (byte)(value >> i * 8);
        }
    }

    public final void writeVarInt(int value, int extraBytes) {
        int varIntLength = (31 - Integer.numberOfLeadingZeros(value)) / 7 + extraBytes;
        this.ensureCapacity(varIntLength + 1);
        int current = value;
        for (int i = 0; i < varIntLength; ++i) {
            this.bytes[this.length + i] = (byte)(current & 0x7F | 0x80);
            current >>>= 7;
        }
        this.bytes[this.length + varIntLength] = (byte)current;
        this.length += varIntLength + 1;
    }

    public static /* synthetic */ void writeVarInt$default(WireBuffer wireBuffer, int n, int n2, int n3, Object object) {
        if ((n3 & 2) != 0) {
            n2 = 0;
        }
        wireBuffer.writeVarInt(n, n2);
    }

    public final void writeVarInt(long value, int extraBytes) {
        int varIntLength = (63 - Long.numberOfLeadingZeros(value)) / 7 + extraBytes;
        this.ensureCapacity(varIntLength + 1);
        long current = value;
        for (int i = 0; i < varIntLength; ++i) {
            this.bytes[this.length + i] = (byte)(current & 0x7FL | 0x80L);
            current >>>= 7;
        }
        this.bytes[this.length + varIntLength] = (byte)current;
        this.length += varIntLength + 1;
    }

    public static /* synthetic */ void writeVarInt$default(WireBuffer wireBuffer, long l, int n, int n2, Object object) {
        if ((n2 & 2) != 0) {
            n = 0;
        }
        wireBuffer.writeVarInt(l, n);
    }

    public final void writeByte(byte value) {
        this.ensureCapacity(1);
        this.bytes[this.length] = value;
        int n = this.length;
        this.length = n + 1;
    }

    public final void write(@NotNull byte[] value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        this.ensureCapacity(value.length);
        ArraysKt.copyInto$default((byte[])value, (byte[])this.bytes, (int)this.length, (int)0, (int)0, (int)12, null);
        this.length += value.length;
    }

    public final void writeAndConsume(@NotNull WireBuffer value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        int inputSize = value.getRemaining();
        this.ensureCapacity(inputSize);
        ArraysKt.copyInto((byte[])value.bytes, (byte[])this.bytes, (int)this.length, (int)0, (int)value.getRemaining());
        value.position += value.getRemaining();
        this.length += inputSize;
    }

    public WireBuffer() {
        this(null, 0, 0, 7, null);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lpro/felixo/protobuf/wire/WireBuffer$Companion;", "", "<init>", "()V", "DEFAULT_INITIAL_BUFFER_SIZE", "", "protobuf-kotlin-wire"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

