/*
 * Decompiled with CFR 0.152.
 */
package pro.fessional.mirana.best;

import java.util.Collection;
import java.util.Map;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import pro.fessional.mirana.data.CodeEnum;
import pro.fessional.mirana.pain.BadStateException;
import pro.fessional.mirana.text.FormatUtil;

public class StateAssert {
    @Contract(value="false, _, _ -> fail")
    public static void isTrue(boolean b, @NotNull String msg, Object ... args) {
        if (!b) {
            throw new IllegalStateException(FormatUtil.format(msg, args));
        }
    }

    @Contract(value="false, _, _ -> fail")
    public static void isTrue(boolean b, @NotNull CodeEnum code, Object ... args) {
        if (!b) {
            throw new BadStateException(code, args);
        }
    }

    @Contract(value="true, _, _ -> fail")
    public static void isFalse(boolean b, @NotNull String msg, Object ... args) {
        if (b) {
            throw new IllegalStateException(FormatUtil.format(msg, args));
        }
    }

    @Contract(value="true, _, _ -> fail")
    public static void isFalse(boolean b, @NotNull CodeEnum code, Object ... args) {
        if (b) {
            throw new BadStateException(code, args);
        }
    }

    @Contract(value="!null, _, _ -> fail")
    public static void isNull(Object b, @NotNull String msg, Object ... args) {
        if (b != null) {
            throw new IllegalStateException(FormatUtil.format(msg, args));
        }
    }

    @Contract(value="!null, _, _ -> fail")
    public static void isNull(Object b, @NotNull CodeEnum code, Object ... args) {
        if (b != null) {
            throw new BadStateException(code, args);
        }
    }

    @Contract(value="null, _, _ -> fail")
    public static void notNull(Object b, @NotNull String msg, Object ... args) {
        if (b == null) {
            throw new IllegalStateException(FormatUtil.format(msg, args));
        }
    }

    @Contract(value="null, _, _ -> fail")
    public static void notNull(Object b, @NotNull CodeEnum code, Object ... args) {
        if (b == null) {
            throw new BadStateException(code, args);
        }
    }

    public static void isEmpty(CharSequence c, @NotNull String msg, Object ... args) {
        if (c != null && c.length() > 0) {
            throw new IllegalStateException(FormatUtil.format(msg, args));
        }
    }

    public static void isEmpty(CharSequence c, @NotNull CodeEnum code, Object ... args) {
        if (c != null && c.length() > 0) {
            throw new BadStateException(code, args);
        }
    }

    public static void notEmpty(CharSequence c, @NotNull String msg, Object ... args) {
        if (c == null || c.length() == 0) {
            throw new IllegalStateException(FormatUtil.format(msg, args));
        }
    }

    public static void notEmpty(CharSequence c, @NotNull CodeEnum code, Object ... args) {
        if (c == null || c.length() == 0) {
            throw new BadStateException(code, args);
        }
    }

    public static void isEmpty(Collection<?> c, @NotNull String msg, Object ... args) {
        if (c != null && !c.isEmpty()) {
            throw new IllegalStateException(FormatUtil.format(msg, args));
        }
    }

    public static void isEmpty(Collection<?> c, @NotNull CodeEnum code, Object ... args) {
        if (c != null && !c.isEmpty()) {
            throw new BadStateException(code, args);
        }
    }

    public static void notEmpty(Collection<?> c, @NotNull String msg, Object ... args) {
        if (c == null || c.isEmpty()) {
            throw new IllegalStateException(FormatUtil.format(msg, args));
        }
    }

    public static void notEmpty(Collection<?> c, @NotNull CodeEnum code, Object ... args) {
        if (c == null || c.isEmpty()) {
            throw new BadStateException(code, args);
        }
    }

    public static void isEmpty(Map<?, ?> c, @NotNull String msg, Object ... args) {
        if (c != null && !c.isEmpty()) {
            throw new IllegalStateException(FormatUtil.format(msg, args));
        }
    }

    public static void isEmpty(Map<?, ?> c, @NotNull CodeEnum code, Object ... args) {
        if (c != null && !c.isEmpty()) {
            throw new BadStateException(code, args);
        }
    }

    public static void notEmpty(Map<?, ?> c, @NotNull String msg, Object ... args) {
        if (c == null || c.isEmpty()) {
            throw new IllegalStateException(FormatUtil.format(msg, args));
        }
    }

    public static void notEmpty(Map<?, ?> c, @NotNull CodeEnum code, Object ... args) {
        if (c == null || c.isEmpty()) {
            throw new BadStateException(code, args);
        }
    }

    public static void isEmpty(Object[] c, @NotNull String msg, Object ... args) {
        if (c != null && c.length > 0) {
            throw new IllegalStateException(FormatUtil.format(msg, args));
        }
    }

    public static void isEmpty(Object[] c, @NotNull CodeEnum code, Object ... args) {
        if (c != null && c.length > 0) {
            throw new BadStateException(code, args);
        }
    }

    public static void notEmpty(Object[] c, @NotNull String msg, Object ... args) {
        if (c == null || c.length == 0) {
            throw new IllegalStateException(FormatUtil.format(msg, args));
        }
    }

    public static void notEmpty(Object[] c, @NotNull CodeEnum code, Object ... args) {
        if (c == null || c.length == 0) {
            throw new BadStateException(code, args);
        }
    }

    public static <T extends Comparable<T>> void aEqb(T a, T b, @NotNull String msg, Object ... args) {
        if (a == null && b == null) {
            return;
        }
        if (a == null || !a.equals(b)) {
            throw new IllegalStateException(FormatUtil.format(msg, args));
        }
    }

    public static <T extends Comparable<T>> void aEqb(T a, T b, @NotNull CodeEnum code, Object ... args) {
        if (a == null && b == null) {
            return;
        }
        if (a == null || !a.equals(b)) {
            throw new BadStateException(code, args);
        }
    }

    public static <T extends Comparable<T>> void aGeb(T a, T b, @NotNull String msg, Object ... args) {
        if (a == null && b == null) {
            return;
        }
        if (a == null || b == null || a.compareTo(b) < 0) {
            throw new IllegalStateException(FormatUtil.format(msg, args));
        }
    }

    public static <T extends Comparable<T>> void aGeb(T a, T b, @NotNull CodeEnum code, Object ... args) {
        if (a == null && b == null) {
            return;
        }
        if (a == null || b == null || a.compareTo(b) < 0) {
            throw new BadStateException(code, args);
        }
    }

    public static <T extends Comparable<T>> void aGtb(T a, T b, @NotNull String msg, Object ... args) {
        if (a == null || b == null || a.compareTo(b) <= 0) {
            throw new IllegalStateException(FormatUtil.format(msg, args));
        }
    }

    public static <T extends Comparable<T>> void aGtb(T a, T b, @NotNull CodeEnum code, Object ... args) {
        if (a == null || b == null || a.compareTo(b) <= 0) {
            throw new BadStateException(code, args);
        }
    }

    public static <T extends Comparable<T>> void aLeb(T a, T b, @NotNull String msg, Object ... args) {
        if (a == null && b == null) {
            return;
        }
        if (a == null || b == null || a.compareTo(b) > 0) {
            throw new IllegalStateException(FormatUtil.format(msg, args));
        }
    }

    public static <T extends Comparable<T>> void aLeb(T a, T b, @NotNull CodeEnum code, Object ... args) {
        if (a == null && b == null) {
            return;
        }
        if (a == null || b == null || a.compareTo(b) > 0) {
            throw new BadStateException(code, args);
        }
    }

    public static <T extends Comparable<T>> void aLtb(T a, T b, @NotNull String msg, Object ... args) {
        if (a == null || b == null || a.compareTo(b) >= 0) {
            throw new IllegalStateException(FormatUtil.format(msg, args));
        }
    }

    public static <T extends Comparable<T>> void aLtb(T a, T b, @NotNull CodeEnum code, Object ... args) {
        if (a == null || b == null || a.compareTo(b) >= 0) {
            throw new BadStateException(code, args);
        }
    }
}

