/*
 * Decompiled with CFR 0.152.
 */
package pro.fessional.mirana.bits;

import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.security.Key;
import javax.crypto.Cipher;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import pro.fessional.mirana.bits.Base64;
import pro.fessional.mirana.data.Null;
import pro.fessional.mirana.io.InputStreams;

public class Aes128 {
    private final SecretKeySpec keySpec;
    private final IvParameterSpec algSpec;
    private final String CYP_NAME = "AES/CBC/PKCS5Padding";

    public Aes128(@NotNull String secKey) {
        int len = 16;
        byte[] bs = secKey.getBytes(StandardCharsets.UTF_8);
        if (bs.length < len) {
            throw new IllegalArgumentException("key length must ge 16");
        }
        byte[] key = new byte[len];
        System.arraycopy(bs, 0, key, 0, len);
        for (int i = len - 1; i < bs.length; ++i) {
            int ix = (i + 1) % 16;
            key[ix] = (byte)(key[ix] + bs[i] + i);
        }
        this.keySpec = new SecretKeySpec(key, "AES");
        this.algSpec = new IvParameterSpec(key);
    }

    @NotNull
    public byte[] encode(@Nullable String plain) {
        if (plain == null) {
            return Null.Bytes;
        }
        byte[] bytes = plain.getBytes(StandardCharsets.UTF_8);
        return this.encode(bytes);
    }

    @NotNull
    public byte[] encode(@Nullable InputStream plain) {
        if (plain == null) {
            return Null.Bytes;
        }
        byte[] bytes = InputStreams.readBytes(plain);
        return this.encode(bytes);
    }

    @NotNull
    public byte[] encode(@Nullable byte[] plain) {
        if (plain == null) {
            return Null.Bytes;
        }
        try {
            Cipher ins = Cipher.getInstance("AES/CBC/PKCS5Padding");
            ins.init(1, (Key)this.keySpec, this.algSpec);
            return ins.doFinal(plain);
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
    }

    @NotNull
    public byte[] decode(@Nullable String cipher) {
        if (cipher == null) {
            return Null.Bytes;
        }
        byte[] bytes = cipher.getBytes(StandardCharsets.UTF_8);
        return this.decode(bytes);
    }

    @NotNull
    public byte[] decode(@Nullable byte[] cipher) {
        if (cipher == null) {
            return Null.Bytes;
        }
        try {
            Cipher ins = Cipher.getInstance("AES/CBC/PKCS5Padding");
            ins.init(2, (Key)this.keySpec, this.algSpec);
            return ins.doFinal(cipher);
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
    }

    @NotNull
    public byte[] decode(@Nullable InputStream cipher) {
        if (cipher == null) {
            return Null.Bytes;
        }
        byte[] bytes = InputStreams.readBytes(cipher);
        return this.decode(bytes);
    }

    @NotNull
    public String encode64(@Nullable String plain) {
        if (plain == null) {
            return "";
        }
        byte[] pb = plain.getBytes(StandardCharsets.UTF_8);
        byte[] cb = this.encode(pb);
        return Base64.encode(cb);
    }

    @NotNull
    public String decode64(@Nullable String cipher) {
        if (cipher == null) {
            return "";
        }
        byte[] cb = Base64.decode(cipher);
        byte[] pb = this.decode(cb);
        return new String(pb, StandardCharsets.UTF_8);
    }

    @NotNull
    public static Aes128 of(@NotNull String secKey) {
        return new Aes128(secKey);
    }
}

