/*
 * Decompiled with CFR 0.152.
 */
package pro.fessional.mirana.code;

import net.jcip.annotations.ThreadSafe;
import org.jetbrains.annotations.NotNull;

@ThreadSafe
public class Crc8Long {
    public static final long MAX_NUMBER = 0x7FFFFFFFFFFFFFL;
    public static final long MIN_NUMBER = 0L;
    private static final int[] CRC8_TABLE = new int[]{0, 7, 14, 9, 28, 27, 18, 21, 56, 63, 54, 49, 36, 35, 42, 45, 112, 119, 126, 121, 108, 107, 98, 101, 72, 79, 70, 65, 84, 83, 90, 93, 224, 231, 238, 233, 252, 251, 242, 245, 216, 223, 214, 209, 196, 195, 202, 205, 144, 151, 158, 153, 140, 139, 130, 133, 168, 175, 166, 161, 180, 179, 186, 189, 199, 192, 201, 206, 219, 220, 213, 210, 255, 248, 241, 246, 227, 228, 237, 234, 183, 176, 185, 190, 171, 172, 165, 162, 143, 136, 129, 134, 147, 148, 157, 154, 39, 32, 41, 46, 59, 60, 53, 50, 31, 24, 17, 22, 3, 4, 13, 10, 87, 80, 89, 94, 75, 76, 69, 66, 111, 104, 97, 102, 115, 116, 125, 122, 137, 142, 135, 128, 149, 146, 155, 156, 177, 182, 191, 184, 173, 170, 163, 164, 249, 254, 247, 240, 229, 226, 235, 236, 193, 198, 207, 200, 221, 218, 211, 212, 105, 110, 103, 96, 117, 114, 123, 124, 81, 86, 95, 88, 77, 74, 67, 68, 25, 30, 23, 16, 5, 2, 11, 12, 33, 38, 47, 40, 61, 58, 51, 52, 78, 73, 64, 71, 82, 85, 92, 91, 118, 113, 120, 127, 106, 109, 100, 99, 62, 57, 48, 55, 34, 37, 44, 43, 6, 1, 8, 15, 26, 29, 20, 19, 174, 169, 160, 167, 178, 181, 188, 187, 150, 145, 152, 159, 138, 141, 132, 131, 222, 217, 208, 215, 194, 197, 204, 203, 230, 225, 232, 239, 250, 253, 244, 243};
    private final int[] pseudoSeed = new int[]{51, 43, 37, 31, 23, 17, 11, 2};

    public Crc8Long() {
    }

    public Crc8Long(@NotNull int[] seed) {
        if (seed.length < 8) {
            throw new IllegalArgumentException("seed.length can not less than 8");
        }
        for (int i = 0; i < this.pseudoSeed.length; ++i) {
            int v = seed[i];
            if (v < 0 || v > 60) {
                throw new IllegalArgumentException("item value must between [0,60], but item[" + i + "]=" + v);
            }
            if (i <= 0 || seed[i - 1] - v >= 2) continue;
            throw new IllegalArgumentException("item value must decrease by 2+, but item[" + i + "] vs item[" + (i - 1) + "]");
        }
        System.arraycopy(seed, 0, this.pseudoSeed, 0, this.pseudoSeed.length);
    }

    public long encode(long number) {
        if (number < 0L || number > 0x7FFFFFFFFFFFFFL) {
            return Long.MIN_VALUE;
        }
        int crc = this.crc8(number);
        int idx = this.pseudoSeed.length - 1;
        long value = number;
        for (int i = idx; i >= 0; --i) {
            int pos = this.pseudoSeed[i];
            int zero = crc & 1 << idx - i;
            int rem = pos - 1;
            long head = value >>> rem << pos;
            long body = 1L << rem;
            long tail = value & body - 1L;
            value = zero != 0 ? head | body | tail : head | tail;
        }
        return value;
    }

    public long decode(long value) {
        long crc = 0L;
        long number = value;
        int len = this.pseudoSeed.length;
        for (int i = 0; i < len; ++i) {
            int rem = this.pseudoSeed[i] - 1;
            long head = number >>> rem;
            crc |= (head & 1L) << len - i - 1;
            head = head >>> 1 << rem;
            long tail = number & (1L << rem) - 1L;
            number = head | tail;
        }
        if (crc != (long)this.crc8(number)) {
            return Long.MIN_VALUE;
        }
        return number;
    }

    private int crc8(long value) {
        int crc = 0;
        int mask = 255;
        for (int i = 0; i < 8; ++i) {
            crc = CRC8_TABLE[crc ^ (int)((long)mask & value)];
            value >>>= 8;
        }
        return crc;
    }
}

