/*
 * Decompiled with CFR 0.152.
 */
package pro.fessional.mirana.code;

import java.util.Collection;
import java.util.Map;
import net.jcip.annotations.ThreadSafe;
import org.jetbrains.annotations.NotNull;

@ThreadSafe
public class Excel26Az {
    private Excel26Az() {
    }

    public static int number(@NotNull String col) {
        int n = 0;
        int i = col.length() - 1;
        int j = 1;
        while (i >= 0) {
            char c = col.charAt(i);
            if (c >= 'A' && c <= 'Z') {
                n += (c - 65 + 1) * j;
            } else if (c >= 'a' && c <= 'z') {
                n += (c - 97 + 1) * j;
            }
            --i;
            j *= 26;
        }
        return n;
    }

    @NotNull
    public static String number(int num) {
        StringBuilder s = new StringBuilder(10);
        while (num > 0) {
            int m = num % 26;
            if (m == 0) {
                m = 26;
            }
            char c = (char)(m - 1 + 65);
            s.append(c);
            num = (num - m) / 26;
        }
        return s.reverse().toString();
    }

    public static int index(@NotNull String col) {
        return Excel26Az.number(col) - 1;
    }

    @NotNull
    public static String index(int idx) {
        return Excel26Az.number(idx + 1);
    }

    public static int title(Map<String, Integer> head, Collection<String> rows, String prefix) {
        int cnt = 0;
        int idx = 0;
        if (prefix == null || prefix.isEmpty()) {
            for (String row : rows) {
                Integer old = head.putIfAbsent(row, idx++);
                if (old != null) continue;
                ++cnt;
            }
        } else {
            for (String row : rows) {
                Integer old = head.putIfAbsent(prefix + row, idx++);
                if (old != null) continue;
                ++cnt;
            }
        }
        return cnt;
    }
}

