/*
 * Decompiled with CFR 0.152.
 */
package pro.fessional.mirana.code;

import java.util.Random;
import java.util.concurrent.ThreadLocalRandom;
import java.util.function.Supplier;
import net.jcip.annotations.ThreadSafe;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ThreadSafe
public class LeapCode {
    public static final long MAX_NUMBER = Long.MAX_VALUE;
    public static final long MIN_NUMBER = 0L;
    private static final int A9 = 9;
    private final char[] dict24 = new char[24];
    private final char[] dict26 = new char[26];
    private final char[] dict32 = new char[32];
    private final Supplier<Random> random;

    public LeapCode() {
        this("BY2AH0IC9SX4UTV7GP5LNR6FK1WOE8ZQD3JM");
    }

    public LeapCode(@NotNull String seed) {
        this(seed, ThreadLocalRandom::current);
    }

    public LeapCode(@NotNull String seed, Random rand) {
        this(seed, () -> rand);
    }

    public LeapCode(@NotNull String seed, Supplier<Random> rand) {
        int max = 32;
        int idx32 = 0;
        int idx26 = 0;
        int idx24 = 0;
        int len = seed.length();
        for (int i = 0; i < len && idx32 < max; ++i) {
            char c = seed.charAt(i);
            if (c >= 'a' && c <= 'z') {
                c = (char)(c - 32);
            }
            if (this.find(this.dict32, idx32, c) >= 0) continue;
            if (c >= '2' && c <= '9') {
                this.dict32[idx32++] = c;
                continue;
            }
            if (c < 'A' || c > 'Z') continue;
            this.dict26[idx26++] = c;
            if (c == 'I' || c == 'O') continue;
            this.dict32[idx32++] = c;
            this.dict24[idx24++] = c;
        }
        if (idx32 != max) {
            throw new IllegalArgumentException("seed=" + seed + " need " + max + " chars, [0-9A-Z]");
        }
        this.random = rand;
    }

    @NotNull
    public String encode26(long number) {
        return this.encode(26, number, -1);
    }

    @NotNull
    public String encode32(long number) {
        return this.encode(32, number, -1);
    }

    @NotNull
    public String encode26(long number, int len) {
        return this.encode(26, number, len);
    }

    @NotNull
    public String encode32(long number, int len) {
        return this.encode(32, number, len);
    }

    @NotNull
    public String encode(int base, long number, int len) {
        int off;
        char[] dict;
        StringBuilder sb = new StringBuilder(Math.max(len, 16));
        if (base == 26) {
            dict = this.dict26;
            off = (int)(number % 9L);
            sb.append(this.dict24[off]);
            number /= 9L;
        } else if (base == 32) {
            dict = this.dict32;
            off = (int)(number % 15L);
            sb.append(this.dict24[off + 9]);
            number /= 15L;
        } else {
            throw new IllegalArgumentException("base must one of (26,32)");
        }
        while (number > 0L) {
            int idx = (int)(number & 0xFL);
            number >>>= 4;
            sb.append(dict[off + idx]);
        }
        if (sb.length() >= len) {
            return sb.toString();
        }
        int f2 = off + 16;
        int ln = dict.length - 16;
        int[] uq = new int[ln / 2];
        int pt = 0;
        Random rand = this.random.get();
        int rnd = rand.nextInt() & Integer.MAX_VALUE;
        while (sb.length() < len) {
            int idx = -1;
            block2: while (idx < 0) {
                idx = rnd % ln;
                if ((rnd /= ln) <= 0) {
                    rnd = rand.nextInt() & Integer.MAX_VALUE;
                }
                for (int i : uq) {
                    if (idx != i) continue;
                    idx = -1;
                    continue block2;
                }
            }
            uq[pt % uq.length] = idx;
            if (idx >= off && (idx = f2 + idx) >= dict.length) {
                idx %= dict.length;
            }
            sb.append(dict[idx]);
            ++pt;
        }
        return sb.toString();
    }

    public long decode(@Nullable String value) {
        if (value == null) {
            return Long.MIN_VALUE;
        }
        int len = value.length();
        int off1 = -1;
        int off2 = -1;
        char[] dict = null;
        long number = 0L;
        int pos = 0;
        for (int i = 0; i < len; ++i) {
            char c = value.charAt(i);
            if (c >= 'a' && c <= 'z') {
                c = (char)(c - 32);
            } else if (c < '0' || c > '9' && c < 'A' || c > 'Z') continue;
            if (dict == null) {
                off1 = this.find(this.dict24, this.dict24.length, c);
                if (off1 < 9) {
                    dict = this.dict26;
                } else {
                    dict = this.dict32;
                    off1 -= 9;
                }
                off2 = off1 + 16;
                continue;
            }
            long v = this.find(dict, dict.length, c);
            if (v < (long)off1 || v >= (long)off2) continue;
            number |= v - (long)off1 << pos;
            pos += 4;
        }
        number = dict == this.dict32 ? number * 15L + (long)off1 : number * 9L + (long)off1;
        return number;
    }

    private int find(char[] dict, int max, char c) {
        for (int j = 0; j < max; ++j) {
            if (dict[j] != c) continue;
            return j;
        }
        return -1;
    }
}

