/*
 * Decompiled with CFR 0.152.
 */
package pro.fessional.mirana.code;

import java.nio.CharBuffer;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Random;
import java.util.concurrent.ThreadLocalRandom;
import net.jcip.annotations.ThreadSafe;
import pro.fessional.mirana.best.ArgsAssert;
import pro.fessional.mirana.cast.BoxedCastUtil;
import pro.fessional.mirana.data.Null;

@ThreadSafe
public class RandCode {
    public static final Seed Num = Seed.range('0', '9');
    public static final Seed Low = Seed.range('a', 'z');
    public static final Seed Upr = Seed.range('A', 'Z');
    public static final Seed Sym = Seed.chars("~!@#$%^&*()_+{}:<>?-=[];,.".toCharArray());
    private static final Seed[] Man = new Seed[]{Seed.chars("23456789".toCharArray()), Seed.chars("abdefghqrt".toCharArray()), Seed.chars("ABCDEFGHJKLMPQRSTUWXY".toCharArray())};

    public static String number(int len) {
        return RandCode.next(len, Num);
    }

    public static String lower(int len) {
        return RandCode.next(len, Low);
    }

    public static String upper(int len) {
        return RandCode.next(len, Upr);
    }

    public static String letter(int len) {
        return RandCode.next(len, Low, Upr);
    }

    public static String numlet(int len) {
        return RandCode.next(len, Num, Low, Upr);
    }

    public static String strong(int len) {
        return RandCode.next(len, Num, Low, Upr, Sym);
    }

    public static String human(int len) {
        return RandCode.next(len, Man);
    }

    public static String next(int len, Seed ... seeds) {
        return RandCode.next(len, ThreadLocalRandom.current(), seeds);
    }

    public static String next(int len, Random random, Seed ... seeds) {
        StringBuilder sb = new StringBuilder();
        int sln = seeds.length;
        if (sln == 1) {
            seeds[0].rand(random, sb, len);
        } else {
            int i;
            int[] seed = new int[len];
            for (i = 0; i < len; ++i) {
                seed[i] = i % sln;
            }
            for (i = len - 1; i > 0; --i) {
                int j = random.nextInt(i + 1);
                int a = seed[j];
                seed[j] = seed[i];
                seed[i] = a;
            }
            for (int i2 : seed) {
                seeds[i2].rand(random, sb, 1);
            }
        }
        return sb.toString();
    }

    public static class Seed {
        private final char[] range;
        private final char[] chars;

        public static Seed range(char ... minmax) {
            return new Seed(minmax, Null.Chars);
        }

        public static Seed chars(char ... chars) {
            return new Seed(Null.Chars, chars);
        }

        public static Seed seeds(Seed ... seeds) {
            int rlen = 0;
            int clen = 0;
            for (Seed seed : seeds) {
                rlen += seed.range.length;
                clen += seed.chars.length;
            }
            CharBuffer range = CharBuffer.allocate(rlen);
            CharBuffer chars = CharBuffer.allocate(clen);
            for (Seed seed : seeds) {
                range.put(seed.range);
                chars.put(seed.chars);
            }
            return new Seed(range.array(), chars.array());
        }

        public Seed(char[] range, char[] chars) {
            int rlen;
            if (range == null) {
                range = Null.Chars;
            }
            if (chars == null) {
                chars = Null.Chars;
            }
            ArgsAssert.isTrue((rlen = range.length) % 2 == 0, "range must be [min,max]*", new Object[0]);
            LinkedHashMap<String, char[]> rangeUniq = new LinkedHashMap<String, char[]>(rlen);
            for (int i = 0; i < rlen; i += 2) {
                char max = range[i + 1];
                char min = range[i];
                ArgsAssert.aGeb(Character.valueOf(max), Character.valueOf(min), "need max >= min in range", new Object[0]);
                rangeUniq.put(min + ":" + max, new char[]{min, max});
            }
            int rsiz = rangeUniq.size() * 2;
            if (rsiz == rlen) {
                this.range = range;
            } else {
                CharBuffer cb = CharBuffer.allocate(rsiz);
                for (char[] cs : rangeUniq.values()) {
                    cb.put(cs);
                }
                this.range = cb.array();
            }
            LinkedHashSet<Character> charsUniq = new LinkedHashSet<Character>(BoxedCastUtil.list(chars));
            int csiz = charsUniq.size();
            if (csiz == chars.length) {
                this.chars = chars;
            } else {
                this.chars = new char[csiz];
                int idx = 0;
                for (Character c : charsUniq) {
                    this.chars[idx++] = c.charValue();
                }
            }
        }

        public String rand(Random rnd, int len) {
            StringBuilder sb = new StringBuilder(len);
            this.rand(rnd, sb, len);
            return sb.toString();
        }

        public void rand(Random rnd, StringBuilder buf, int len) {
            for (int i = 0; i < len; ++i) {
                buf.append(this.next(rnd.nextInt()));
            }
        }

        public char next(int rnd) {
            boolean useRange;
            if (rnd < 0) {
                rnd >>>= 1;
            }
            if (this.range.length != 0 && this.chars.length != 0) {
                useRange = rnd % 2 == 0;
            } else {
                boolean bl = useRange = this.range.length != 0;
            }
            if (useRange) {
                int prt = rnd % this.range.length >>> 1 << 1;
                int len = this.range[prt + 1] - this.range[prt];
                if (len == 0) {
                    return this.range[prt];
                }
                return (char)(this.range[prt] + rnd % len);
            }
            int idx = rnd % this.chars.length;
            return this.chars[idx];
        }
    }
}

