/*
 * Decompiled with CFR 0.152.
 */
package pro.fessional.mirana.data;

import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.function.BiPredicate;
import java.util.function.Function;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Diff {
    @NotNull
    public static <E> S<E> of(@Nullable Collection<? extends E> setA, @Nullable Collection<? extends E> setB) {
        boolean hasA = Diff.has(setA);
        boolean hasB = Diff.has(setB);
        S d = new S();
        if (hasA && hasB) {
            LinkedHashSet<E> tb = new LinkedHashSet<E>(setB);
            for (E a : setA) {
                if (tb.remove(a)) {
                    d.aAndB.add(a);
                    continue;
                }
                d.aNotB.add(a);
            }
            d.bNotA.addAll(tb);
        } else {
            if (hasA) {
                d.aNotB.addAll(setA);
            }
            if (hasB) {
                d.bNotA.addAll(setB);
            }
        }
        return d;
    }

    @NotNull
    public static <E, K> D<E> of(@Nullable Collection<? extends E> setNew, @Nullable Collection<? extends E> setOld, @NotNull Function<E, K> getPk, @NotNull BiPredicate<E, E> same) {
        boolean hasA = Diff.has(setNew);
        boolean hasB = Diff.has(setOld);
        D d = new D();
        if (hasA && hasB) {
            LinkedHashMap<K, E> tb = new LinkedHashMap<K, E>(setOld.size());
            for (E b : setOld) {
                tb.put(getPk.apply(b), b);
            }
            for (E a : setNew) {
                K k = getPk.apply(a);
                if (k == null) {
                    d.newInsert.add(a);
                    continue;
                }
                Object b = tb.remove(k);
                if (b == null) {
                    d.newInsert.add(a);
                    continue;
                }
                if (same.test(a, b)) {
                    d.oldEqsNew.add(a);
                    continue;
                }
                d.newUpdate.add(a);
                d.oldUpdate.add(b);
            }
            d.oldDelete.addAll(tb.values());
        } else {
            if (hasA) {
                d.newInsert.addAll(setNew);
            }
            if (hasB) {
                d.oldDelete.addAll(setOld);
            }
        }
        return d;
    }

    private static boolean has(Collection<?> s) {
        return s != null && !s.isEmpty();
    }

    public static class D<E> {
        public final LinkedHashSet<E> newInsert = new LinkedHashSet();
        public final LinkedHashSet<E> newUpdate = new LinkedHashSet();
        public final LinkedHashSet<E> oldUpdate = new LinkedHashSet();
        public final LinkedHashSet<E> oldDelete = new LinkedHashSet();
        public final LinkedHashSet<E> oldEqsNew = new LinkedHashSet();
    }

    public static class S<E> {
        public final LinkedHashSet<E> aNotB = new LinkedHashSet();
        public final LinkedHashSet<E> bNotA = new LinkedHashSet();
        public final LinkedHashSet<E> aAndB = new LinkedHashSet();
    }
}

