/*
 * Decompiled with CFR 0.152.
 */
package pro.fessional.mirana.i18n;

import java.text.MessageFormat;
import java.util.Arrays;
import java.util.Locale;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import pro.fessional.mirana.i18n.I18nAware;

public class I18nString
implements I18nAware {
    public static final Object[] EMPTY_ARGS = new Object[0];
    private final String code;
    private String hint = "";
    private Object[] args = new Object[0];

    public I18nString(String code) {
        this.code = code == null ? "" : code;
    }

    public I18nString(String code, String hint) {
        String string = this.code = code == null ? "" : code;
        if (hint != null) {
            this.hint = hint;
        }
        this.args = EMPTY_ARGS;
    }

    public I18nString(String code, String hint, Object ... args) {
        String string = this.code = code == null ? "" : code;
        if (hint != null) {
            this.hint = hint;
        }
        if (args != null) {
            this.args = args;
        }
    }

    @NotNull
    public String getCode() {
        return this.code;
    }

    @NotNull
    public String getHint() {
        return this.hint;
    }

    public I18nString setHint(String hint) {
        if (hint != null) {
            this.hint = hint;
        }
        return this;
    }

    @NotNull
    public Object[] getArgs() {
        return this.args;
    }

    public I18nString setArgs(Object ... args) {
        if (args != null) {
            this.args = args;
        }
        return this;
    }

    @NotNull
    public String toString(Locale locale) {
        String r = this.hint;
        if (this.args.length > 0 && locale != null) {
            r = new MessageFormat(this.hint, locale).format(this.args);
        }
        return r == null ? "" : r;
    }

    public boolean isEmpty() {
        return this.code.isEmpty();
    }

    @Override
    @Nullable
    public String getI18nCode() {
        return this.code;
    }

    @Override
    @Nullable
    public Object[] getI18nArgs() {
        return this.args;
    }

    public String toString() {
        return "I18nString{code='" + this.code + '\'' + ", hint='" + this.hint + '\'' + ", args=" + Arrays.toString(this.args) + '}';
    }
}

