/*
 * Decompiled with CFR 0.152.
 */
package pro.fessional.mirana.id;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import pro.fessional.mirana.id.LightId;

public class LightIdUtil {
    private static final long INT_MAX = Integer.MAX_VALUE;

    private LightIdUtil() {
    }

    public static boolean valid(@Nullable LightId id) {
        return id != null && id.getBlock() >= 0 && id.getSequence() >= 0L;
    }

    public static boolean valid(@Nullable Integer block, @Nullable Long sequence) {
        return LightIdUtil.validBlock(block) && LightIdUtil.validSequence(sequence);
    }

    public static boolean valid(int block, long sequence) {
        return LightIdUtil.validBlock(block) && LightIdUtil.validSequence(sequence);
    }

    public static boolean validBlock(@Nullable Integer block) {
        if (block == null) {
            return false;
        }
        return LightIdUtil.validBlock((int)block);
    }

    public static boolean validBlock(int block) {
        return block >= 0 && block <= 1023;
    }

    public static boolean validSequence(@Nullable Long sequence) {
        if (sequence == null) {
            return false;
        }
        return LightIdUtil.validSequence((long)sequence);
    }

    public static boolean validSequence(long sequence) {
        return sequence >= 0L && sequence <= 0x1FFFFFFFFFFFL;
    }

    public static LightId toLightId(@Nullable Long lightId) {
        if (lightId == null) {
            return LightId.NONE;
        }
        return LightIdUtil.toLightId((long)lightId);
    }

    @NotNull
    public static LightId toLightId(long lightId) {
        int block = (int)(lightId >> 45 & 0x3FFL);
        long sequence = lightId & 0x1FFFFFFFFFFFL;
        if (LightIdUtil.valid(block, sequence)) {
            return new LightId(block, sequence);
        }
        return LightId.NONE;
    }

    public static long toId(int block, long sequence) {
        return (long)block << 45 | sequence;
    }

    public static boolean isNone(@Nullable LightId id) {
        if (id == null) {
            return true;
        }
        return id.getBlock() < 0 || id.getSequence() < 0L;
    }

    public static boolean isZero(@Nullable LightId id) {
        if (id == null) {
            return true;
        }
        return id.getBlock() == 0 && id.getSequence() == 0L;
    }

    public static boolean isZeroSequence(@Nullable LightId id) {
        if (id == null) {
            return true;
        }
        return id.getSequence() == 0L;
    }

    public static long sequenceOrElse(@Nullable LightId lightId, long elze) {
        if (lightId == null) {
            return elze;
        }
        long sequence = lightId.getSequence();
        if (LightIdUtil.validSequence(sequence)) {
            return sequence;
        }
        return elze;
    }

    public static long sequenceLong(long lightId) {
        return lightId & 0x1FFFFFFFFFFFL;
    }

    public static int sequenceInt(long lightId) {
        return (int)(lightId & Integer.MAX_VALUE);
    }
}

