/*
 * Decompiled with CFR 0.152.
 */
package pro.fessional.mirana.math;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Iterator;

public class AverageDecimal
implements Iterator<BigDecimal> {
    private final int size;
    private final int scale;
    private final BigDecimal total;
    private final BigDecimal precision;
    private final BigDecimal avgValue;
    private final BigDecimal fixValue;
    private final int fixCount;
    private int index;

    public static AverageDecimal of(BigDecimal total, int count) {
        return new AverageDecimal(total, count, 2);
    }

    public static AverageDecimal of(BigDecimal total, int count, int scale) {
        return new AverageDecimal(total, count, scale);
    }

    private AverageDecimal(BigDecimal total, int size, int scale) {
        this.size = size;
        this.scale = scale;
        this.total = total;
        BigDecimal itemSize = new BigDecimal(size);
        this.precision = BigDecimal.ONE.divide(BigDecimal.TEN.pow(scale), scale, RoundingMode.FLOOR);
        this.avgValue = total.divide(itemSize, scale, RoundingMode.FLOOR);
        this.fixValue = this.avgValue.add(this.precision);
        BigDecimal remaining = total.subtract(this.avgValue.multiply(itemSize));
        this.fixCount = remaining.divide(this.precision, 0, RoundingMode.FLOOR).intValue();
    }

    @Override
    public boolean hasNext() {
        return this.index < this.size;
    }

    @Override
    public BigDecimal next() {
        return this.get(this.index++);
    }

    @Override
    public void remove() {
    }

    public void reset() {
        this.index = 0;
    }

    public BigDecimal get(int i) {
        return i < this.fixCount ? this.fixValue : this.avgValue;
    }

    public int size() {
        return this.size;
    }

    public BigDecimal total() {
        return this.total;
    }

    public int scale() {
        return this.scale;
    }

    public BigDecimal getPrecision() {
        return this.precision;
    }

    public BigDecimal getAvgValue() {
        return this.avgValue;
    }

    public BigDecimal getFixValue() {
        return this.fixValue;
    }

    public int getFixCount() {
        return this.fixCount;
    }

    public String toString() {
        return "AverageDecimal{size=" + this.size + ", scale=" + this.scale + ", total=" + this.total + ", avgValue=" + this.avgValue + ", fixValue=" + this.fixValue + ", fixCount=" + this.fixCount + '}';
    }

    public static void main(String[] args) {
        BigDecimal sum;
        AverageDecimal avg;
        int j;
        BigDecimal number = new BigDecimal(100);
        for (j = 1; j < 10; ++j) {
            avg = AverageDecimal.of(number, j);
            System.out.println(avg);
            System.out.print("\t[");
            sum = BigDecimal.ZERO;
            for (int i = 0; i < avg.size(); ++i) {
                BigDecimal v = avg.get(i);
                sum = sum.add(v);
                System.out.print(v);
                System.out.print(" + ");
            }
            System.out.println("] = " + sum + " :" + (sum.compareTo(number) == 0));
        }
        System.out.println("===========");
        for (j = 1; j < 10; ++j) {
            avg = AverageDecimal.of(number, j, 0);
            System.out.println(avg);
            System.out.print("\t[");
            sum = BigDecimal.ZERO;
            while (avg.hasNext()) {
                BigDecimal v = avg.next();
                sum = sum.add(v);
                System.out.print(v);
                System.out.print(" + ");
            }
            System.out.println("] = " + sum + " :" + (sum.compareTo(number) == 0));
        }
    }
}

