/*
 * Decompiled with CFR 0.152.
 */
package pro.fessional.mirana.math;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.MathContext;
import java.math.RoundingMode;
import org.jetbrains.annotations.NotNull;
import pro.fessional.mirana.data.Null;

public class BigDecimalUtil {
    private static final MathContext MC = MathContext.DECIMAL32;

    @NotNull
    public static String string(BigDecimal v) {
        return BigDecimalUtil.string(v, "");
    }

    @NotNull
    public static String string(BigDecimal v, int scale) {
        BigDecimal dec = BigDecimalUtil.ceil(v, scale);
        return dec.toPlainString();
    }

    public static String string(BigDecimal v, String elz) {
        if (v == null) {
            return elz;
        }
        return v.toPlainString();
    }

    public static BigDecimal object(Number num) {
        return BigDecimalUtil.object(num, null);
    }

    public static BigDecimal object(String str) {
        return BigDecimalUtil.object(str, null);
    }

    public static BigDecimal object(String str, BigDecimal elz) {
        if (str == null || str.length() == 0) {
            return elz;
        }
        try {
            return new BigDecimal(str);
        }
        catch (Exception e) {
            return elz;
        }
    }

    public static BigDecimal object(Number num, BigDecimal elz) {
        BigDecimal r = num == null ? elz : (num instanceof Integer ? new BigDecimal(num.intValue()) : (num instanceof Long ? new BigDecimal(num.longValue()) : (num instanceof Double ? BigDecimal.valueOf(num.doubleValue()) : (num instanceof Float ? BigDecimal.valueOf(num.floatValue()) : (num instanceof BigInteger ? new BigDecimal((BigInteger)num) : (num instanceof BigDecimal ? (BigDecimal)num : new BigDecimal(num.toString())))))));
        return r;
    }

    public static BigDecimal[] objects(BigDecimal elz, Number ... vs) {
        if (vs == null || vs.length == 0) {
            return Null.BigDecimals;
        }
        BigDecimal[] arr = new BigDecimal[vs.length];
        for (int i = 0; i < vs.length; ++i) {
            arr[i] = BigDecimalUtil.object(vs[i], elz);
        }
        return arr;
    }

    public static BigDecimal[] objects(BigDecimal elz, String ... vs) {
        if (vs == null || vs.length == 0) {
            return Null.BigDecimals;
        }
        BigDecimal[] arr = new BigDecimal[vs.length];
        for (int i = 0; i < vs.length; ++i) {
            arr[i] = BigDecimalUtil.object(vs[i], elz);
        }
        return arr;
    }

    @NotNull
    public static BigDecimal avg(String ... vs) {
        return BigDecimalUtil.avg(BigDecimalUtil.objects(null, vs));
    }

    @NotNull
    public static BigDecimal avg(Number ... vs) {
        return BigDecimalUtil.avg(BigDecimalUtil.objects(null, vs));
    }

    @NotNull
    public static BigDecimal avg(BigDecimal ... vs) {
        if (vs == null || vs.length == 0) {
            return BigDecimal.ZERO;
        }
        BigDecimal total = BigDecimalUtil.sum(vs);
        return total.divide(new BigDecimal(vs.length), MC);
    }

    @NotNull
    public static BigDecimal avg(boolean skipNull, String ... vs) {
        return BigDecimalUtil.avg(skipNull, BigDecimalUtil.objects(null, vs));
    }

    @NotNull
    public static BigDecimal avg(boolean skipNull, Number ... vs) {
        return BigDecimalUtil.avg(skipNull, BigDecimalUtil.objects(null, vs));
    }

    @NotNull
    public static BigDecimal avg(boolean skipNull, BigDecimal ... vs) {
        if (!skipNull) {
            return BigDecimalUtil.avg(vs);
        }
        BigDecimal total = BigDecimal.ZERO;
        int count = 0;
        for (BigDecimal v : vs) {
            if (v == null) continue;
            total = total.add(v);
            ++count;
        }
        return total.divide(new BigDecimal(count), MC);
    }

    @NotNull
    public static BigDecimal sum(String ... vs) {
        return BigDecimalUtil.sum(BigDecimalUtil.objects(null, vs));
    }

    @NotNull
    public static BigDecimal sum(Number ... vs) {
        return BigDecimalUtil.sum(BigDecimalUtil.objects(null, vs));
    }

    @NotNull
    public static BigDecimal sum(BigDecimal ... vs) {
        BigDecimal total = BigDecimal.ZERO;
        for (BigDecimal v : vs) {
            if (v == null) continue;
            total = total.add(v);
        }
        return total;
    }

    @NotNull
    public static BigDecimal prd(boolean skipNull, String ... vs) {
        return BigDecimalUtil.prd(skipNull, BigDecimalUtil.objects(null, vs));
    }

    @NotNull
    public static BigDecimal prd(boolean skipNull, Number ... vs) {
        return BigDecimalUtil.prd(skipNull, BigDecimalUtil.objects(null, vs));
    }

    @NotNull
    public static BigDecimal prd(boolean skipNull, BigDecimal ... vs) {
        BigDecimal total = BigDecimal.ZERO;
        for (BigDecimal v : vs) {
            if (v == null) {
                if (skipNull) continue;
                return BigDecimal.ZERO;
            }
            total = total.multiply(v);
        }
        return total;
    }

    @NotNull
    public static BigDecimal notNull(@NotNull BigDecimal elz, String ... vs) {
        if (vs != null) {
            for (String s : vs) {
                BigDecimal v = BigDecimalUtil.object(s);
                if (v == null) continue;
                return v;
            }
        }
        return elz;
    }

    @NotNull
    public static BigDecimal notNull(@NotNull BigDecimal elz, Number ... vs) {
        if (vs != null) {
            for (Number v : vs) {
                if (v == null) continue;
                return BigDecimalUtil.object(v);
            }
        }
        return elz;
    }

    @NotNull
    public static BigDecimal notNull(@NotNull BigDecimal elz, BigDecimal ... vs) {
        if (vs != null) {
            for (BigDecimal v : vs) {
                if (v == null) continue;
                return v;
            }
        }
        return elz;
    }

    public static BigDecimal max(BigDecimal a, String b) {
        return BigDecimalUtil.max(a, BigDecimalUtil.object(b));
    }

    public static BigDecimal max(BigDecimal a, Number b) {
        return BigDecimalUtil.max(a, BigDecimalUtil.object(b));
    }

    public static BigDecimal max(BigDecimal a, BigDecimal b) {
        if (a == null) {
            return b;
        }
        if (b == null) {
            return a;
        }
        return a.max(b);
    }

    public static BigDecimal min(BigDecimal a, String b) {
        return BigDecimalUtil.max(a, BigDecimalUtil.object(b));
    }

    public static BigDecimal min(BigDecimal a, Number b) {
        return BigDecimalUtil.max(a, BigDecimalUtil.object(b));
    }

    public static BigDecimal min(BigDecimal a, BigDecimal b) {
        if (a == null) {
            return b;
        }
        if (b == null) {
            return a;
        }
        return a.min(b);
    }

    @NotNull
    public static BigDecimal add(BigDecimal a, int b) {
        return BigDecimalUtil.add(a, new BigDecimal(b), null);
    }

    @NotNull
    public static BigDecimal add(BigDecimal a, long b) {
        return BigDecimalUtil.add(a, new BigDecimal(b), null);
    }

    @NotNull
    public static BigDecimal add(BigDecimal a, double b) {
        return BigDecimalUtil.add(a, new BigDecimal(b), null);
    }

    @NotNull
    public static BigDecimal add(BigDecimal a, Number b) {
        return BigDecimalUtil.add(a, b, null);
    }

    @NotNull
    public static BigDecimal add(BigDecimal a, String b) {
        return BigDecimalUtil.add(a, b, null);
    }

    @NotNull
    public static BigDecimal add(BigDecimal a, BigDecimal b) {
        return BigDecimalUtil.add(a, b, null);
    }

    @NotNull
    public static BigDecimal add(BigDecimal a, String b, BigDecimal c) {
        return BigDecimalUtil.add(a, BigDecimalUtil.object(b), c);
    }

    @NotNull
    public static BigDecimal add(BigDecimal a, Number b, BigDecimal c) {
        return BigDecimalUtil.add(a, BigDecimalUtil.object(b), c);
    }

    @NotNull
    public static BigDecimal add(BigDecimal a, BigDecimal b, BigDecimal c) {
        if (a == null) {
            if (b == null) {
                if (c == null) {
                    return BigDecimal.ZERO;
                }
                return c;
            }
            return b;
        }
        if (b == null) {
            if (c == null) {
                return a;
            }
            return a.add(c);
        }
        return a.add(b);
    }

    @NotNull
    public static BigDecimal sub(BigDecimal a, int b) {
        return BigDecimalUtil.sub(a, new BigDecimal(b), null);
    }

    @NotNull
    public static BigDecimal sub(BigDecimal a, long b) {
        return BigDecimalUtil.sub(a, new BigDecimal(b), null);
    }

    @NotNull
    public static BigDecimal sub(BigDecimal a, double b) {
        return BigDecimalUtil.sub(a, new BigDecimal(b), null);
    }

    @NotNull
    public static BigDecimal sub(BigDecimal a, String b) {
        return BigDecimalUtil.sub(a, b, null);
    }

    @NotNull
    public static BigDecimal sub(BigDecimal a, Number b) {
        return BigDecimalUtil.sub(a, b, null);
    }

    @NotNull
    public static BigDecimal sub(BigDecimal a, BigDecimal b) {
        return BigDecimalUtil.sub(a, b, null);
    }

    @NotNull
    public static BigDecimal sub(BigDecimal a, String b, BigDecimal c) {
        return BigDecimalUtil.sub(a, BigDecimalUtil.object(b), c);
    }

    @NotNull
    public static BigDecimal sub(BigDecimal a, Number b, BigDecimal c) {
        return BigDecimalUtil.sub(a, BigDecimalUtil.object(b), c);
    }

    @NotNull
    public static BigDecimal sub(BigDecimal a, BigDecimal b, BigDecimal c) {
        if (a == null) {
            if (b == null) {
                if (c == null) {
                    return BigDecimal.ZERO;
                }
                return c.negate();
            }
            return b.negate();
        }
        if (b == null) {
            if (c == null) {
                return a;
            }
            return a.subtract(c);
        }
        return a.subtract(b);
    }

    @NotNull
    public static BigDecimal mul(BigDecimal a, int b) {
        return BigDecimalUtil.mul(a, new BigDecimal(b), null);
    }

    @NotNull
    public static BigDecimal mul(BigDecimal a, long b) {
        return BigDecimalUtil.mul(a, new BigDecimal(b), null);
    }

    @NotNull
    public static BigDecimal mul(BigDecimal a, double b) {
        return BigDecimalUtil.mul(a, new BigDecimal(b), null);
    }

    @NotNull
    public static BigDecimal mul(BigDecimal a, String b) {
        return BigDecimalUtil.mul(a, b, null);
    }

    @NotNull
    public static BigDecimal mul(BigDecimal a, Number b) {
        return BigDecimalUtil.mul(a, b, null);
    }

    @NotNull
    public static BigDecimal mul(BigDecimal a, BigDecimal b) {
        return BigDecimalUtil.mul(a, b, null);
    }

    @NotNull
    public static BigDecimal mul(BigDecimal a, String b, BigDecimal c) {
        return BigDecimalUtil.mul(a, BigDecimalUtil.object(b), c);
    }

    @NotNull
    public static BigDecimal mul(BigDecimal a, Number b, BigDecimal c) {
        return BigDecimalUtil.mul(a, BigDecimalUtil.object(b), c);
    }

    @NotNull
    public static BigDecimal mul(BigDecimal a, BigDecimal b, BigDecimal c) {
        if (a == null) {
            return BigDecimal.ZERO;
        }
        if (b == null) {
            if (c == null) {
                return BigDecimal.ZERO;
            }
            return a.multiply(c);
        }
        return a.multiply(b);
    }

    @NotNull
    public static BigDecimal div(BigDecimal a, int b) {
        return BigDecimalUtil.div(a, new BigDecimal(b), null);
    }

    @NotNull
    public static BigDecimal div(BigDecimal a, long b) {
        return BigDecimalUtil.div(a, new BigDecimal(b), null);
    }

    @NotNull
    public static BigDecimal div(BigDecimal a, double b) {
        return BigDecimalUtil.div(a, new BigDecimal(b), null);
    }

    @NotNull
    public static BigDecimal div(BigDecimal a, String b) {
        return BigDecimalUtil.div(a, b, null);
    }

    @NotNull
    public static BigDecimal div(BigDecimal a, Number b) {
        return BigDecimalUtil.div(a, b, null);
    }

    @NotNull
    public static BigDecimal div(BigDecimal a, BigDecimal b) {
        return BigDecimalUtil.div(a, b, null);
    }

    @NotNull
    public static BigDecimal div(BigDecimal a, String b, BigDecimal c) {
        return BigDecimalUtil.div(a, BigDecimalUtil.object(b), c);
    }

    @NotNull
    public static BigDecimal div(BigDecimal a, Number b, BigDecimal c) {
        return BigDecimalUtil.div(a, BigDecimalUtil.object(b), c);
    }

    @NotNull
    public static BigDecimal div(BigDecimal a, BigDecimal b, BigDecimal c) {
        if (b == null && c == null) {
            throw new ArithmeticException("Division by null");
        }
        if (a == null) {
            return BigDecimal.ZERO;
        }
        if (b == null) {
            return a.divide(c, MC);
        }
        return a.divide(b, MC);
    }

    @NotNull
    public static BigDecimal pow(String a, int n) {
        if (a == null) {
            return BigDecimal.ZERO;
        }
        return BigDecimalUtil.pow(BigDecimalUtil.object(a), n);
    }

    @NotNull
    public static BigDecimal pow(Number a, int n) {
        if (a == null) {
            return BigDecimal.ZERO;
        }
        return BigDecimalUtil.pow(BigDecimalUtil.object(a), n);
    }

    @NotNull
    public static BigDecimal pow(BigDecimal a, int n) {
        if (a == null) {
            return BigDecimal.ZERO;
        }
        return a.pow(n);
    }

    @NotNull
    public static BigDecimal neg(String a) {
        if (a == null) {
            return BigDecimal.ZERO;
        }
        return BigDecimalUtil.neg(BigDecimalUtil.object(a));
    }

    @NotNull
    public static BigDecimal neg(Number a) {
        if (a == null) {
            return BigDecimal.ZERO;
        }
        return BigDecimalUtil.neg(BigDecimalUtil.object(a));
    }

    @NotNull
    public static BigDecimal neg(BigDecimal a) {
        if (a == null) {
            return BigDecimal.ZERO;
        }
        return a.negate();
    }

    @NotNull
    public static BigDecimal ceil(String value, int scale) {
        return BigDecimalUtil.ceil(BigDecimalUtil.object(value), scale);
    }

    @NotNull
    public static BigDecimal ceil(Number value, int scale) {
        return BigDecimalUtil.ceil(BigDecimalUtil.object(value), scale);
    }

    @NotNull
    public static BigDecimal ceil(BigDecimal value, int scale) {
        return BigDecimalUtil.scale(value, scale, RoundingMode.CEILING);
    }

    @NotNull
    public static BigDecimal floor(String value, int scale) {
        return BigDecimalUtil.floor(BigDecimalUtil.object(value), scale);
    }

    @NotNull
    public static BigDecimal floor(Number value, int scale) {
        return BigDecimalUtil.floor(BigDecimalUtil.object(value), scale);
    }

    @NotNull
    public static BigDecimal floor(BigDecimal value, int scale) {
        return BigDecimalUtil.scale(value, scale, RoundingMode.FLOOR);
    }

    @NotNull
    public static BigDecimal round(String value, int scale) {
        return BigDecimalUtil.round(BigDecimalUtil.object(value), scale);
    }

    @NotNull
    public static BigDecimal round(Number value, int scale) {
        return BigDecimalUtil.round(BigDecimalUtil.object(value), scale);
    }

    @NotNull
    public static BigDecimal round(BigDecimal value, int scale) {
        return BigDecimalUtil.scale(value, scale, RoundingMode.HALF_UP);
    }

    @NotNull
    public static BigDecimal scale(String value, int scale, RoundingMode mode) {
        return BigDecimalUtil.scale(BigDecimalUtil.object(value), scale, mode);
    }

    @NotNull
    public static BigDecimal scale(Number value, int scale, RoundingMode mode) {
        return BigDecimalUtil.scale(BigDecimalUtil.object(value), scale, mode);
    }

    @NotNull
    public static BigDecimal scale(BigDecimal value, int scale, RoundingMode mode) {
        if (value == null) {
            return BigDecimal.ZERO.setScale(scale, mode);
        }
        if (value.scale() == scale) {
            return value;
        }
        return value.setScale(scale + 1, RoundingMode.FLOOR).setScale(scale, mode);
    }

    @NotNull
    public static BigDecimal unitUp(BigDecimal value, BigDecimal unit) {
        return BigDecimalUtil.unitUp(value, unit, BigDecimal.ZERO);
    }

    @NotNull
    public static BigDecimal unitUp(BigDecimal value, BigDecimal unit, BigDecimal down) {
        int unitScale = unit.scale();
        if (value == null) {
            value = BigDecimal.ZERO;
        } else {
            if (down == null) {
                down = BigDecimal.ZERO;
            }
            BigDecimal[] dr = value.divideAndRemainder(unit);
            value = dr[0].multiply(unit);
            if (BigDecimalUtil.compareTo(dr[1], down, unitScale, RoundingMode.FLOOR) > 0) {
                value = value.add(unit);
            }
        }
        if (value.scale() != unitScale) {
            value = value.setScale(unitScale, RoundingMode.FLOOR);
        }
        return value;
    }

    @NotNull
    public static BigDecimal unitDown(BigDecimal value, BigDecimal unit) {
        return BigDecimalUtil.unitDown(value, unit, unit);
    }

    @NotNull
    public static BigDecimal unitDown(BigDecimal value, BigDecimal unit, BigDecimal upto) {
        int unitScale = unit.scale();
        if (value == null) {
            value = BigDecimal.ZERO;
        } else {
            BigDecimal[] dr = value.divideAndRemainder(unit);
            value = dr[0].multiply(unit);
            if (BigDecimalUtil.compareTo(dr[1], upto, unitScale, RoundingMode.FLOOR) >= 0) {
                value = value.add(unit);
            }
        }
        if (value.scale() != unitScale) {
            value = value.setScale(unitScale, RoundingMode.FLOOR);
        }
        return value;
    }

    public static int compareTo(BigDecimal a, String b) {
        return BigDecimalUtil.compareTo(a, BigDecimalUtil.object(b));
    }

    public static int compareTo(BigDecimal a, Number b) {
        return BigDecimalUtil.compareTo(a, BigDecimalUtil.object(b));
    }

    public static int compareTo(BigDecimal a, BigDecimal b) {
        if (a == null && b == null) {
            return 0;
        }
        if (a == null) {
            return -1;
        }
        if (b == null) {
            return 1;
        }
        return a.compareTo(b);
    }

    public static int compareTo(BigDecimal a, String b, int scale, RoundingMode mode) {
        return BigDecimalUtil.compareTo(a, BigDecimalUtil.object(b), scale, mode);
    }

    public static int compareTo(BigDecimal a, Number b, int scale, RoundingMode mode) {
        return BigDecimalUtil.compareTo(a, BigDecimalUtil.object(b), scale, mode);
    }

    public static int compareTo(BigDecimal a, BigDecimal b, int scale, RoundingMode mode) {
        if (a == null && b == null) {
            return 0;
        }
        if (a == null) {
            return -1;
        }
        if (b == null) {
            return 1;
        }
        if (a.scale() > scale) {
            a = BigDecimalUtil.scale(a, scale, mode);
        }
        if (b.scale() > scale) {
            b = BigDecimalUtil.scale(b, scale, mode);
        }
        return a.compareTo(b);
    }

    public static int compareTo(BigDecimal a, double b) {
        if (a == null) {
            return -1;
        }
        double d = a.doubleValue();
        return Double.compare(d, b);
    }

    public static boolean equalsValue(BigDecimal a, String b) {
        return BigDecimalUtil.equalsValue(a, BigDecimalUtil.object(b));
    }

    public static boolean equalsValue(BigDecimal a, Number b) {
        return BigDecimalUtil.equalsValue(a, BigDecimalUtil.object(b));
    }

    public static boolean equalsValue(BigDecimal a, BigDecimal b) {
        return BigDecimalUtil.compareTo(a, b) == 0;
    }

    public static boolean equalsValue(BigDecimal a, String b, int scale, RoundingMode mode) {
        return BigDecimalUtil.equalsValue(a, BigDecimalUtil.object(b), scale, mode);
    }

    public static boolean equalsValue(BigDecimal a, Number b, int scale, RoundingMode mode) {
        return BigDecimalUtil.equalsValue(a, BigDecimalUtil.object(b), scale, mode);
    }

    public static boolean equalsValue(BigDecimal a, BigDecimal b, int scale, RoundingMode mode) {
        return BigDecimalUtil.compareTo(a, b, scale, mode) == 0;
    }

    @NotNull
    public static W w(String v) {
        return new W(BigDecimalUtil.object(v));
    }

    @NotNull
    public static W w(String v, int scale) {
        return new W(BigDecimalUtil.object(v), scale);
    }

    @NotNull
    public static W w(String v, int scale, @NotNull BigDecimal el) {
        return new W(BigDecimalUtil.object(v, el), scale);
    }

    @NotNull
    public static W w(Number v) {
        return new W(BigDecimalUtil.object(v));
    }

    @NotNull
    public static W w(Number v, int scale) {
        return new W(BigDecimalUtil.object(v), scale);
    }

    @NotNull
    public static W w(Number v, int scale, @NotNull BigDecimal el) {
        return new W(BigDecimalUtil.object(v, el), scale);
    }

    @NotNull
    public static W w(BigDecimal v) {
        return new W(v);
    }

    @NotNull
    public static W w(BigDecimal v, int scale) {
        return new W(v, scale);
    }

    @NotNull
    public static W w(BigDecimal ... vs) {
        return new W(BigDecimalUtil.notNull(BigDecimal.ZERO, vs));
    }

    @NotNull
    public static W w(int scale, BigDecimal ... vs) {
        return new W(BigDecimalUtil.notNull(BigDecimal.ZERO, vs), scale);
    }

    @NotNull
    public static W w(int scale, Number ... vs) {
        return new W(BigDecimalUtil.notNull(BigDecimal.ZERO, vs), scale);
    }

    public static class W {
        private BigDecimal value;
        private int scale;

        public W(BigDecimal d) {
            if (d == null) {
                this.value = BigDecimal.ZERO;
                this.scale = 0;
            } else {
                this.value = d;
                this.scale = d.scale();
            }
        }

        public W(BigDecimal value, int scale) {
            this.value = value == null ? BigDecimal.ZERO : value;
            this.scale = scale;
        }

        @NotNull
        public BigDecimal result(RoundingMode mode) {
            return this.value.setScale(this.scale, mode);
        }

        @NotNull
        public BigDecimal resultRaw() {
            return this.value;
        }

        @NotNull
        public BigDecimal resultCeil() {
            return BigDecimalUtil.ceil(this.value, this.scale);
        }

        @NotNull
        public BigDecimal resultRound() {
            return BigDecimalUtil.round(this.value, this.scale);
        }

        @NotNull
        public BigDecimal resultFloor() {
            return BigDecimalUtil.floor(this.value, this.scale);
        }

        @NotNull
        public BigDecimal resultUnitUp(BigDecimal unit) {
            return BigDecimalUtil.unitUp(this.value, unit);
        }

        @NotNull
        public BigDecimal resultUnitUp(BigDecimal unit, BigDecimal zeroing) {
            return BigDecimalUtil.unitUp(this.value, unit, zeroing);
        }

        @NotNull
        public BigDecimal resultUnitDown(BigDecimal unit) {
            return BigDecimalUtil.unitDown(this.value, unit);
        }

        @NotNull
        public BigDecimal result(int scale, RoundingMode mode) {
            return this.value.setScale(scale, mode);
        }

        @NotNull
        public BigDecimal resultCeil(int scale) {
            return BigDecimalUtil.ceil(this.value, scale);
        }

        @NotNull
        public BigDecimal resultRound(int scale) {
            return BigDecimalUtil.round(this.value, scale);
        }

        @NotNull
        public BigDecimal resultFloor(int scale) {
            return BigDecimalUtil.floor(this.value, scale);
        }

        @NotNull
        public W setScale(int scale) {
            this.scale = scale;
            return this;
        }

        @NotNull
        public W setValue(BigDecimal value) {
            this.value = value == null ? BigDecimal.ZERO : value;
            return this;
        }

        @NotNull
        public W add(int b) {
            this.value = BigDecimalUtil.add(this.value, b);
            return this;
        }

        @NotNull
        public W add(long b) {
            this.value = BigDecimalUtil.add(this.value, b);
            return this;
        }

        @NotNull
        public W add(double b) {
            this.value = BigDecimalUtil.add(this.value, b);
            return this;
        }

        @NotNull
        public W add(Number b) {
            this.value = BigDecimalUtil.add(this.value, b);
            return this;
        }

        @NotNull
        public W add(BigDecimal b) {
            this.value = BigDecimalUtil.add(this.value, b);
            return this;
        }

        @NotNull
        public W add(String b) {
            this.value = BigDecimalUtil.add(this.value, b);
            return this;
        }

        @NotNull
        public W add(String b, BigDecimal c) {
            this.value = BigDecimalUtil.add(this.value, b, c);
            return this;
        }

        @NotNull
        public W add(BigDecimal b, BigDecimal c) {
            this.value = BigDecimalUtil.add(this.value, b, c);
            return this;
        }

        @NotNull
        public W add(W b) {
            this.value = BigDecimalUtil.add(this.value, b.value);
            return this;
        }

        @NotNull
        public W sub(int b) {
            this.value = BigDecimalUtil.sub(this.value, b);
            return this;
        }

        @NotNull
        public W sub(long b) {
            this.value = BigDecimalUtil.sub(this.value, b);
            return this;
        }

        @NotNull
        public W sub(double b) {
            this.value = BigDecimalUtil.sub(this.value, b);
            return this;
        }

        @NotNull
        public W sub(Number b) {
            this.value = BigDecimalUtil.sub(this.value, b);
            return this;
        }

        @NotNull
        public W sub(String b) {
            this.value = BigDecimalUtil.sub(this.value, b);
            return this;
        }

        @NotNull
        public W sub(BigDecimal b) {
            this.value = BigDecimalUtil.sub(this.value, b);
            return this;
        }

        @NotNull
        public W sub(String b, BigDecimal c) {
            this.value = BigDecimalUtil.sub(this.value, b, c);
            return this;
        }

        @NotNull
        public W sub(BigDecimal b, BigDecimal c) {
            this.value = BigDecimalUtil.sub(this.value, b, c);
            return this;
        }

        @NotNull
        public W sub(W b) {
            this.value = BigDecimalUtil.sub(this.value, b.value);
            return this;
        }

        @NotNull
        public W mul(int b) {
            this.value = BigDecimalUtil.mul(this.value, b);
            return this;
        }

        @NotNull
        public W mul(long b) {
            this.value = BigDecimalUtil.mul(this.value, b);
            return this;
        }

        @NotNull
        public W mul(double b) {
            this.value = BigDecimalUtil.mul(this.value, b);
            return this;
        }

        @NotNull
        public W mul(Number b) {
            this.value = BigDecimalUtil.mul(this.value, b);
            return this;
        }

        @NotNull
        public W mul(String b) {
            this.value = BigDecimalUtil.mul(this.value, b);
            return this;
        }

        @NotNull
        public W mul(BigDecimal b) {
            this.value = BigDecimalUtil.mul(this.value, b);
            return this;
        }

        @NotNull
        public W mul(String b, BigDecimal c) {
            this.value = BigDecimalUtil.mul(this.value, b, c);
            return this;
        }

        @NotNull
        public W mul(BigDecimal b, BigDecimal c) {
            this.value = BigDecimalUtil.mul(this.value, b, c);
            return this;
        }

        @NotNull
        public W mul(W b) {
            this.value = BigDecimalUtil.mul(this.value, b.value);
            return this;
        }

        @NotNull
        public W div(int b) {
            this.value = BigDecimalUtil.div(this.value, b);
            return this;
        }

        @NotNull
        public W div(long b) {
            this.value = BigDecimalUtil.div(this.value, b);
            return this;
        }

        @NotNull
        public W div(double b) {
            this.value = BigDecimalUtil.div(this.value, b);
            return this;
        }

        @NotNull
        public W div(Number b) {
            this.value = BigDecimalUtil.div(this.value, b);
            return this;
        }

        @NotNull
        public W div(String b) {
            this.value = BigDecimalUtil.div(this.value, b);
            return this;
        }

        @NotNull
        public W div(BigDecimal b) {
            this.value = BigDecimalUtil.div(this.value, b);
            return this;
        }

        @NotNull
        public W div(String b, BigDecimal c) {
            this.value = BigDecimalUtil.div(this.value, b, c);
            return this;
        }

        @NotNull
        public W div(BigDecimal b, BigDecimal c) {
            this.value = BigDecimalUtil.div(this.value, b, c);
            return this;
        }

        @NotNull
        public W div(W v) {
            this.value = BigDecimalUtil.div(this.value, v.value);
            return this;
        }

        @NotNull
        public W pow(int n) {
            this.value = BigDecimalUtil.pow(this.value, n);
            return this;
        }

        @NotNull
        public W neg() {
            this.value = BigDecimalUtil.neg(this.value);
            return this;
        }

        @NotNull
        public W sum(String ... vs) {
            this.value = BigDecimalUtil.sum(vs);
            return this;
        }

        @NotNull
        public W sum(BigDecimal ... vs) {
            this.value = BigDecimalUtil.sum(vs);
            return this;
        }

        @NotNull
        public W prd(boolean skipNull, String ... vs) {
            this.value = BigDecimalUtil.prd(skipNull, vs);
            return this;
        }

        @NotNull
        public W prd(boolean skipNull, Number ... vs) {
            this.value = BigDecimalUtil.prd(skipNull, vs);
            return this;
        }

        @NotNull
        public W prd(boolean skipNull, BigDecimal ... vs) {
            this.value = BigDecimalUtil.prd(skipNull, vs);
            return this;
        }

        @NotNull
        public W ceil(int scale) {
            this.value = BigDecimalUtil.ceil(this.value, scale);
            return this;
        }

        @NotNull
        public W round(int scale) {
            this.value = BigDecimalUtil.round(this.value, scale);
            return this;
        }

        @NotNull
        public W floor(int scale) {
            this.value = BigDecimalUtil.floor(this.value, scale);
            return this;
        }
    }
}

