/*
 * Decompiled with CFR 0.152.
 */
package pro.fessional.mirana.page;

import java.io.Serializable;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import pro.fessional.mirana.page.PageUtil;

public class PageQuery
implements Serializable {
    private int pageNumber = 1;
    private int pageSize = 1;
    private String sortBy = "";

    public PageQuery() {
    }

    public PageQuery(int pageNumber, int pageSize) {
        this.pageNumber = pageNumber;
        this.pageSize = pageSize;
    }

    public PageQuery(int pageNumber, int pageSize, String sortBy) {
        this.pageNumber = pageNumber;
        this.pageSize = pageSize;
        this.sortBy = sortBy == null ? "" : sortBy;
    }

    public int getPageNumber() {
        return this.pageNumber;
    }

    public PageQuery setPageNumber(int pageNumber) {
        this.pageNumber = Math.max(pageNumber, 1);
        return this;
    }

    public int getPageSize() {
        return this.pageSize;
    }

    public PageQuery setPageSize(int pageSize) {
        this.pageSize = Math.max(pageSize, 1);
        return this;
    }

    @NotNull
    public String getSortBy() {
        return this.sortBy;
    }

    public PageQuery setSortBy(String sortBy) {
        this.sortBy = sortBy == null ? "" : sortBy;
        return this;
    }

    public int toOffset() {
        return PageUtil.dataIndex(this.pageNumber, this.pageSize);
    }

    public String toString() {
        return "PageQuery{pageNumber=" + this.pageNumber + ", pageSize=" + this.pageSize + ", sortBy='" + this.sortBy + '\'' + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PageQuery pageQuery = (PageQuery)o;
        return this.pageNumber == pageQuery.pageNumber && this.pageSize == pageQuery.pageSize && this.sortBy.equals(pageQuery.sortBy);
    }

    public int hashCode() {
        return Objects.hash(this.pageNumber, this.pageSize, this.sortBy);
    }
}

