/*
 * Decompiled with CFR 0.152.
 */
package pro.fessional.mirana.page;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import pro.fessional.mirana.text.WhiteUtil;

public class PageUtil {
    public static final char SORT_DESC = '-';
    public static final char SORT_DELI = ',';

    public static int dataIndex(int pageNumber, int pageSize) {
        if (pageNumber <= 1) {
            return 0;
        }
        if (pageSize <= 1) {
            return pageNumber - 1;
        }
        return pageNumber * pageSize - pageSize;
    }

    public static int totalPage(int totalData, int pageSize) {
        if (totalData <= 1) {
            return 1;
        }
        if (pageSize <= 1) {
            return totalData;
        }
        return (totalData - 1) / pageSize + 1;
    }

    public static Sb sort() {
        return new Sb(new StringBuilder(32));
    }

    public static List<By> sortBy(String sortBy) {
        By st;
        if (sortBy == null || sortBy.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<By> bies = new ArrayList<By>(4);
        StringBuilder buf = new StringBuilder(16);
        int len = sortBy.length();
        for (int i = 0; i < len; ++i) {
            char c = sortBy.charAt(i);
            if (c == ',') {
                By st2 = By.of(buf);
                if (st2 != null) {
                    bies.add(st2);
                }
                buf.setLength(0);
                continue;
            }
            if (!WhiteUtil.notWhiteSpace(c)) continue;
            buf.append(c);
        }
        if (buf.length() > 0 && (st = By.of(buf)) != null) {
            bies.add(st);
        }
        return bies;
    }

    public static class By {
        public final String key;
        public final boolean asc;

        private By(String key, boolean asc) {
            this.key = key;
            this.asc = asc;
        }

        public static By of(StringBuilder key) {
            if (key == null) {
                return null;
            }
            int len = key.length();
            if (len > 0) {
                if (key.charAt(0) == '-') {
                    if (len > 1) {
                        return new By(key.substring(1), false);
                    }
                    return null;
                }
                return new By(key.toString(), true);
            }
            return null;
        }

        public static By of(String key, boolean asc) {
            if (key == null || key.isEmpty()) {
                return null;
            }
            return new By(key, asc);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            By by = (By)o;
            return this.asc == by.asc && this.key.equals(by.key);
        }

        public int hashCode() {
            return Objects.hash(this.key, this.asc);
        }
    }

    public static class Sb {
        private final StringBuilder buf;

        public Sb(StringBuilder sb) {
            this.buf = sb == null ? new StringBuilder() : sb;
        }

        public Sb by(String key, boolean asc) {
            if (key != null && key.length() > 0) {
                this.buf.append(',');
                if (!asc) {
                    this.buf.append('-');
                }
                this.buf.append(key);
            }
            return this;
        }

        public Sb by(By by) {
            if (by != null) {
                this.by(by.key, by.asc);
            }
            return this;
        }

        public Sb by(Collection<By> sort) {
            if (sort != null) {
                for (By st : sort) {
                    this.by(st);
                }
            }
            return this;
        }

        public String build() {
            return this.buf.length() > 0 ? this.buf.substring(1) : this.buf.toString();
        }

        public String toString() {
            return this.build();
        }
    }
}

