/*
 * Decompiled with CFR 0.152.
 */
package pro.fessional.mirana.text;

import java.util.Collection;
import java.util.function.Function;
import java.util.stream.IntStream;
import org.jetbrains.annotations.NotNull;

public class BuilderHelper {
    private static final ThreadLocal<StringBuilder> BUILDER = ThreadLocal.withInitial(() -> new StringBuilder(256));

    public static StringBuilder getBuilder() {
        StringBuilder builder = BUILDER.get();
        int len = builder.length();
        if (len > 1024) {
            builder = new StringBuilder(256);
            BUILDER.set(builder);
        } else if (len > 0) {
            builder.setLength(0);
        }
        return builder;
    }

    @NotNull
    public static StringBuilder append(@NotNull StringBuilder sb, Object obj) {
        if (obj == null) {
            return sb;
        }
        if (obj instanceof char[]) {
            sb.append((char[])obj);
        } else {
            sb.append(obj);
        }
        return sb;
    }

    @NotNull
    public static StringBuilder delete(@NotNull StringBuilder sb) {
        sb.setLength(0);
        return sb;
    }

    @NotNull
    public static StringBuilder delete(@NotNull StringBuilder sb, int count) {
        if (count <= 0) {
            return sb;
        }
        int len = sb.length() - count;
        sb.setLength(Math.max(len, 0));
        return sb;
    }

    @NotNull
    public static StringBuilder join(@NotNull StringBuilder sb, String jn, Object ... arr) {
        return BuilderHelper.join(sb, false, jn, arr);
    }

    @NotNull
    public static StringBuilder join(@NotNull StringBuilder sb, boolean skipNull, String jn, Object ... arr) {
        if (arr == null || arr.length == 0) {
            return sb;
        }
        if (arr[0] != null) {
            sb.append(arr[0]);
        }
        for (int i = 1; i < arr.length; ++i) {
            if (arr[i] != null || !skipNull) {
                sb.append(jn);
            }
            if (arr[i] == null) continue;
            sb.append(arr[i]);
        }
        return sb;
    }

    @NotNull
    public static StringBuilder join(@NotNull StringBuilder sb, String jn, Collection<?> arr) {
        return BuilderHelper.join(sb, false, jn, arr);
    }

    @NotNull
    public static StringBuilder join(@NotNull StringBuilder sb, boolean skipNull, String jn, Collection<?> arr) {
        if (arr == null || arr.size() == 0) {
            return sb;
        }
        for (Object o : arr) {
            if (o != null) {
                sb.append(o);
            }
            if (o == null && skipNull) continue;
            sb.append(jn);
        }
        BuilderHelper.delete(sb, jn.length());
        return sb;
    }

    @NotNull
    public static <T, R> StringBuilder join(@NotNull StringBuilder sb, String jn, Collection<T> arr, Function<T, R> fn) {
        return BuilderHelper.join(sb, false, jn, arr, fn);
    }

    @NotNull
    public static <T, R> StringBuilder join(@NotNull StringBuilder sb, boolean skipNull, String jn, Collection<T> arr, Function<T, R> fn) {
        if (arr == null || arr.size() == 0) {
            return sb;
        }
        for (T t : arr) {
            if (t != null) {
                sb.append(fn.apply(t));
            }
            if (t == null && skipNull) continue;
            sb.append(jn);
        }
        BuilderHelper.delete(sb, jn.length());
        return sb;
    }

    public static W w() {
        return new W();
    }

    public static W w(StringBuilder sb) {
        return new W(sb);
    }

    public static class W
    implements Appendable,
    CharSequence {
        public final StringBuilder builder;

        public W() {
            this.builder = BuilderHelper.getBuilder();
        }

        public W(StringBuilder builder) {
            this.builder = builder == null ? BuilderHelper.getBuilder() : builder;
        }

        public StringBuilder result() {
            return this.builder;
        }

        public W delete() {
            BuilderHelper.delete(this.builder);
            return this;
        }

        public W delete(int count) {
            BuilderHelper.delete(this.builder, count);
            return this;
        }

        public W delete(int s, int e) {
            this.builder.delete(s, e);
            return this;
        }

        public W join(String jn, Object ... arr) {
            BuilderHelper.join(this.builder, jn, arr);
            return this;
        }

        public W join(String jn, Collection<?> arr) {
            BuilderHelper.join(this.builder, jn, arr);
            return this;
        }

        public <T, R> W join(String jn, Collection<T> arr, Function<T, R> fun) {
            BuilderHelper.join(this.builder, jn, arr, fun);
            return this;
        }

        public W join(boolean skipNull, String jn, Object ... arr) {
            BuilderHelper.join(this.builder, skipNull, jn, arr);
            return this;
        }

        public W join(boolean skipNull, String jn, Collection<?> arr) {
            BuilderHelper.join(this.builder, skipNull, jn, arr);
            return this;
        }

        public <T, R> W join(boolean skipNull, String jn, Collection<T> arr, Function<T, R> fun) {
            BuilderHelper.join(this.builder, skipNull, jn, arr, fun);
            return this;
        }

        public W append(boolean v) {
            this.builder.append(v);
            return this;
        }

        public W append(int v) {
            this.builder.append(v);
            return this;
        }

        public W append(long v) {
            this.builder.append(v);
            return this;
        }

        public W append(float v) {
            this.builder.append(v);
            return this;
        }

        public W append(double v) {
            this.builder.append(v);
            return this;
        }

        public W append(char[] v) {
            this.builder.append(v);
            return this;
        }

        public W append(StringBuffer v) {
            this.builder.append(v);
            return this;
        }

        public W append(char[] v, int s, int e) {
            this.builder.append(v, s, e);
            return this;
        }

        public W append(Object v) {
            if (v != null) {
                this.builder.append(v);
            }
            return this;
        }

        @Override
        public W append(CharSequence v) {
            if (v != null) {
                this.builder.append(v);
            }
            return this;
        }

        @Override
        public W append(CharSequence csq, int start, int end) {
            if (csq != null) {
                this.builder.append(csq, start, end);
            }
            return this;
        }

        @Override
        public W append(char c) {
            this.builder.append(c);
            return this;
        }

        @Override
        public IntStream chars() {
            return this.builder.chars();
        }

        @Override
        public IntStream codePoints() {
            return this.builder.codePoints();
        }

        @Override
        public int length() {
            return this.builder.length();
        }

        @Override
        public char charAt(int index) {
            return this.builder.charAt(index);
        }

        @Override
        public CharSequence subSequence(int start, int end) {
            return this.builder.subSequence(start, end);
        }

        @Override
        @NotNull
        public String toString() {
            return this.builder.toString();
        }
    }
}

