/*
 * Decompiled with CFR 0.152.
 */
package pro.fessional.mirana.text;

import java.util.ArrayDeque;
import java.util.ArrayList;
import org.jetbrains.annotations.NotNull;
import pro.fessional.mirana.data.Null;

public class Wildcard {
    @NotNull
    public static String[] compile(CharSequence str) {
        if (str == null) {
            return Null.StrArr;
        }
        StringBuilder buf = new StringBuilder(16);
        ArrayList<String> ptn = new ArrayList<String>(4);
        int lastChr = 0;
        int len = str.length();
        for (int i = 0; i < len; ++i) {
            char ch = str.charAt(i);
            if (ch == '*') {
                if (buf.length() > 0) {
                    ptn.add(buf.toString());
                    buf.setLength(0);
                }
                if (lastChr != 42) {
                    ptn.add("*");
                }
                lastChr = ch;
                continue;
            }
            if (ch == '?') {
                if (lastChr == 42) {
                    int ps = ptn.size();
                    if (ps == 1) {
                        ptn.add(0, "?");
                    } else {
                        ptn.set(ps - 1, (String)ptn.get(ps - 1) + "?");
                    }
                    lastChr = 42;
                    continue;
                }
                buf.append(ch);
                lastChr = ch;
                continue;
            }
            buf.append(ch);
            lastChr = ch;
        }
        if (buf.length() > 0) {
            ptn.add(buf.toString());
        }
        return ptn.toArray(Null.StrArr);
    }

    public static boolean match(boolean igc, CharSequence str, String ... ptn) {
        if (str == null && ptn == null) {
            return true;
        }
        if (str == null || ptn == null || ptn.length == 0) {
            return false;
        }
        boolean any = false;
        int strIdx = 0;
        int ptnIdx = 0;
        ArrayDeque<int[]> deque = new ArrayDeque<int[]>(ptn.length);
        int sln = str.length();
        do {
            if (!deque.isEmpty()) {
                int[] array = (int[])deque.pop();
                ptnIdx = array[0];
                strIdx = array[1];
                any = true;
            }
            while (ptnIdx < ptn.length) {
                if (ptn[ptnIdx].equals("*")) {
                    any = true;
                    if (ptnIdx == ptn.length - 1) {
                        strIdx = sln;
                    }
                } else {
                    if (any) {
                        if ((strIdx = Wildcard.index(igc, str, strIdx, ptn[ptnIdx])) == -1) break;
                        int repeat = Wildcard.index(igc, str, strIdx + 1, ptn[ptnIdx]);
                        if (repeat >= 0) {
                            deque.push(new int[]{ptnIdx, repeat});
                        }
                    } else if (Wildcard.index(igc, str, strIdx, ptn[ptnIdx]) == -1) break;
                    strIdx += ptn[ptnIdx].length();
                    any = false;
                }
                ++ptnIdx;
            }
            if (ptnIdx != ptn.length || strIdx != sln) continue;
            return true;
        } while (!deque.isEmpty());
        return false;
    }

    public static int index(@NotNull CharSequence str, @NotNull String ptn) {
        return Wildcard.index(true, str, 0, ptn);
    }

    public static int index(boolean igc, @NotNull CharSequence str, @NotNull String ptn) {
        return Wildcard.index(igc, str, 0, ptn);
    }

    public static int index(boolean igc, @NotNull CharSequence str, int off, @NotNull String ptn) {
        int pln = ptn.length();
        if (pln > str.length() - off) {
            return -1;
        }
        int lop = str.length() - pln;
        block0: for (int i = off; i <= lop; ++i) {
            int j = i;
            for (int k = 0; k < pln; ++k) {
                char c;
                char p = ptn.charAt(k);
                if (p != '?' && p != (c = str.charAt(j)) && (!igc || p != Character.toLowerCase(c) && p != Character.toUpperCase(c))) continue block0;
                ++j;
            }
            return i;
        }
        return -1;
    }
}

