/*
 * Decompiled with CFR 0.152.
 */
package pro.fessional.mirana.anti;

import java.lang.ref.SoftReference;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import pro.fessional.mirana.data.Null;
import pro.fessional.mirana.evil.ThreadLocalAttention;
import pro.fessional.mirana.text.BuilderHolder;
import pro.fessional.mirana.text.FormatUtil;

public class L {
    private static volatile String CateTkn = ":";
    private static volatile String LineTkn = "\n";
    private static final BuilderHolder Builder;
    private static final ThreadLocal<SoftReference<List<D>>> Holder;

    public static String getCateTkn() {
        return CateTkn;
    }

    public static String getLineTkn() {
        return LineTkn;
    }

    public static void setToken(String cate, String line) {
        CateTkn = cate;
        LineTkn = line;
    }

    public static void error(String message) {
        L.error(message, Null.Objects);
    }

    public static void warn(String message) {
        L.warn(message, Null.Objects);
    }

    public static void note(String message) {
        L.note(message, Null.Objects);
    }

    public static void error(String message, Object ... args) {
        L.message("error", message, args);
    }

    public static void warn(String message, Object ... args) {
        L.message("warn", message, args);
    }

    public static void note(String message, Object ... args) {
        L.message("note", message, args);
    }

    public static void message(String message) {
        L.message(null, message, Null.Objects);
    }

    public static void message(String cate, String message) {
        L.message(cate, message, Null.Objects);
    }

    public static void message(String cate, String message, Object ... args) {
        List<D> ds;
        D d = new D(cate, message, args);
        SoftReference<List<D>> ref = Holder.get();
        if (ref != null && (ds = ref.get()) != null) {
            ds.add(d);
            return;
        }
        ds = new ArrayList<D>();
        ds.add(d);
        Holder.set(new SoftReference<List<D>>(ds));
    }

    @NotNull
    public static String finish() {
        List<D> ds = L.inspect();
        String rst = L.format(ds);
        ds.clear();
        return rst;
    }

    @NotNull
    public static List<D> inspect() {
        SoftReference<List<D>> ref = Holder.get();
        if (ref == null) {
            return Collections.emptyList();
        }
        List<D> ds = ref.get();
        return ds == null ? Collections.emptyList() : ds;
    }

    @NotNull
    public static List<D> remove() {
        List<D> ds = L.inspect();
        Holder.remove();
        return ds;
    }

    @NotNull
    public static String format(List<D> ds) {
        if (ds.isEmpty()) {
            return "";
        }
        StringBuilder buff = (StringBuilder)Builder.use();
        for (D d : ds) {
            boolean nm;
            boolean nc = d.cate == null || d.cate.isEmpty();
            boolean bl = nm = d.message == null || d.message.isEmpty();
            if (nc && nm) continue;
            buff.append(LineTkn);
            if (!nc) {
                buff.append(d.cate).append(CateTkn);
            }
            if (nm) continue;
            String msg = FormatUtil.logback(d.message, d.args);
            buff.append(msg);
        }
        return buff.substring(1);
    }

    static {
        try {
            Builder = new BuilderHolder();
        }
        catch (ThreadLocalAttention e) {
            throw new IllegalStateException(e);
        }
        Holder = new ThreadLocal();
    }

    public static class D {
        public final String cate;
        public final String message;
        public final Object[] args;

        public D(String cate, String message, Object ... args) {
            this.cate = cate;
            this.message = message;
            this.args = args;
        }
    }
}

