/*
 * Decompiled with CFR 0.152.
 */
package pro.fessional.mirana.bits;

import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import pro.fessional.mirana.data.Null;
import pro.fessional.mirana.io.InputStreams;

public class Base64 {
    public static Base64.Encoder getEncoder(boolean urlSafe) {
        return Base64.getEncoder(urlSafe, true);
    }

    public static Base64.Encoder getEncoder(boolean urlSafe, boolean noPad) {
        Base64.Encoder encoder = urlSafe ? java.util.Base64.getUrlEncoder() : java.util.Base64.getEncoder();
        return noPad ? encoder.withoutPadding() : encoder;
    }

    @NotNull
    public static String encode(@Nullable String str) {
        return Base64.encode(str, true);
    }

    @NotNull
    public static String encode(@Nullable InputStream ins) {
        return Base64.encode(ins, true);
    }

    @NotNull
    public static String encode(byte[] bytes) {
        return Base64.encode(bytes, true);
    }

    @NotNull
    public static String encode(@Nullable String str, boolean urlSafe) {
        if (str == null) {
            return "";
        }
        return Base64.getEncoder(urlSafe).encodeToString(str.getBytes(StandardCharsets.UTF_8));
    }

    @NotNull
    public static String encode(@Nullable InputStream ins, boolean urlSafe) {
        if (ins == null) {
            return "";
        }
        byte[] bytes = InputStreams.readBytes(ins);
        return Base64.getEncoder(urlSafe).encodeToString(bytes);
    }

    @NotNull
    public static String encode(byte[] bytes, boolean urlSafe) {
        if (bytes == null) {
            return "";
        }
        return Base64.getEncoder(urlSafe).encodeToString(bytes);
    }

    @NotNull
    public static String de2str(@Nullable String str) {
        if (str == null) {
            return "";
        }
        byte[] bytes = Base64.decode(str.getBytes(StandardCharsets.UTF_8));
        return new String(bytes, StandardCharsets.UTF_8);
    }

    @NotNull
    public static String de2str(byte[] bytes) {
        if (bytes == null) {
            return "";
        }
        byte[] res = Base64.decode(bytes);
        return new String(res, StandardCharsets.UTF_8);
    }

    @NotNull
    public static String de2str(@Nullable InputStream ins) {
        if (ins == null) {
            return "";
        }
        byte[] bytes = InputStreams.readBytes(ins);
        byte[] res = Base64.decode(bytes);
        return new String(res, StandardCharsets.UTF_8);
    }

    public static byte @NotNull [] decode(@Nullable String str) {
        if (str == null) {
            return Null.Bytes;
        }
        return Base64.decode(str.getBytes(StandardCharsets.UTF_8));
    }

    public static byte @NotNull [] decode(byte[] bytes) {
        if (bytes == null) {
            return Null.Bytes;
        }
        boolean urlSafe = true;
        for (byte c : bytes) {
            if (c != 43 && c != 47) continue;
            urlSafe = false;
            break;
        }
        Base64.Decoder decoder = urlSafe ? java.util.Base64.getUrlDecoder() : java.util.Base64.getDecoder();
        return decoder.decode(bytes);
    }

    public static byte @NotNull [] decode(@Nullable InputStream ins) {
        if (ins == null) {
            return Null.Bytes;
        }
        byte[] bytes = InputStreams.readBytes(ins);
        return Base64.decode(bytes);
    }

    public static String pad(String b64) {
        if (b64 == null) {
            return "";
        }
        switch (b64.length() % 4) {
            case 1: 
            case 3: {
                return b64 + "=";
            }
            case 2: {
                return b64 + "==";
            }
        }
        return b64;
    }
}

